/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.test;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.test.utilities.BaseRestServerHelper;
import ca.uhn.fhir.test.utilities.RestServerDstu3Helper;
import ca.uhn.fhir.test.utilities.RestServerR4Helper;
import ca.uhn.fhir.test.utilities.TlsAuthenticationTestHelper;
import ca.uhn.fhir.tls.TlsAuthentication;
import java.util.stream.Stream;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.params.provider.Arguments;

public abstract class BaseFhirVersionParameterizedTest {
    @RegisterExtension
    public final RestServerR4Helper myRestServerR4Helper = RestServerR4Helper.newInitialized();
    @RegisterExtension
    public final RestServerDstu3Helper myRestServerDstu3Helper = RestServerDstu3Helper.newInitialized();
    @RegisterExtension
    public TlsAuthenticationTestHelper myTlsAuthenticationTestHelper = new TlsAuthenticationTestHelper();
    protected final FhirContext myR4FhirContext = FhirContext.forR4();
    protected final FhirContext myDstu3FhirContext = FhirContext.forDstu3();

    protected static Stream<Arguments> baseParamsProvider() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{FhirVersionEnum.R4}), Arguments.arguments((Object[])new Object[]{FhirVersionEnum.DSTU3}));
    }

    protected FhirVersionParams getFhirVersionParams(FhirVersionEnum theFhirVersion) {
        switch (theFhirVersion) {
            case R4: {
                return new FhirVersionParams(this.myRestServerR4Helper, this.myR4FhirContext);
            }
            case DSTU3: {
                return new FhirVersionParams(this.myRestServerDstu3Helper, this.myDstu3FhirContext);
            }
        }
        throw new RuntimeException(Msg.code((int)2114) + "Unknown FHIR Version param provided: " + theFhirVersion);
    }

    protected TlsAuthentication getTlsAuthentication() {
        return this.myTlsAuthenticationTestHelper.getTlsAuthentication();
    }

    protected class FhirVersionParams {
        private final BaseRestServerHelper myBaseRestServerHelper;
        private final FhirContext myFhirContext;
        private final FhirVersionEnum myFhirVersion;

        public FhirVersionParams(BaseRestServerHelper theBaseRestServerHelper, FhirContext theFhirContext) {
            this.myBaseRestServerHelper = theBaseRestServerHelper;
            this.myFhirContext = theFhirContext;
            this.myFhirVersion = theFhirContext.getVersion().getVersion();
        }

        public FhirContext getFhirContext() {
            return this.myFhirContext;
        }

        public FhirVersionEnum getFhirVersion() {
            return this.myFhirVersion;
        }

        public String getBase() {
            return this.myBaseRestServerHelper.getBase();
        }

        public String getSecureBase() {
            return this.myBaseRestServerHelper.getSecureBase();
        }

        public String getPatientEndpoint() {
            return this.getBase() + "/Patient";
        }

        public String getSecuredPatientEndpoint() {
            return this.getSecureBase() + "/Patient";
        }

        public IBaseResource parseResource(String json) {
            return this.myFhirContext.newJsonParser().parseResource(json);
        }
    }
}

