/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.test.utilities;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.client.api.ServerValidationModeEnum;
import ca.uhn.fhir.rest.client.interceptor.LoggingInterceptor;
import ca.uhn.fhir.rest.server.HardcodedServerAddressStrategy;
import ca.uhn.fhir.rest.server.IResourceProvider;
import ca.uhn.fhir.rest.server.IServerAddressStrategy;
import ca.uhn.fhir.test.utilities.JettyUtil;
import ca.uhn.fhir.test.utilities.TlsAuthenticationTestHelper;
import ca.uhn.fhir.tls.KeyStoreType;
import jakarta.servlet.Servlet;
import java.security.KeyStore;
import java.util.List;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.junit.jupiter.api.extension.RegisterExtension;

public abstract class BaseRestServerHelper {
    private static int myFirstTargetPort = -1;
    private final String SERVER_KEYSTORE_PATH = "/tls/server-keystore.p12";
    private final String SERVER_TRUSTSTORE_PATH = "/tls/server-truststore.p12";
    private final String PASSWORD = "changeit";
    protected final FhirContext myFhirContext;
    protected int myListenerPort;
    protected int myHttpsListenerPort;
    protected Server myListenerServer;
    protected String myBase;
    protected String mySecureBase;
    protected IGenericClient myClient;
    @RegisterExtension
    public TlsAuthenticationTestHelper myTlsAuthenticationTestHelper = new TlsAuthenticationTestHelper();

    public BaseRestServerHelper(FhirContext theFhirContext) {
        this.myFhirContext = theFhirContext;
    }

    protected void afterEach() throws Exception {
        this.stop();
    }

    public IGenericClient getClient() {
        return this.myClient;
    }

    protected void startServer(Servlet theServlet) throws Exception {
        int n;
        if (myFirstTargetPort == -1) {
            n = 0;
        } else {
            int n2 = myFirstTargetPort;
            n = n2;
            myFirstTargetPort = n2 + 1;
        }
        int port = n;
        this.myListenerServer = new Server(port);
        this.myFhirContext.getRestfulClientFactory().setSocketTimeout(120000);
        ServletContextHandler proxyHandler = new ServletContextHandler();
        proxyHandler.setContextPath("/");
        ServletHolder targetServletHolder = new ServletHolder();
        targetServletHolder.setServlet(theServlet);
        proxyHandler.addServlet(targetServletHolder, "/target/*");
        this.myListenerServer.setHandler((Handler)proxyHandler);
        SslContextFactory.Server sslContextFactory = this.getSslContextFactory();
        HttpConfiguration httpsConfig = new HttpConfiguration();
        httpsConfig.setSecureScheme("https");
        httpsConfig.setSecurePort(0);
        ServerConnector sslConnector = new ServerConnector(this.myListenerServer, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(httpsConfig)});
        sslConnector.setPort(0);
        this.myListenerServer.addConnector((Connector)sslConnector);
        this.myListenerServer.start();
        this.assignHttpAndHttpsPorts();
        this.myBase = "http://localhost:" + this.myListenerPort + "/target";
        this.mySecureBase = "https://localhost:" + this.myHttpsListenerPort + "/target";
        this.myFhirContext.getRestfulClientFactory().setConnectTimeout(60000);
        this.myFhirContext.getRestfulClientFactory().setServerValidationMode(ServerValidationModeEnum.NEVER);
        this.myClient = this.myFhirContext.newRestfulGenericClient(this.myBase);
        this.myClient.registerInterceptor((Object)new LoggingInterceptor(false));
    }

    private void assignHttpAndHttpsPorts() {
        this.myListenerPort = ((ServerConnector)this.myListenerServer.getConnectors()[0]).getLocalPort();
        this.myHttpsListenerPort = ((ServerConnector)this.myListenerServer.getConnectors()[1]).getLocalPort();
    }

    private SslContextFactory.Server getSslContextFactory() {
        try {
            SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
            KeyStore keyStore = KeyStore.getInstance(KeyStoreType.PKCS12.toString());
            keyStore.load(BaseRestServerHelper.class.getResourceAsStream("/tls/server-keystore.p12"), "changeit".toCharArray());
            sslContextFactory.setKeyStore(keyStore);
            sslContextFactory.setKeyStorePassword("changeit");
            KeyStore trustStore = KeyStore.getInstance(KeyStoreType.PKCS12.toString());
            trustStore.load(BaseRestServerHelper.class.getResourceAsStream("/tls/server-truststore.p12"), "changeit".toCharArray());
            sslContextFactory.setTrustStore(trustStore);
            return sslContextFactory;
        }
        catch (Exception e) {
            throw new RuntimeException(Msg.code((int)2123) + "Failed to obtain SslContextFactory", e);
        }
    }

    public String getBase() {
        return this.myBase;
    }

    public String getSecureBase() {
        return this.mySecureBase;
    }

    public void stop() throws Exception {
        JettyUtil.closeServer(this.myListenerServer);
    }

    public abstract void clearDataAndCounts();

    public abstract void setFailNextPut(boolean var1);

    public abstract List<Object> getInterceptors();

    public abstract void unregisterInterceptor(Object var1);

    public abstract void clearCounts();

    public abstract long getPatientCountSearch();

    public abstract long getPatientCountDelete();

    public abstract long getPatientCountUpdate();

    public abstract long getPatientCountRead();

    public abstract long getObservationCountSearch();

    public abstract long getObservationCountDelete();

    public abstract long getObservationCountUpdate();

    public abstract long getObservationCountRead();

    public abstract boolean registerInterceptor(Object var1);

    public abstract IResourceProvider getObservationResourceProvider();

    public abstract IResourceProvider getPatientResourceProvider();

    public abstract IResourceProvider getConceptMapResourceProvider();

    public abstract IIdType createPatientWithId(String var1);

    public abstract IIdType createPatient(IBaseResource var1);

    public abstract IIdType createObservationForPatient(IIdType var1);

    public abstract IIdType createObservation(IBaseResource var1);

    public void setServerAddressStrategy(boolean theUseHttps) {
        String path = theUseHttps ? this.mySecureBase : this.myBase;
        HardcodedServerAddressStrategy strategy = new HardcodedServerAddressStrategy(path);
        this.setServerAddressStrategy((IServerAddressStrategy)strategy);
    }

    public static void setMyFirstTargetPort(int theMyFirstTargetPort) {
        myFirstTargetPort = theMyFirstTargetPort;
    }

    protected abstract void setServerAddressStrategy(IServerAddressStrategy var1);
}

