/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.test.utilities;

import java.io.IOException;
import java.net.URL;
import org.awaitility.Awaitility;
import org.htmlunit.BrowserVersion;
import org.htmlunit.StringWebResponse;
import org.htmlunit.WebClient;
import org.htmlunit.WebResponse;
import org.htmlunit.html.HtmlForm;
import org.htmlunit.html.HtmlInput;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.html.parser.neko.HtmlUnitNekoHtmlParser;

public class HtmlUtil {
    private HtmlUtil() {
    }

    public static HtmlPage parseAsHtml(String theHtml) throws IOException {
        return HtmlUtil.parseAsHtml(theHtml, new URL("http://foo"));
    }

    public static HtmlPage parseAsHtml(String theHtml, URL theUrl) throws IOException {
        StringWebResponse response = new StringWebResponse(theHtml, theUrl);
        WebClient client = new WebClient(BrowserVersion.BEST_SUPPORTED, false, null, -1);
        client.getOptions().setCssEnabled(false);
        client.getOptions().setJavaScriptEnabled(false);
        HtmlPage page = new HtmlPage((WebResponse)response, client.getCurrentWindow());
        HtmlUnitNekoHtmlParser htmlUnitNekoHtmlParser = new HtmlUnitNekoHtmlParser();
        htmlUnitNekoHtmlParser.parse((WebResponse)response, page, false, false);
        return page;
    }

    public static HtmlForm waitForForm(HtmlPage thePage, String theName) {
        return (HtmlForm)Awaitility.await().until(() -> thePage.getFormByName(theName), t -> t != null);
    }

    public static HtmlInput waitForInput(HtmlForm theForm, String theName) {
        return (HtmlInput)Awaitility.await().until(() -> theForm.getInputByName(theName), t -> t != null);
    }
}

