/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.test.utilities;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class HttpClientExtension
implements BeforeEachCallback,
AfterEachCallback {
    private CloseableHttpClient myClient;
    private boolean myDontFollowRedirects;

    public HttpClientExtension dontFollowRedirects() {
        this.myDontFollowRedirects = true;
        return this;
    }

    public CloseableHttpClient getClient() {
        return this.myClient;
    }

    public void afterEach(ExtensionContext theExtensionContext) throws Exception {
        this.myClient.close();
    }

    public void beforeEach(ExtensionContext theExtensionContext) throws Exception {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(5000L, TimeUnit.MILLISECONDS);
        connectionManager.setMaxTotal(99);
        connectionManager.setDefaultMaxPerRoute(99);
        SocketConfig socketConfig = SocketConfig.copy((SocketConfig)SocketConfig.DEFAULT).setSoTimeout(30000).build();
        connectionManager.setDefaultSocketConfig(socketConfig);
        HttpClientBuilder builder = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connectionManager).setMaxConnPerRoute(99);
        if (this.myDontFollowRedirects) {
            builder.disableRedirectHandling();
        }
        this.myClient = builder.build();
    }

    public CloseableHttpResponse execute(HttpUriRequest theRequest) throws IOException {
        return this.myClient.execute(theRequest);
    }
}

