/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.test.utilities;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.util.FhirTerser;
import ca.uhn.fhir.util.MetaUtil;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Date;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.assertj.core.api.Assertions;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseMetaType;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.InstantType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ITestDataBuilder {
    public static final Logger ourLog = LoggerFactory.getLogger(ITestDataBuilder.class);

    public static void __setPrimitiveChild(FhirContext theFhirContext, IBase theTarget, String theElementName, String theElementType, String theValue) {
        BaseRuntimeElementCompositeDefinition def = (BaseRuntimeElementCompositeDefinition)theFhirContext.getElementDefinition(theTarget.getClass());
        BaseRuntimeChildDefinition activeChild = def.getChildByName(theElementName);
        IPrimitiveType booleanType = (IPrimitiveType)activeChild.getChildByName(theElementName).newInstance();
        booleanType.setValueAsString(theValue);
        activeChild.getMutator().addValue(theTarget, (IBase)booleanType);
    }

    default public ICreationArgument withActiveTrue() {
        return t -> ITestDataBuilder.__setPrimitiveChild(this.getFhirContext(), t, "active", "boolean", "true");
    }

    default public ICreationArgument withActiveFalse() {
        return t -> ITestDataBuilder.__setPrimitiveChild(this.getFhirContext(), t, "active", "boolean", "false");
    }

    default public ICreationArgument withLanguage(String theLanguage) {
        return t -> ITestDataBuilder.__setPrimitiveChild(this.getFhirContext(), t, "language", "string", theLanguage);
    }

    default public ICreationArgument withGender(String theGender) {
        return t -> ITestDataBuilder.__setPrimitiveChild(this.getFhirContext(), t, "gender", "code", theGender);
    }

    default public ICreationArgument withFamily(String theFamily) {
        return t -> {
            IPrimitiveType family = (IPrimitiveType)this.getFhirContext().getElementDefinition("string").newInstance();
            family.setValueAsString(theFamily);
            BaseRuntimeElementCompositeDefinition humanNameDef = (BaseRuntimeElementCompositeDefinition)this.getFhirContext().getElementDefinition("HumanName");
            ICompositeType humanName = (ICompositeType)humanNameDef.newInstance();
            humanNameDef.getChildByName("family").getMutator().addValue((IBase)humanName, (IBase)family);
            BaseRuntimeElementCompositeDefinition resourceDef = (BaseRuntimeElementCompositeDefinition)this.getFhirContext().getElementDefinition(t.getClass());
            resourceDef.getChildByName("name").getMutator().addValue(t, (IBase)humanName);
        };
    }

    default public ICreationArgument withGiven(String theName) {
        return this.withResourcePrimitiveAttribute("name.given", theName);
    }

    default public ICreationArgument withBirthdate(String theBirthdate) {
        return t -> ITestDataBuilder.__setPrimitiveChild(this.getFhirContext(), t, "birthDate", "dateTime", theBirthdate);
    }

    default public ICreationArgument withStatus(String theStatus) {
        return t -> ITestDataBuilder.__setPrimitiveChild(this.getFhirContext(), t, "status", "code", theStatus);
    }

    default public ICreationArgument withEffectiveDate(String theDate) {
        return t -> ITestDataBuilder.__setPrimitiveChild(this.getFhirContext(), t, "effectiveDateTime", "dateTime", theDate);
    }

    default public ICreationArgument withDateTimeAt(String thePath, String theDate) {
        return t -> ITestDataBuilder.__setPrimitiveChild(this.getFhirContext(), t, thePath, "dateTime", theDate);
    }

    default public ICreationArgument withIdentifier(String theSystem, String theValue) {
        return t -> {
            IPrimitiveType system = (IPrimitiveType)this.getFhirContext().getElementDefinition("uri").newInstance();
            system.setValueAsString(theSystem);
            IPrimitiveType value = (IPrimitiveType)this.getFhirContext().getElementDefinition("string").newInstance();
            value.setValueAsString(theValue);
            BaseRuntimeElementCompositeDefinition identifierDef = (BaseRuntimeElementCompositeDefinition)this.getFhirContext().getElementDefinition("Identifier");
            ICompositeType identifier = (ICompositeType)identifierDef.newInstance();
            identifierDef.getChildByName("system").getMutator().addValue((IBase)identifier, (IBase)system);
            identifierDef.getChildByName("value").getMutator().addValue((IBase)identifier, (IBase)value);
            RuntimeResourceDefinition resourceDef = this.getFhirContext().getResourceDefinition(t.getClass());
            resourceDef.getChildByName("identifier").getMutator().addValue(t, (IBase)identifier);
        };
    }

    default public ICreationArgument withName(String theStatus) {
        return t -> ITestDataBuilder.__setPrimitiveChild(this.getFhirContext(), t, "name", "string", theStatus);
    }

    default public ICreationArgument withId(String theId) {
        return t -> {
            Assertions.assertThat((String)theId).matches((CharSequence)"[a-zA-Z0-9-]+");
            ((IBaseResource)t).setId(theId);
        };
    }

    default public ICreationArgument withId(IIdType theId) {
        return t -> ((IBaseResource)t).setId(theId.toUnqualifiedVersionless());
    }

    default public ICreationArgument withTag(String theSystem, String theCode, Consumer<IBaseCoding> ... theModifiers) {
        return t -> {
            IBaseCoding coding = ((IBaseResource)t).getMeta().addTag().setSystem(theSystem).setCode(theCode);
            this.applyElementModifiers(coding, theModifiers);
        };
    }

    default public ICreationArgument withSecurity(String theSystem, String theCode) {
        return t -> ((IBaseResource)t).getMeta().addSecurity().setSystem(theSystem).setCode(theCode);
    }

    default public ICreationArgument withProfile(String theProfile) {
        return t -> ((IBaseResource)t).getMeta().addProfile(theProfile);
    }

    default public ICreationArgument withSource(FhirContext theContext, String theSource) {
        return t -> MetaUtil.setSource((FhirContext)theContext, (IBaseMetaType)((IBaseResource)t).getMeta(), (String)theSource);
    }

    default public ICreationArgument withSource(String theSource) {
        return t -> MetaUtil.setSource((FhirContext)this.getFhirContext(), (IBaseMetaType)((IBaseResource)t).getMeta(), (String)theSource);
    }

    default public ICreationArgument withLastUpdated(Date theLastUpdated) {
        return t -> ((IBaseResource)t).getMeta().setLastUpdated(theLastUpdated);
    }

    default public ICreationArgument withLastUpdated(String theIsoDate) {
        return t -> ((IBaseResource)t).getMeta().setLastUpdated((Date)new InstantType(theIsoDate).getValue());
    }

    default public IIdType createEncounter(ICreationArgument ... theModifiers) {
        return this.createResource("Encounter", theModifiers);
    }

    default public IIdType createGroup(ICreationArgument ... theModifiers) {
        return this.createResource("Group", theModifiers);
    }

    default public IIdType createObservation(ICreationArgument ... theModifiers) {
        return this.createResource("Observation", theModifiers);
    }

    default public IIdType createObservation(Collection<ICreationArgument> theModifiers) {
        return this.createResource("Observation", theModifiers.toArray(new ICreationArgument[0]));
    }

    default public IBaseResource buildPatient(ICreationArgument ... theModifiers) {
        return this.buildResource("Patient", theModifiers);
    }

    default public IIdType createPatient(ICreationArgument ... theModifiers) {
        return this.createResource("Patient", theModifiers);
    }

    default public IIdType createOrganization(ICreationArgument ... theModifiers) {
        return this.createResource("Organization", theModifiers);
    }

    default public IIdType createPractitioner(ICreationArgument ... theModifiers) {
        return this.createResource("Practitioner", theModifiers);
    }

    default public IIdType createResource(String theResourceType, ICreationArgument ... theModifiers) {
        Object resource = this.buildResource(theResourceType, theModifiers);
        if (ourLog.isDebugEnabled()) {
            ourLog.debug("Creating {}", (Object)this.getFhirContext().newJsonParser().encodeResourceToString(resource));
        }
        if (StringUtils.isNotBlank((CharSequence)resource.getIdElement().getValue())) {
            return this.doUpdateResource((IBaseResource)resource);
        }
        return this.doCreateResource((IBaseResource)resource);
    }

    default public IIdType createResourceFromJson(String theJson, ICreationArgument ... theModifiers) {
        IBaseResource resource = this.getFhirContext().newJsonParser().parseResource(theJson);
        this.applyElementModifiers(resource, theModifiers);
        if (ourLog.isDebugEnabled()) {
            ourLog.debug("Creating {}", (Object)this.getFhirContext().newJsonParser().encodeResourceToString(resource));
        }
        if (StringUtils.isNotBlank((CharSequence)resource.getIdElement().getValue())) {
            return this.doUpdateResource(resource);
        }
        return this.doCreateResource(resource);
    }

    default public <T extends IBaseResource> T buildResource(String theResourceType, ICreationArgument ... theModifiers) {
        IBaseResource resource = (IBaseResource)this.getFhirContext().getResourceDefinition(theResourceType).newInstance();
        this.applyElementModifiers(resource, theModifiers);
        return (T)resource;
    }

    default public ICreationArgument withSubject(@Nullable IIdType theSubject) {
        return this.withReference("subject", theSubject);
    }

    default public ICreationArgument withSubject(@Nullable String theSubject) {
        return this.withSubject((IIdType)new IdType(theSubject));
    }

    default public ICreationArgument withPatient(@Nullable IIdType theSubject) {
        return this.withReference("patient", theSubject);
    }

    default public ICreationArgument withPatient(@Nullable String theSubject) {
        return this.withSubject((IIdType)new IdType(theSubject));
    }

    default public ICreationArgument withGroupMember(@Nullable IIdType theMember) {
        return this.withResourcePrimitiveAttribute("member.entity.reference", theMember);
    }

    default public ICreationArgument withGroupMember(@Nullable String theMember) {
        return this.withGroupMember((IIdType)new IdType(theMember));
    }

    default public ICreationArgument withEncounter(@Nullable String theEncounter) {
        return this.withReference("encounter", (IIdType)new IdType(theEncounter));
    }

    @Nonnull
    default public ICreationArgument withReference(String theReferenceName, @Nullable IIdType theReferenceValue) {
        return t -> {
            if (theReferenceValue != null && theReferenceValue.getValue() != null) {
                IBaseReference reference = (IBaseReference)this.getFhirContext().getElementDefinition("Reference").newInstance();
                reference.setReference(theReferenceValue.getValue());
                RuntimeResourceDefinition resourceDef = this.getFhirContext().getResourceDefinition((IBaseResource)t);
                resourceDef.getChildByName(theReferenceName).getMutator().addValue(t, (IBase)reference);
            }
        };
    }

    default public Consumer<IBase> withPrimitiveAttribute(String thePath, Object theValue) {
        return t -> {
            FhirTerser terser = this.getFhirContext().newTerser();
            terser.addElement(t, thePath, "" + theValue);
        };
    }

    default public ICreationArgument withResourcePrimitiveAttribute(String thePath, Object theValue) {
        return t -> {
            FhirTerser terser = this.getFhirContext().newTerser();
            terser.addElement(t, thePath, "" + theValue);
        };
    }

    default public <E extends IBase> ICreationArgument withElementAt(String thePath, Consumer<E> ... theModifiers) {
        return t -> {
            FhirTerser terser = this.getFhirContext().newTerser();
            IBase element = terser.addElement(t, thePath);
            this.applyElementModifiers(element, theModifiers);
        };
    }

    default public ICreationArgument withQuantityAtPath(String thePath, Number theValue, String theSystem, String theCode) {
        return this.withElementAt(thePath, this.withPrimitiveAttribute("value", theValue), this.withPrimitiveAttribute("system", theSystem), this.withPrimitiveAttribute("code", theCode));
    }

    default public IBase withElementOfType(String theElementType, Consumer<IBase> ... theModifiers) {
        IBase element = this.getFhirContext().getElementDefinition(theElementType).newInstance();
        this.applyElementModifiers(element, theModifiers);
        return element;
    }

    default public <E extends IBase> void applyElementModifiers(E element, Consumer<E>[] theModifiers) {
        for (Consumer<E> nextModifier : theModifiers) {
            nextModifier.accept(element);
        }
    }

    default public ICreationArgument withObservationCode(@Nullable String theSystem, @Nullable String theCode) {
        return this.withObservationCode(theSystem, theCode, null);
    }

    default public ICreationArgument withObservationCode(@Nullable String theSystem, @Nullable String theCode, @Nullable String theDisplay) {
        return this.withCodingAt("code.coding", theSystem, theCode, theDisplay);
    }

    default public <T extends IBase> ICreationArgument withCodingAt(String thePath, @Nullable String theSystem, @Nullable String theValue) {
        return this.withCodingAt(thePath, theSystem, theValue, null);
    }

    default public <T extends IBase> ICreationArgument withCodingAt(String thePath, @Nullable String theSystem, @Nullable String theValue, @Nullable String theDisplay) {
        return this.withElementAt(thePath, this.withPrimitiveAttribute("system", theSystem), this.withPrimitiveAttribute("code", theValue), this.withPrimitiveAttribute("display", theDisplay));
    }

    default public ICreationArgument withObservationComponent(ICreationArgument ... theModifiers) {
        return this.withElementAt("component", theModifiers);
    }

    default public ICreationArgument withObservationHasMember(@Nullable IIdType theHasMember) {
        return this.withReference("hasMember", theHasMember);
    }

    default public ICreationArgument withOrganization(@Nullable IIdType theHasMember) {
        return this.withReference("managingOrganization", theHasMember);
    }

    public IIdType doCreateResource(IBaseResource var1);

    public IIdType doUpdateResource(IBaseResource var1);

    public FhirContext getFhirContext();

    default public ICreationArgument[] asArray(ICreationArgument theIBaseResourceConsumer) {
        return new ICreationArgument[]{theIBaseResourceConsumer};
    }

    public static interface ICreationArgument
    extends Consumer<IBase> {
    }

    public static class SupportNoDao
    implements Support {
        final FhirContext myFhirContext;

        public SupportNoDao(FhirContext theFhirContext) {
            this.myFhirContext = theFhirContext;
        }

        @Override
        public void setRequestId(String theRequestId) {
        }

        @Override
        public FhirContext getFhirContext() {
            return this.myFhirContext;
        }

        @Override
        public IIdType doCreateResource(IBaseResource theResource) {
            Validate.isTrue((boolean)false, (String)"Create not supported", (Object[])new Object[0]);
            return null;
        }

        @Override
        public IIdType doUpdateResource(IBaseResource theResource) {
            Validate.isTrue((boolean)false, (String)"Update not supported", (Object[])new Object[0]);
            return null;
        }
    }

    public static interface WithSupport
    extends ITestDataBuilder {
        public Support getTestDataBuilderSupport();

        @Override
        default public FhirContext getFhirContext() {
            return this.getTestDataBuilderSupport().getFhirContext();
        }

        @Override
        default public IIdType doCreateResource(IBaseResource theResource) {
            return this.getTestDataBuilderSupport().doCreateResource(theResource);
        }

        @Override
        default public IIdType doUpdateResource(IBaseResource theResource) {
            return this.getTestDataBuilderSupport().doUpdateResource(theResource);
        }
    }

    public static interface Support {
        public void setRequestId(String var1);

        public FhirContext getFhirContext();

        public IIdType doCreateResource(IBaseResource var1);

        public IIdType doUpdateResource(IBaseResource var1);
    }
}

