/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.test.utilities;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.StatisticsHandler;

public class JettyUtil {
    public static int getPortForStartedServer(Server server) {
        assert (server.isStarted());
        Connector[] connectors = server.getConnectors();
        assert (connectors.length == 1);
        return ((ServerConnector)connectors[0]).getLocalPort();
    }

    public static void startServer(@Nonnull Server theServer) throws Exception {
        theServer.insertHandler((Handler.Singleton)new StatisticsHandler());
        theServer.start();
    }

    public static void closeServer(@Nullable Server theServer) throws Exception {
        if (theServer != null) {
            theServer.stop();
            theServer.destroy();
        }
    }
}

