/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.test.utilities;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.LoggerFactory;

public class LogbackLevelOverrideExtension
implements AfterEachCallback {
    private final Map<String, Level> mySavedLevels = new HashMap<String, Level>();

    public void setLogLevel(Class theClass, Level theLevel) {
        String name = theClass.getName();
        this.setLogLevel(name, theLevel);
    }

    public void setLogLevel(String theName, Level theLevel) {
        Logger logger = this.getClassicLogger(theName);
        if (!this.mySavedLevels.containsKey(theName)) {
            this.mySavedLevels.put(theName, logger.getLevel());
        }
        logger.setLevel(theLevel);
    }

    private Logger getClassicLogger(String name) {
        return (Logger)LoggerFactory.getLogger((String)name);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.mySavedLevels.forEach((name, level) -> this.getClassicLogger((String)name).setLevel(level));
        this.mySavedLevels.clear();
    }

    public void resetLevel(Class theClass) {
        String name = theClass.getName();
        if (this.mySavedLevels.containsKey(name)) {
            this.getClassicLogger(name).setLevel(this.mySavedLevels.get(name));
            this.mySavedLevels.remove(name);
        }
    }
}

