/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.test.utilities;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.Part;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.http.cookie.ClientCookie;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.htmlunit.CookieManager;
import org.htmlunit.FormEncodingType;
import org.htmlunit.WebClient;
import org.htmlunit.WebConnection;
import org.htmlunit.WebRequest;
import org.htmlunit.WebResponse;
import org.htmlunit.WebResponseData;
import org.htmlunit.util.Cookie;
import org.htmlunit.util.KeyDataPair;
import org.htmlunit.util.NameValuePair;
import org.springframework.beans.Mergeable;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockHttpSession;
import org.springframework.mock.web.MockPart;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.SmartRequestBuilder;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;

public final class MockMvcWebConnectionForHtmlUnit3
implements WebConnection {
    private final Map<String, MockHttpSession> sessions = new HashMap<String, MockHttpSession>();
    private final MockMvc mockMvc;
    @Nullable
    private final String contextPath;
    private WebClient webClient;
    private static final int MAX_FORWARDS = 100;

    public MockMvcWebConnectionForHtmlUnit3(MockMvc mockMvc, WebClient webClient) {
        this(mockMvc, webClient, "");
    }

    public MockMvcWebConnectionForHtmlUnit3(MockMvc mockMvc, WebClient webClient, @Nullable String contextPath) {
        Assert.notNull((Object)mockMvc, (String)"MockMvc must not be null");
        Assert.notNull((Object)webClient, (String)"WebClient must not be null");
        MockMvcWebConnectionForHtmlUnit3.validateContextPath(contextPath);
        this.webClient = webClient;
        this.mockMvc = mockMvc;
        this.contextPath = contextPath;
    }

    static void validateContextPath(@Nullable String contextPath) {
        if (contextPath == null || contextPath.isEmpty()) {
            return;
        }
        Assert.isTrue((boolean)contextPath.startsWith("/"), () -> "contextPath '" + contextPath + "' must start with '/'.");
        Assert.isTrue((!contextPath.endsWith("/") ? 1 : 0) != 0, () -> "contextPath '" + contextPath + "' must not end with '/'.");
    }

    public void setWebClient(WebClient webClient) {
        Assert.notNull((Object)webClient, (String)"WebClient must not be null");
        this.webClient = webClient;
    }

    public WebResponse getResponse(WebRequest webRequest) throws IOException {
        int forwards;
        long startTime = System.currentTimeMillis();
        HtmlUnitRequestBuilder requestBuilder = new HtmlUnitRequestBuilder(this.sessions, this.webClient, webRequest);
        requestBuilder.setContextPath(this.contextPath);
        MockHttpServletResponse httpServletResponse = this.getResponse(requestBuilder);
        String forwardedUrl = httpServletResponse.getForwardedUrl();
        for (forwards = 0; forwardedUrl != null && forwards < 100; ++forwards) {
            requestBuilder.setForwardPostProcessor(new ForwardRequestPostProcessor(forwardedUrl));
            httpServletResponse = this.getResponse(requestBuilder);
            forwardedUrl = httpServletResponse.getForwardedUrl();
        }
        if (forwards == 100) {
            throw new IllegalStateException("Forwarded " + forwards + " times in a row, potential infinite forward loop");
        }
        this.storeCookies(webRequest, httpServletResponse.getCookies());
        return new MockWebResponseBuilder(startTime, webRequest, httpServletResponse).build();
    }

    private MockHttpServletResponse getResponse(RequestBuilder requestBuilder) throws IOException {
        ResultActions resultActions;
        try {
            resultActions = this.mockMvc.perform(requestBuilder);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        return resultActions.andReturn().getResponse();
    }

    private void storeCookies(WebRequest webRequest, jakarta.servlet.http.Cookie[] cookies) {
        Date now = new Date();
        CookieManager cookieManager = this.webClient.getCookieManager();
        for (jakarta.servlet.http.Cookie cookie : cookies) {
            Cookie toManage;
            Date expires;
            if (cookie.getDomain() == null) {
                cookie.setDomain(webRequest.getUrl().getHost());
            }
            if ((expires = (toManage = MockMvcWebConnectionForHtmlUnit3.createCookie(cookie)).getExpires()) == null || expires.after(now)) {
                cookieManager.addCookie(toManage);
                continue;
            }
            cookieManager.removeCookie(toManage);
        }
    }

    private static Cookie createCookie(jakarta.servlet.http.Cookie cookie) {
        Date expires = null;
        if (cookie.getMaxAge() > -1) {
            expires = new Date(System.currentTimeMillis() + (long)(cookie.getMaxAge() * 1000));
        }
        BasicClientCookie result = new BasicClientCookie(cookie.getName(), cookie.getValue());
        result.setDomain(cookie.getDomain());
        result.setComment(cookie.getComment());
        result.setExpiryDate(expires);
        result.setPath(cookie.getPath());
        result.setSecure(cookie.getSecure());
        if (cookie.isHttpOnly()) {
            result.setAttribute("httponly", "true");
        }
        return new Cookie((ClientCookie)result);
    }

    public void close() {
    }

    final class HtmlUnitRequestBuilder
    implements RequestBuilder,
    Mergeable {
        private final Map<String, MockHttpSession> sessions;
        private final WebClient webClient;
        private final WebRequest webRequest;
        @Nullable
        private String contextPath;
        @Nullable
        private RequestBuilder parentBuilder;
        @Nullable
        private SmartRequestBuilder parentPostProcessor;
        @Nullable
        private RequestPostProcessor forwardPostProcessor;

        public HtmlUnitRequestBuilder(Map<String, MockHttpSession> sessions, WebClient webClient, WebRequest webRequest) {
            Assert.notNull(sessions, (String)"Sessions Map must not be null");
            Assert.notNull((Object)webClient, (String)"WebClient must not be null");
            Assert.notNull((Object)webRequest, (String)"WebRequest must not be null");
            this.sessions = sessions;
            this.webClient = webClient;
            this.webRequest = webRequest;
        }

        public void setContextPath(@Nullable String contextPath) {
            MockMvcWebConnectionForHtmlUnit3.validateContextPath(contextPath);
            this.contextPath = contextPath;
        }

        public void setForwardPostProcessor(RequestPostProcessor forwardPostProcessor) {
            this.forwardPostProcessor = forwardPostProcessor;
        }

        public MockHttpServletRequest buildRequest(ServletContext servletContext) {
            String httpMethod = this.webRequest.getHttpMethod().name();
            UriComponents uri = UriComponentsBuilder.fromUriString((String)this.webRequest.getUrl().toExternalForm()).build();
            HtmlUnitMockHttpServletRequest request = new HtmlUnitMockHttpServletRequest(servletContext, httpMethod, uri.getPath() != null ? uri.getPath() : "");
            this.parent(request, this.parentBuilder);
            request.setProtocol("HTTP/1.1");
            request.setScheme(uri.getScheme() != null ? uri.getScheme() : "");
            request.setServerName(uri.getHost() != null ? uri.getHost() : "");
            this.ports(uri, request);
            this.authType(request);
            this.contextPath(request, uri);
            this.servletPath(uri, request);
            request.setPathInfo(null);
            Charset charset = this.webRequest.getCharset();
            charset = charset != null ? charset : StandardCharsets.ISO_8859_1;
            request.setCharacterEncoding(charset.name());
            this.content(request, charset);
            this.contentType(request);
            this.cookies(request);
            this.webRequest.getAdditionalHeaders().forEach((arg_0, arg_1) -> ((MockHttpServletRequest)request).addHeader(arg_0, arg_1));
            this.locales(request);
            this.params(request);
            request.setQueryString(uri.getQuery());
            return this.postProcess(request);
        }

        private void parent(MockHttpServletRequest request, @Nullable RequestBuilder parent) {
            Object attrValue;
            if (parent == null) {
                return;
            }
            MockHttpServletRequest parentRequest = parent.buildRequest(request.getServletContext());
            HttpSession parentSession = parentRequest.getSession(false);
            if (parentSession != null) {
                HttpSession localSession = request.getSession();
                Assert.state((localSession != null ? 1 : 0) != 0, (String)"No local HttpSession");
                Enumeration attrNames = parentSession.getAttributeNames();
                while (attrNames.hasMoreElements()) {
                    String attrName = (String)attrNames.nextElement();
                    attrValue = parentSession.getAttribute(attrName);
                    localSession.setAttribute(attrName, attrValue);
                }
            }
            Enumeration headerNames = parentRequest.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String attrName = (String)headerNames.nextElement();
                Enumeration attrValues = parentRequest.getHeaders(attrName);
                while (attrValues.hasMoreElements()) {
                    attrValue = (String)attrValues.nextElement();
                    request.addHeader(attrName, attrValue);
                }
            }
            Map parentParams = parentRequest.getParameterMap();
            parentParams.forEach((arg_0, arg_1) -> ((MockHttpServletRequest)request).addParameter(arg_0, arg_1));
            Object[] parentCookies = parentRequest.getCookies();
            if (!ObjectUtils.isEmpty((Object[])parentCookies)) {
                request.setCookies((jakarta.servlet.http.Cookie[])parentCookies);
            }
            Enumeration parentAttrNames = parentRequest.getAttributeNames();
            while (parentAttrNames.hasMoreElements()) {
                String parentAttrName = (String)parentAttrNames.nextElement();
                request.setAttribute(parentAttrName, parentRequest.getAttribute(parentAttrName));
            }
        }

        private void ports(UriComponents uriComponents, MockHttpServletRequest request) {
            int serverPort = uriComponents.getPort();
            request.setServerPort(serverPort);
            if (serverPort == -1) {
                int portConnection = this.webRequest.getUrl().getDefaultPort();
                request.setLocalPort(serverPort);
                request.setRemotePort(portConnection);
            } else {
                request.setRemotePort(serverPort);
            }
        }

        private void authType(MockHttpServletRequest request) {
            String authorization = this.getHeader("Authorization");
            String[] authSplit = StringUtils.split((String)authorization, (String)": ");
            if (authSplit != null) {
                request.setAuthType(authSplit[0]);
            }
        }

        @Nullable
        private String getHeader(String headerName) {
            return (String)this.webRequest.getAdditionalHeaders().get(headerName);
        }

        private void contextPath(MockHttpServletRequest request, UriComponents uriComponents) {
            if (this.contextPath == null) {
                List pathSegments = uriComponents.getPathSegments();
                if (pathSegments.isEmpty()) {
                    request.setContextPath("");
                } else {
                    request.setContextPath("/" + (String)pathSegments.get(0));
                }
            } else {
                String path = uriComponents.getPath();
                Assert.isTrue((path != null && path.startsWith(this.contextPath) ? 1 : 0) != 0, () -> "\"" + uriComponents.getPath() + "\" should start with context path \"" + this.contextPath + "\"");
                request.setContextPath(this.contextPath);
            }
        }

        private void servletPath(UriComponents uriComponents, MockHttpServletRequest request) {
            String path = uriComponents.getPath();
            String requestPath = path != null ? path : "";
            String servletPath = requestPath.substring(request.getContextPath().length());
            servletPath = UriUtils.decode((String)servletPath, (Charset)StandardCharsets.UTF_8);
            request.setServletPath(servletPath);
        }

        private void content(MockHttpServletRequest request, Charset charset) {
            String requestBody = this.webRequest.getRequestBody();
            if (requestBody == null) {
                return;
            }
            request.setContent(requestBody.getBytes(charset));
        }

        private void contentType(MockHttpServletRequest request) {
            FormEncodingType encodingType;
            String contentType = this.getHeader("Content-Type");
            if (contentType == null && (encodingType = this.webRequest.getEncodingType()) != null) {
                contentType = encodingType.getName();
            }
            request.setContentType(contentType != null ? contentType : "*/*");
        }

        private void cookies(MockHttpServletRequest request) {
            ArrayList<jakarta.servlet.http.Cookie> cookies = new ArrayList<jakarta.servlet.http.Cookie>();
            String cookieHeaderValue = this.getHeader("Cookie");
            if (cookieHeaderValue != null) {
                StringTokenizer tokens = new StringTokenizer(cookieHeaderValue, "=;");
                while (tokens.hasMoreTokens()) {
                    String cookieName = tokens.nextToken().trim();
                    Assert.isTrue((boolean)tokens.hasMoreTokens(), () -> "Expected value for cookie name '" + cookieName + "': full cookie header was [" + cookieHeaderValue + "]");
                    String cookieValue = tokens.nextToken().trim();
                    this.processCookie(request, cookies, new jakarta.servlet.http.Cookie(cookieName, cookieValue));
                }
            }
            Set managedCookies = this.webClient.getCookies(this.webRequest.getUrl());
            for (Cookie cookie : managedCookies) {
                this.processCookie(request, cookies, new jakarta.servlet.http.Cookie(cookie.getName(), cookie.getValue()));
            }
            jakarta.servlet.http.Cookie[] parentCookies = request.getCookies();
            if (parentCookies != null) {
                Collections.addAll(cookies, parentCookies);
            }
            if (!ObjectUtils.isEmpty(cookies)) {
                request.setCookies(cookies.toArray(new jakarta.servlet.http.Cookie[0]));
            }
        }

        private void processCookie(MockHttpServletRequest request, List<jakarta.servlet.http.Cookie> cookies, jakarta.servlet.http.Cookie cookie) {
            cookies.add(cookie);
            if ("JSESSIONID".equals(cookie.getName())) {
                request.setRequestedSessionId(cookie.getValue());
                request.setSession((HttpSession)this.httpSession(request, cookie.getValue()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private MockHttpSession httpSession(MockHttpServletRequest request, String sessionid) {
            MockHttpSession session;
            Map<String, MockHttpSession> map = this.sessions;
            synchronized (map) {
                session = this.sessions.get(sessionid);
                if (session == null) {
                    session = new HtmlUnitMockHttpSession(request, sessionid);
                    session.setNew(true);
                    Map<String, MockHttpSession> map2 = this.sessions;
                    synchronized (map2) {
                        this.sessions.put(sessionid, session);
                    }
                    this.addSessionCookie(request, sessionid);
                } else {
                    session.setNew(false);
                }
            }
            return session;
        }

        private void addSessionCookie(MockHttpServletRequest request, String sessionid) {
            this.webClient.getCookieManager().addCookie(this.createCookie(request, sessionid));
        }

        private void removeSessionCookie(MockHttpServletRequest request, String sessionid) {
            this.webClient.getCookieManager().removeCookie(this.createCookie(request, sessionid));
        }

        private Cookie createCookie(MockHttpServletRequest request, String sessionid) {
            return new Cookie(request.getServerName(), "JSESSIONID", sessionid, request.getContextPath() + "/", null, request.isSecure(), true);
        }

        private void locales(MockHttpServletRequest request) {
            String locale = this.getHeader("Accept-Language");
            if (locale == null) {
                request.addPreferredLocale(Locale.getDefault());
            }
        }

        private void params(MockHttpServletRequest request) {
            for (NameValuePair param : this.webRequest.getParameters()) {
                this.addRequestParameter(request, param);
            }
        }

        private void addRequestParameter(MockHttpServletRequest request, NameValuePair param) {
            if (param instanceof KeyDataPair) {
                KeyDataPair pair = (KeyDataPair)param;
                File file = pair.getFile();
                MockPart part = file != null ? new MockPart(pair.getName(), file.getName(), this.readAllBytes(file)) : new MockPart(pair.getName(), pair.getValue(), pair.getData());
                MediaType mediaType = pair.getMimeType() != null ? MediaType.valueOf((String)pair.getMimeType()) : MediaType.APPLICATION_OCTET_STREAM;
                part.getHeaders().setContentType(mediaType);
                request.addPart((Part)part);
            } else {
                request.addParameter(param.getName(), param.getValue());
            }
        }

        private byte[] readAllBytes(File file) {
            try {
                return Files.readAllBytes(file.toPath());
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }

        private MockHttpServletRequest postProcess(MockHttpServletRequest request) {
            if (this.parentPostProcessor != null) {
                request = this.parentPostProcessor.postProcessRequest(request);
            }
            if (this.forwardPostProcessor != null) {
                request = this.forwardPostProcessor.postProcessRequest(request);
            }
            return request;
        }

        public boolean isMergeEnabled() {
            return true;
        }

        public Object merge(@Nullable Object parent) {
            if (parent instanceof RequestBuilder) {
                RequestBuilder requestBuilder = (RequestBuilder)parent;
                if (parent instanceof MockHttpServletRequestBuilder) {
                    MockHttpServletRequestBuilder copiedParent = MockMvcRequestBuilders.get((String)"/", (Object[])new Object[0]);
                    copiedParent.merge(parent);
                    this.parentBuilder = copiedParent;
                } else {
                    this.parentBuilder = requestBuilder;
                }
                if (parent instanceof SmartRequestBuilder) {
                    SmartRequestBuilder smartRequestBuilder;
                    this.parentPostProcessor = smartRequestBuilder = (SmartRequestBuilder)parent;
                }
            }
            return this;
        }

        private final class HtmlUnitMockHttpServletRequest
        extends MockHttpServletRequest {
            public HtmlUnitMockHttpServletRequest(ServletContext servletContext, String method, String requestURI) {
                super(servletContext, method, requestURI);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public HttpSession getSession(boolean create) {
                Object session = super.getSession(false);
                if (session == null && create) {
                    HtmlUnitMockHttpSession newSession = new HtmlUnitMockHttpSession(this);
                    this.setSession((HttpSession)newSession);
                    newSession.setNew(true);
                    String sessionid = newSession.getId();
                    Map<String, MockHttpSession> map = HtmlUnitRequestBuilder.this.sessions;
                    synchronized (map) {
                        HtmlUnitRequestBuilder.this.sessions.put(sessionid, newSession);
                    }
                    HtmlUnitRequestBuilder.this.addSessionCookie(this, sessionid);
                    session = newSession;
                }
                return session;
            }
        }

        private final class HtmlUnitMockHttpSession
        extends MockHttpSession {
            private final MockHttpServletRequest request;

            public HtmlUnitMockHttpSession(MockHttpServletRequest request) {
                super(request.getServletContext());
                this.request = request;
            }

            private HtmlUnitMockHttpSession(MockHttpServletRequest request, String id) {
                super(request.getServletContext(), id);
                this.request = request;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void invalidate() {
                super.invalidate();
                Map<String, MockHttpSession> map = HtmlUnitRequestBuilder.this.sessions;
                synchronized (map) {
                    HtmlUnitRequestBuilder.this.sessions.remove(this.getId());
                }
                HtmlUnitRequestBuilder.this.removeSessionCookie(this.request, this.getId());
            }
        }
    }

    final class ForwardRequestPostProcessor
    implements RequestPostProcessor {
        private final String forwardedUrl;

        public ForwardRequestPostProcessor(String forwardedUrl) {
            Assert.hasText((String)forwardedUrl, (String)"Forwarded URL must not be null or empty");
            this.forwardedUrl = forwardedUrl;
        }

        public MockHttpServletRequest postProcessRequest(MockHttpServletRequest request) {
            request.setRequestURI(this.forwardedUrl);
            request.setServletPath(this.initServletPath(request.getContextPath()));
            return request;
        }

        private String initServletPath(String contextPath) {
            if (StringUtils.hasText((String)contextPath)) {
                Assert.state((boolean)this.forwardedUrl.startsWith(contextPath), (String)"Forward supported to same contextPath only");
                return this.forwardedUrl.length() > contextPath.length() ? this.forwardedUrl.substring(contextPath.length()) : "";
            }
            return this.forwardedUrl;
        }
    }

    final class MockWebResponseBuilder {
        private static final String DEFAULT_STATUS_MESSAGE = "N/A";
        private final long startTime;
        private final WebRequest webRequest;
        private final MockHttpServletResponse response;

        public MockWebResponseBuilder(long startTime, WebRequest webRequest, MockHttpServletResponse response) {
            Assert.notNull((Object)webRequest, (String)"WebRequest must not be null");
            Assert.notNull((Object)response, (String)"HttpServletResponse must not be null");
            this.startTime = startTime;
            this.webRequest = webRequest;
            this.response = response;
        }

        public WebResponse build() throws IOException {
            WebResponseData webResponseData = this.webResponseData();
            long endTime = System.currentTimeMillis();
            return new WebResponse(webResponseData, this.webRequest, endTime - this.startTime);
        }

        private WebResponseData webResponseData() throws IOException {
            List<NameValuePair> responseHeaders = this.responseHeaders();
            int statusCode = this.response.getRedirectedUrl() != null ? HttpStatus.MOVED_PERMANENTLY.value() : this.response.getStatus();
            String statusMessage = this.statusMessage(statusCode);
            return new WebResponseData(this.response.getContentAsByteArray(), statusCode, statusMessage, responseHeaders);
        }

        private String statusMessage(int statusCode) {
            String errorMessage = this.response.getErrorMessage();
            if (StringUtils.hasText((String)errorMessage)) {
                return errorMessage;
            }
            try {
                return HttpStatus.valueOf((int)statusCode).getReasonPhrase();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return DEFAULT_STATUS_MESSAGE;
            }
        }

        private List<NameValuePair> responseHeaders() {
            Collection headerNames = this.response.getHeaderNames();
            ArrayList<NameValuePair> responseHeaders = new ArrayList<NameValuePair>(headerNames.size());
            for (String headerName : headerNames) {
                List headerValues = this.response.getHeaderValues(headerName);
                for (Object value : headerValues) {
                    responseHeaders.add(new NameValuePair(headerName, String.valueOf(value)));
                }
            }
            String location = this.response.getRedirectedUrl();
            if (location != null) {
                responseHeaders.add(new NameValuePair("Location", location));
            }
            return responseHeaders;
        }
    }
}

