/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.test.utilities;

import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;

public class RangeTestHelper {
    public static final double THOUSANDTH = 0.001;

    public static void checkInRange(double base, double value) {
        RangeTestHelper.checkInRange(base, 0.001, value);
    }

    public static void checkInRange(double theBase, double theRange, double theValue) {
        double lowerBound = theBase - theRange;
        double upperBound = theBase + theRange;
        Assertions.assertThat((double)theValue).isGreaterThanOrEqualTo(lowerBound).isLessThanOrEqualTo(upperBound);
    }

    public static void checkInRange(String theBase, String theValue) {
        if (theBase == null && theValue == null) {
            return;
        }
        double value = Double.parseDouble(theValue);
        double base = Double.parseDouble(theBase);
        RangeTestHelper.checkInRange(base, 0.001, value);
    }

    public static void checkInRange(String theBase, double theRange, String theValue) {
        if (theBase == null && theValue == null) {
            return;
        }
        double value = Double.parseDouble(theValue);
        double base = Double.parseDouble(theBase);
        RangeTestHelper.checkInRange(base, theRange, value);
    }

    public static void checkWithinBounds(String theLowerBound, String theUpperBound, String theValue) {
        ((AbstractStringAssert)Assertions.assertThat((String)theLowerBound).as("theLowerBound", new Object[0])).isNotNull();
        ((AbstractStringAssert)Assertions.assertThat((String)theUpperBound).as("theUpperBound", new Object[0])).isNotNull();
        ((AbstractStringAssert)Assertions.assertThat((String)theValue).as("theValue", new Object[0])).isNotNull();
        double lowerBound = Double.parseDouble(theLowerBound);
        double upperBound = Double.parseDouble(theUpperBound);
        double value = Double.parseDouble(theValue);
        Assertions.assertThat((double)value).isGreaterThanOrEqualTo(lowerBound).isLessThanOrEqualTo(upperBound);
    }
}

