/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.test.utilities;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.rest.annotation.Transaction;
import ca.uhn.fhir.rest.annotation.TransactionParam;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.IResourceProvider;
import ca.uhn.fhir.rest.server.IServerAddressStrategy;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import ca.uhn.fhir.rest.server.provider.HashMapResourceProvider;
import ca.uhn.fhir.test.utilities.BaseRestServerHelper;
import ca.uhn.test.concurrency.IPointcutLatch;
import ca.uhn.test.concurrency.PointcutLatch;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.hl7.fhir.dstu3.model.ConceptMap;
import org.hl7.fhir.dstu3.model.Observation;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class RestServerDstu3Helper
extends BaseRestServerHelper
implements IPointcutLatch,
BeforeEachCallback,
AfterEachCallback {
    protected final MyRestfulServer myRestServer;

    public RestServerDstu3Helper() {
        this(false, false);
    }

    private RestServerDstu3Helper(boolean theInitialize, boolean theTransactionLatchEnabled) {
        super(FhirContext.forDstu3());
        this.myRestServer = new MyRestfulServer(this.myFhirContext, theTransactionLatchEnabled);
        if (theInitialize) {
            try {
                this.myRestServer.initialize();
            }
            catch (ServletException e) {
                throw new RuntimeException(Msg.code((int)2252) + "Failed to initialize server", e);
            }
        }
    }

    public static RestServerDstu3Helper newInitialized() {
        return new RestServerDstu3Helper(true, false);
    }

    public static RestServerDstu3Helper newWithTransactionLatch() {
        return new RestServerDstu3Helper(false, true);
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.startServer((Servlet)this.myRestServer);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        super.afterEach();
        this.myRestServer.getInterceptorService().unregisterAllAnonymousInterceptors();
        this.myRestServer.clearDataAndCounts();
    }

    @Override
    public void clearDataAndCounts() {
        this.myRestServer.clearDataAndCounts();
    }

    @Override
    public void setFailNextPut(boolean theFailNextPut) {
        this.myRestServer.setFailNextPut(theFailNextPut);
    }

    @Override
    public List<Object> getInterceptors() {
        return this.myRestServer.getInterceptorService().getAllRegisteredInterceptors();
    }

    @Override
    public void unregisterInterceptor(Object theInterceptor) {
        this.myRestServer.getInterceptorService().unregisterInterceptor(theInterceptor);
    }

    @Override
    public void clearCounts() {
        this.myRestServer.clearCounts();
    }

    @Override
    public long getPatientCountSearch() {
        return this.myRestServer.getPatientResourceProvider().getCountSearch();
    }

    @Override
    public long getPatientCountDelete() {
        return this.myRestServer.getPatientResourceProvider().getCountDelete();
    }

    @Override
    public long getPatientCountUpdate() {
        return this.myRestServer.getPatientResourceProvider().getCountUpdate();
    }

    @Override
    public long getPatientCountRead() {
        return this.myRestServer.getPatientResourceProvider().getCountRead();
    }

    @Override
    public long getObservationCountSearch() {
        return this.myRestServer.getObservationResourceProvider().getCountSearch();
    }

    @Override
    public long getObservationCountDelete() {
        return this.myRestServer.getObservationResourceProvider().getCountDelete();
    }

    @Override
    public long getObservationCountUpdate() {
        return this.myRestServer.getObservationResourceProvider().getCountUpdate();
    }

    @Override
    public long getObservationCountRead() {
        return this.myRestServer.getObservationResourceProvider().getCountRead();
    }

    @Override
    public boolean registerInterceptor(Object theInterceptor) {
        return this.myRestServer.getInterceptorService().registerInterceptor(theInterceptor);
    }

    @Override
    public void clear() {
        this.myRestServer.getPlainProvider().clear();
    }

    @Override
    public void setExpectedCount(int theCount) {
        this.myRestServer.getPlainProvider().setExpectedCount(theCount);
    }

    @Override
    public List<HookParams> awaitExpected() throws InterruptedException {
        return this.myRestServer.getPlainProvider().awaitExpected();
    }

    public void registerProvider(Object theProvider) {
        this.myRestServer.registerProvider(theProvider);
    }

    public HashMapResourceProvider<Observation> getObservationResourceProvider() {
        return this.myRestServer.getObservationResourceProvider();
    }

    public HashMapResourceProvider<Patient> getPatientResourceProvider() {
        return this.myRestServer.getPatientResourceProvider();
    }

    public HashMapResourceProvider<ConceptMap> getConceptMapResourceProvider() {
        return this.myRestServer.getConceptMapResourceProvider();
    }

    @Override
    public IIdType createPatientWithId(String theId) {
        Patient patient = new Patient();
        patient.setId("Patient/" + theId);
        patient.addIdentifier().setSystem("http://foo").setValue(theId);
        return this.createPatient((IBaseResource)patient);
    }

    @Override
    public IIdType createPatient(IBaseResource theBaseResource) {
        return this.myRestServer.getPatientResourceProvider().store((IBaseResource)((Patient)theBaseResource));
    }

    @Override
    public IIdType createObservationForPatient(IIdType theFirstTargetPatientId) {
        Observation observation = new Observation();
        observation.setSubject(new Reference(theFirstTargetPatientId));
        return this.createObservation((IBaseResource)observation);
    }

    @Override
    public IIdType createObservation(IBaseResource theBaseResource) {
        return this.myRestServer.getObservationResourceProvider().store((IBaseResource)((Observation)theBaseResource));
    }

    @Override
    protected void setServerAddressStrategy(IServerAddressStrategy theServerAddressStrategy) {
        this.myRestServer.setServerAddressStrategy(theServerAddressStrategy);
    }

    public void setConceptMapResourceProvider(HashMapResourceProvider<ConceptMap> theResourceProvider) {
        this.myRestServer.setConceptMapResourceProvider(theResourceProvider);
    }

    private static class MyRestfulServer
    extends RestfulServer {
        private boolean myFailNextPut;
        private HashMapResourceProvider<Patient> myPatientResourceProvider;
        private HashMapResourceProvider<Observation> myObservationResourceProvider;
        private HashMapResourceProvider<Organization> myOrganizationResourceProvider;
        private HashMapResourceProvider<ConceptMap> myConceptMapResourceProvider;
        private MyPlainProvider myPlainProvider;
        private final boolean myInitialTransactionLatchEnabled;

        public MyRestfulServer(FhirContext theFhirContext, boolean theInitialTransactionLatchEnabled) {
            super(theFhirContext);
            this.myInitialTransactionLatchEnabled = theInitialTransactionLatchEnabled;
        }

        public MyPlainProvider getPlainProvider() {
            return this.myPlainProvider;
        }

        public <T> T executeWithLatch(Supplier<T> theSupplier) throws InterruptedException {
            this.myPlainProvider.setExpectedCount(1);
            T retval = theSupplier.get();
            this.myPlainProvider.awaitExpected();
            return retval;
        }

        public void setFailNextPut(boolean theFailNextPut) {
            this.myFailNextPut = theFailNextPut;
        }

        public void clearCounts() {
            for (IResourceProvider next : this.getResourceProviders()) {
                if (!(next instanceof HashMapResourceProvider)) continue;
                HashMapResourceProvider provider = (HashMapResourceProvider)next;
                provider.clearCounts();
            }
            if (this.isTransactionLatchEnabled()) {
                this.getPlainProvider().clear();
            }
        }

        private boolean isTransactionLatchEnabled() {
            if (this.getPlainProvider() == null) {
                return false;
            }
            return this.getPlainProvider().isTransactionLatchEnabled();
        }

        public void clearDataAndCounts() {
            for (IResourceProvider next : this.getResourceProviders()) {
                if (!(next instanceof HashMapResourceProvider)) continue;
                HashMapResourceProvider provider = (HashMapResourceProvider)next;
                provider.clear();
            }
            this.clearCounts();
        }

        public HashMapResourceProvider<Observation> getObservationResourceProvider() {
            return this.myObservationResourceProvider;
        }

        public HashMapResourceProvider<Organization> getOrganizationResourceProvider() {
            return this.myOrganizationResourceProvider;
        }

        public HashMapResourceProvider<ConceptMap> getConceptMapResourceProvider() {
            return this.myConceptMapResourceProvider;
        }

        public HashMapResourceProvider<Patient> getPatientResourceProvider() {
            return this.myPatientResourceProvider;
        }

        protected void initialize() throws ServletException {
            super.initialize();
            FhirContext fhirContext = this.getFhirContext();
            this.myPatientResourceProvider = new MyHashMapResourceProvider<Patient>(fhirContext, Patient.class);
            this.registerProvider(this.myPatientResourceProvider);
            this.myObservationResourceProvider = new MyHashMapResourceProvider<Observation>(fhirContext, Observation.class);
            this.registerProvider(this.myObservationResourceProvider);
            this.myOrganizationResourceProvider = new MyHashMapResourceProvider<Organization>(fhirContext, Organization.class);
            this.registerProvider(this.myOrganizationResourceProvider);
            this.myConceptMapResourceProvider = new MyHashMapResourceProvider<ConceptMap>(fhirContext, ConceptMap.class);
            this.registerProvider(this.myConceptMapResourceProvider);
            this.myPlainProvider = new MyPlainProvider(this.myInitialTransactionLatchEnabled);
            this.registerProvider(this.myPlainProvider);
        }

        public void setConceptMapResourceProvider(HashMapResourceProvider<ConceptMap> theResourceProvider) {
            this.myConceptMapResourceProvider.getStoredResources().forEach(c -> theResourceProvider.store((IBaseResource)c));
            this.unregisterProvider(this.myConceptMapResourceProvider);
            this.registerProvider(theResourceProvider);
            this.myConceptMapResourceProvider = theResourceProvider;
        }

        public class MyHashMapResourceProvider<T extends IBaseResource>
        extends HashMapResourceProvider<T> {
            public MyHashMapResourceProvider(FhirContext theContext, Class theType) {
                super(theContext, theType);
            }

            public MethodOutcome update(T theResource, String theConditional, RequestDetails theRequestDetails) {
                if (MyRestfulServer.this.myFailNextPut) {
                    throw new PreconditionFailedException(Msg.code((int)2251) + "Failed update operation");
                }
                return super.update(theResource, theConditional, theRequestDetails);
            }
        }
    }

    public static class MyPlainProvider
    implements IPointcutLatch {
        private final PointcutLatch myPointcutLatch = new PointcutLatch("Transaction Counting Provider");
        private final List<IBaseBundle> myTransactions = Collections.synchronizedList(new ArrayList());
        private boolean myTransactionLatchEnabled;

        public MyPlainProvider(boolean theTransactionLatchEnabled) {
            this.myTransactionLatchEnabled = theTransactionLatchEnabled;
        }

        @Transaction
        public synchronized IBaseBundle transaction(@TransactionParam IBaseBundle theBundle) {
            if (this.myTransactionLatchEnabled) {
                this.myPointcutLatch.call(theBundle);
            }
            this.myTransactions.add(theBundle);
            return theBundle;
        }

        @Override
        public void clear() {
            if (!this.myTransactionLatchEnabled) {
                throw new IllegalStateException("Can't call clear() on a provider that doesn't use a latch");
            }
            this.myPointcutLatch.clear();
        }

        @Override
        public void setExpectedCount(int theCount) {
            if (!this.myTransactionLatchEnabled) {
                throw new IllegalStateException("Can't call clear() on a provider that doesn't use a latch");
            }
            this.myPointcutLatch.setExpectedCount(theCount);
        }

        @Override
        public List<HookParams> awaitExpected() throws InterruptedException {
            if (!this.myTransactionLatchEnabled) {
                throw new IllegalStateException("Can't call clear() on a provider that doesn't use a latch");
            }
            return this.myPointcutLatch.awaitExpected();
        }

        public List<IBaseBundle> getTransactions() {
            return Collections.unmodifiableList(new ArrayList<IBaseBundle>(this.myTransactions));
        }

        public void setTransactionLatchEnabled(boolean theTransactionLatchEnabled) {
            this.myTransactionLatchEnabled = theTransactionLatchEnabled;
        }

        public boolean isTransactionLatchEnabled() {
            return this.myTransactionLatchEnabled;
        }
    }
}

