/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.test.utilities;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorService;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.api.PagingHttpMethodEnum;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.FifoMemoryPagingProvider;
import ca.uhn.fhir.rest.server.IPagingProvider;
import ca.uhn.fhir.rest.server.IResourceProvider;
import ca.uhn.fhir.rest.server.IServerAddressStrategy;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import ca.uhn.fhir.rest.server.provider.HashMapResourceProvider;
import ca.uhn.fhir.test.utilities.BaseRestServerHelper;
import ca.uhn.fhir.test.utilities.RestServerDstu3Helper;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jetty.ee10.servlet.ServletApiRequest;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.Observation;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Reference;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class RestServerR4Helper
extends BaseRestServerHelper
implements BeforeEachCallback,
AfterEachCallback {
    private final MyRestfulServer myRestServer;
    private static IPagingProvider myPagingProvider = new FifoMemoryPagingProvider(20);

    public RestServerR4Helper() {
        this(false, false);
    }

    private RestServerR4Helper(boolean theInitialize, boolean theTransactionLatchEnabled) {
        super(FhirContext.forR4Cached());
        this.myRestServer = new MyRestfulServer(this.myFhirContext, theTransactionLatchEnabled);
        if (theInitialize) {
            try {
                this.myRestServer.initialize();
            }
            catch (ServletException e) {
                throw new RuntimeException(Msg.code((int)2110) + "Failed to initialize server", e);
            }
        }
    }

    public static RestServerR4Helper newWithTransactionLatch() {
        return new RestServerR4Helper(false, true);
    }

    public static RestServerR4Helper newInitialized() {
        return new RestServerR4Helper(true, false);
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.startServer((Servlet)this.myRestServer);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        super.afterEach();
        this.myRestServer.getInterceptorService().unregisterAllAnonymousInterceptors();
        this.myRestServer.clearDataAndCounts();
    }

    public List<Bundle> getTransactions() {
        List<IBaseBundle> transactions = this.myRestServer.getPlainProvider().getTransactions();
        transactions = new ArrayList<IBaseBundle>(transactions);
        return transactions.stream().map(t -> (Bundle)t).collect(Collectors.toList());
    }

    @Override
    public void clearDataAndCounts() {
        this.myRestServer.clearDataAndCounts();
    }

    @Override
    public void setFailNextPut(boolean theFailNextPut) {
        this.myRestServer.setFailNextPut(theFailNextPut);
    }

    @Override
    public List<Object> getInterceptors() {
        return this.myRestServer.getInterceptorService().getAllRegisteredInterceptors();
    }

    @Override
    public void unregisterInterceptor(Object theInterceptor) {
        this.myRestServer.getInterceptorService().unregisterInterceptor(theInterceptor);
    }

    @Override
    public void clearCounts() {
        this.myRestServer.clearCounts();
    }

    @Override
    public long getPatientCountSearch() {
        return this.myRestServer.getPatientResourceProvider().getCountSearch();
    }

    @Override
    public long getPatientCountDelete() {
        return this.myRestServer.getPatientResourceProvider().getCountDelete();
    }

    @Override
    public long getPatientCountUpdate() {
        return this.myRestServer.getPatientResourceProvider().getCountUpdate();
    }

    @Override
    public long getPatientCountRead() {
        return this.myRestServer.getPatientResourceProvider().getCountRead();
    }

    @Override
    public long getObservationCountSearch() {
        return this.myRestServer.getObservationResourceProvider().getCountSearch();
    }

    @Override
    public long getObservationCountDelete() {
        return this.myRestServer.getObservationResourceProvider().getCountDelete();
    }

    @Override
    public long getObservationCountUpdate() {
        return this.myRestServer.getObservationResourceProvider().getCountUpdate();
    }

    @Override
    public long getObservationCountRead() {
        return this.myRestServer.getObservationResourceProvider().getCountRead();
    }

    @Override
    public boolean registerInterceptor(Object theInterceptor) {
        return this.myRestServer.getInterceptorService().registerInterceptor(theInterceptor);
    }

    public void registerProvider(Object theProvider) {
        this.myRestServer.registerProvider(theProvider);
    }

    public void setExpectedCount(int theCount) {
        this.myRestServer.getPlainProvider().setExpectedCount(theCount);
    }

    public List<HookParams> awaitExpected() throws InterruptedException {
        return this.myRestServer.getPlainProvider().awaitExpected();
    }

    public HashMapResourceProvider<Observation> getObservationResourceProvider() {
        return this.myRestServer.getObservationResourceProvider();
    }

    public void setObservationResourceProvider(HashMapResourceProvider<Observation> theResourceProvider) {
        this.myRestServer.setObservationResourceProvider(theResourceProvider);
    }

    public HashMapResourceProvider<Patient> getPatientResourceProvider() {
        return this.myRestServer.getPatientResourceProvider();
    }

    public void setPatientResourceProvider(HashMapResourceProvider<Patient> theResourceProvider) {
        this.myRestServer.setPatientResourceProvider(theResourceProvider);
    }

    public HashMapResourceProvider<ConceptMap> getConceptMapResourceProvider() {
        return this.myRestServer.getConceptMapResourceProvider();
    }

    public void setConceptMapResourceProvider(HashMapResourceProvider<ConceptMap> theResourceProvider) {
        this.myRestServer.setConceptMapResourceProvider(theResourceProvider);
    }

    public <T extends IBaseResource> HashMapResourceProvider<T> getResourceProvider(Class<T> theResourceType) {
        HashMapResourceProvider<?> resourceProvider = this.myRestServer.myResourceProvidersMap.get(theResourceType);
        assert (resourceProvider != null) : "No resource provider defined for resource type: '" + theResourceType + "'";
        return resourceProvider;
    }

    public <T extends IBaseResource> void setResourceProvider(HashMapResourceProvider<T> theResourceProvider) {
        assert (theResourceProvider.getResourceType() != null) : "resourceProvider doesn't have a resourceType";
        HashMapResourceProvider<?> resourceProvider = this.myRestServer.myResourceProvidersMap.get(theResourceProvider.getResourceType());
        if (resourceProvider != null) {
            resourceProvider.getStoredResources().forEach(arg_0 -> theResourceProvider.store(arg_0));
            this.myRestServer.unregisterProvider(resourceProvider);
        }
        this.registerProvider(theResourceProvider);
        this.myRestServer.myResourceProvidersMap.put(theResourceProvider.getResourceType(), theResourceProvider);
    }

    public void setPagingProvider(IPagingProvider thePagingProvider) {
        myPagingProvider = thePagingProvider;
    }

    @Override
    public IIdType createPatientWithId(String theId) {
        Patient patient = new Patient();
        patient.setId("Patient/" + theId);
        patient.addIdentifier().setSystem("http://foo").setValue(theId);
        return this.createPatient((IBaseResource)patient);
    }

    @Override
    public IIdType createPatient(IBaseResource theBaseResource) {
        return this.myRestServer.getPatientResourceProvider().store((IBaseResource)((Patient)theBaseResource));
    }

    @Override
    public IIdType createObservationForPatient(IIdType thePatientId) {
        Observation observation = new Observation();
        observation.setSubject(new Reference(thePatientId));
        return this.createObservation((IBaseResource)observation);
    }

    @Override
    public IIdType createObservation(IBaseResource theBaseResource) {
        return this.myRestServer.getObservationResourceProvider().store((IBaseResource)((Observation)theBaseResource));
    }

    public List<String> getRequestUrls() {
        return this.myRestServer.myRequestUrls;
    }

    public List<String> getRequestVerbs() {
        return this.myRestServer.myRequestVerbs;
    }

    public List<Map<String, String>> getRequestHeaders() {
        return this.myRestServer.myRequestHeaders;
    }

    public IInterceptorService getInterceptorService() {
        return this.myRestServer.getInterceptorService();
    }

    @Override
    public void setServerAddressStrategy(IServerAddressStrategy theServerAddressStrategy) {
        this.myRestServer.setServerAddressStrategy(theServerAddressStrategy);
    }

    public void executeWithLatch(Runnable theRunnable) throws InterruptedException {
        this.myRestServer.executeWithLatch(theRunnable);
    }

    public void enableTransactionLatch(boolean theTransactionLatchEnabled) {
        this.myRestServer.setTransactionLatchEnabled(theTransactionLatchEnabled);
    }

    public void setHttpMethodForPagingRequest(PagingHttpMethodEnum thePagingHttpMethod) {
        this.myRestServer.setHttpMethodForPagingRequest(thePagingHttpMethod);
    }

    private static class MyRestfulServer
    extends RestfulServer {
        private final List<String> myRequestUrls = Collections.synchronizedList(new ArrayList());
        private final List<String> myRequestVerbs = Collections.synchronizedList(new ArrayList());
        private final List<Map<String, String>> myRequestHeaders = Collections.synchronizedList(new ArrayList());
        private boolean myFailNextPut;
        private HashMapResourceProvider<Patient> myPatientResourceProvider;
        private HashMapResourceProvider<Observation> myObservationResourceProvider;
        private HashMapResourceProvider<Organization> myOrganizationResourceProvider;
        private HashMapResourceProvider<ConceptMap> myConceptMapResourceProvider;
        private RestServerDstu3Helper.MyPlainProvider myPlainProvider;
        private final Map<Class<?>, HashMapResourceProvider<?>> myResourceProvidersMap = new HashMap();
        private final boolean myInitialTransactionLatchEnabled;
        private PagingHttpMethodEnum myPagingHttpMethod = PagingHttpMethodEnum.GET;

        public MyRestfulServer(FhirContext theFhirContext, boolean theInitialTransactionLatchEnabled) {
            super(theFhirContext);
            this.myInitialTransactionLatchEnabled = theInitialTransactionLatchEnabled;
        }

        public RestServerDstu3Helper.MyPlainProvider getPlainProvider() {
            return this.myPlainProvider;
        }

        protected boolean isTransactionLatchEnabled() {
            if (this.getPlainProvider() == null) {
                return false;
            }
            return this.getPlainProvider().isTransactionLatchEnabled();
        }

        public void setTransactionLatchEnabled(boolean theTransactionLatchEnabled) {
            this.getPlainProvider().setTransactionLatchEnabled(theTransactionLatchEnabled);
        }

        public void setHttpMethodForPagingRequest(PagingHttpMethodEnum thePagingHttpMethod) {
            this.myPagingHttpMethod = thePagingHttpMethod;
        }

        protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            RequestTypeEnum requestType = this.myPagingHttpMethod == PagingHttpMethodEnum.POST ? RequestTypeEnum.GET : RequestTypeEnum.POST;
            super.handleRequest(requestType, request, response);
        }

        public void executeWithLatch(Runnable theRunnable) throws InterruptedException {
            this.myPlainProvider.setExpectedCount(1);
            theRunnable.run();
            this.myPlainProvider.awaitExpected();
        }

        public void setFailNextPut(boolean theFailNextPut) {
            this.myFailNextPut = theFailNextPut;
        }

        public void clearCounts() {
            for (IResourceProvider next : this.getResourceProviders()) {
                if (!(next instanceof HashMapResourceProvider)) continue;
                HashMapResourceProvider provider = (HashMapResourceProvider)next;
                provider.clearCounts();
            }
            if (this.isTransactionLatchEnabled()) {
                this.myPlainProvider.clear();
            }
            this.myRequestUrls.clear();
            this.myRequestVerbs.clear();
        }

        protected void service(HttpServletRequest theReq, HttpServletResponse theResp) throws ServletException, IOException {
            ServletApiRequest request = (ServletApiRequest)theReq;
            Map<String, String> headers = this.pullOutHeaders(theReq);
            this.myRequestHeaders.add(headers);
            this.myRequestVerbs.add(request.getMethod());
            Object nextRequestUrl = request.getRequestURI();
            if (request.getQueryString() != null) {
                nextRequestUrl = (String)nextRequestUrl + "?" + request.getQueryString();
            }
            this.myRequestUrls.add((String)nextRequestUrl);
            super.service(theReq, theResp);
        }

        private Map<String, String> pullOutHeaders(HttpServletRequest theReq) {
            Enumeration headerNames = theReq.getHeaderNames();
            HashMap<String, String> headers = new HashMap<String, String>();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                headers.put(headerName, theReq.getHeader(headerName));
            }
            return headers;
        }

        public void clearDataAndCounts() {
            for (IResourceProvider next : this.getResourceProviders()) {
                if (!(next instanceof HashMapResourceProvider)) continue;
                HashMapResourceProvider provider = (HashMapResourceProvider)next;
                provider.clear();
            }
            this.clearCounts();
        }

        public HashMapResourceProvider<Observation> getObservationResourceProvider() {
            return this.myObservationResourceProvider;
        }

        public void setPatientResourceProvider(HashMapResourceProvider<Patient> theResourceProvider) {
            this.myPatientResourceProvider.getStoredResources().forEach(arg_0 -> theResourceProvider.store(arg_0));
            this.unregisterProvider(this.myPatientResourceProvider);
            this.registerProvider(theResourceProvider);
            this.myPatientResourceProvider = theResourceProvider;
        }

        public void setObservationResourceProvider(HashMapResourceProvider<Observation> theResourceProvider) {
            this.myObservationResourceProvider.getStoredResources().forEach(arg_0 -> theResourceProvider.store(arg_0));
            this.unregisterProvider(this.myObservationResourceProvider);
            this.registerProvider(theResourceProvider);
            this.myObservationResourceProvider = theResourceProvider;
        }

        public HashMapResourceProvider<Organization> getOrganizationResourceProvider() {
            return this.myOrganizationResourceProvider;
        }

        public HashMapResourceProvider<ConceptMap> getConceptMapResourceProvider() {
            return this.myConceptMapResourceProvider;
        }

        public void setConceptMapResourceProvider(HashMapResourceProvider<ConceptMap> theResourceProvider) {
            this.myConceptMapResourceProvider.getStoredResources().forEach(arg_0 -> theResourceProvider.store(arg_0));
            this.unregisterProvider(this.myConceptMapResourceProvider);
            this.registerProvider(theResourceProvider);
            this.myConceptMapResourceProvider = theResourceProvider;
        }

        public HashMapResourceProvider<Patient> getPatientResourceProvider() {
            return this.myPatientResourceProvider;
        }

        protected void initialize() throws ServletException {
            super.initialize();
            FhirContext fhirContext = this.getFhirContext();
            this.myPatientResourceProvider = new MyHashMapResourceProvider<Patient>(fhirContext, Patient.class);
            this.registerProvider(this.myPatientResourceProvider);
            this.myObservationResourceProvider = new MyHashMapResourceProvider<Observation>(fhirContext, Observation.class);
            this.registerProvider(this.myObservationResourceProvider);
            this.myOrganizationResourceProvider = new MyHashMapResourceProvider<Organization>(fhirContext, Organization.class);
            this.registerProvider(this.myOrganizationResourceProvider);
            this.myConceptMapResourceProvider = new MyHashMapResourceProvider<ConceptMap>(fhirContext, ConceptMap.class);
            this.registerProvider(this.myConceptMapResourceProvider);
            this.myPlainProvider = new RestServerDstu3Helper.MyPlainProvider(this.myInitialTransactionLatchEnabled);
            this.registerProvider(this.myPlainProvider);
            this.setPagingProvider(myPagingProvider);
        }

        public class MyHashMapResourceProvider<T extends IBaseResource>
        extends HashMapResourceProvider<T> {
            public MyHashMapResourceProvider(FhirContext theContext, Class<T> theType) {
                super(theContext, theType);
            }

            public MethodOutcome update(T theResource, String theConditional, RequestDetails theRequestDetails) {
                if (MyRestfulServer.this.myFailNextPut) {
                    throw new PreconditionFailedException(Msg.code((int)2111) + "Failed update operation");
                }
                return super.update(theResource, theConditional, theRequestDetails);
            }
        }
    }
}

