/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.test.utilities;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.util.BundleUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public class SearchTestUtil {
    private SearchTestUtil() {
    }

    public static List<IIdType> toUnqualifiedVersionlessIds(IBaseBundle theFound) {
        FhirContext ctx = FhirContext.forCached((FhirVersionEnum)theFound.getStructureFhirVersionEnum());
        ArrayList<IIdType> retVal = new ArrayList<IIdType>();
        for (IBaseResource next : BundleUtil.toListOfResources((FhirContext)ctx, (IBaseBundle)theFound)) {
            if (next == null) continue;
            retVal.add(next.getIdElement().toUnqualifiedVersionless());
        }
        return retVal;
    }

    public static List<String> toUnqualifiedVersionlessIdValues(IBaseBundle theFound) {
        return SearchTestUtil.toUnqualifiedVersionlessIds(theFound).stream().map(t -> t.getValue()).collect(Collectors.toList());
    }
}

