/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.test.utilities;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Meta;
import org.junit.jupiter.api.function.Executable;

public class TagTestUtil {
    public static List<Coding> generateAllCodingPairs(List<String> theSystems, List<String> theCodes) {
        ArrayList<Coding> result = new ArrayList<Coding>();
        for (String system : theSystems) {
            for (String code : theCodes) {
                result.add(TagTestUtil.createCoding(system, code));
            }
        }
        return result;
    }

    public static void assertCodingsEqualAndInOrder(List<? extends IBaseCoding> theExpectedCodings, List<? extends IBaseCoding> theActualCodings) {
        Assertions.assertThat(theActualCodings).hasSize(theExpectedCodings.size());
        for (int index = 0; index < theExpectedCodings.size(); ++index) {
            IBaseCoding expectedCoding = theExpectedCodings.get(index);
            IBaseCoding actualCoding = theActualCodings.get(index);
            org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertEquals((Object)expectedCoding.getSystem(), (Object)actualCoding.getSystem()), () -> org.junit.jupiter.api.Assertions.assertEquals((Object)expectedCoding.getCode(), (Object)actualCoding.getCode()), () -> org.junit.jupiter.api.Assertions.assertEquals((Object)expectedCoding.getDisplay(), (Object)actualCoding.getDisplay()), () -> org.junit.jupiter.api.Assertions.assertEquals((Object)expectedCoding.getVersion(), (Object)actualCoding.getVersion()), () -> org.junit.jupiter.api.Assertions.assertEquals((Object)expectedCoding.getUserSelected(), (Object)actualCoding.getUserSelected())});
        }
    }

    public static Coding createCoding(String theSystem, String theCode) {
        return TagTestUtil.createCoding(null, false, theCode, null, theSystem);
    }

    public static Coding createCoding(String theVersion, boolean theUserSelected, String theCode, String theDisplay, String theSystem) {
        Coding coding = new Coding();
        coding.setVersion(theVersion);
        coding.setUserSelected(theUserSelected);
        coding.setCode(theCode);
        coding.setDisplay(theDisplay);
        coding.setSystem(theSystem);
        return coding;
    }

    public static Meta createMeta(List<Coding> theTags, List<Coding> theSecurityLabels, List<String> theProfiles) {
        Meta meta = new Meta();
        meta.setTag(new ArrayList<Coding>(theTags));
        meta.setSecurity(new ArrayList<Coding>(theSecurityLabels));
        meta.setProfile(TagTestUtil.toCanonicalTypeList(theProfiles));
        return meta;
    }

    public static List<CanonicalType> toCanonicalTypeList(List<String> theStrings) {
        return theStrings.stream().map(s -> new CanonicalType(s)).collect(Collectors.toList());
    }

    public static List<String> toStringList(List<? extends IPrimitiveType<String>> thePrimitiveTypes) {
        return thePrimitiveTypes.stream().map(c -> (String)c.getValue()).collect(Collectors.toList());
    }
}

