/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.test.utilities;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.test.utilities.BaseRestServerHelper;
import ca.uhn.fhir.tls.KeyStoreInfo;
import ca.uhn.fhir.tls.TlsAuthentication;
import ca.uhn.fhir.tls.TrustStoreInfo;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class TlsAuthenticationTestHelper
implements AfterEachCallback {
    private static final String KEYSTORE_RESOURCE_PATH = "classpath:/tls/client-keystore.p12";
    private static final String KEYSTORE_STOREPASS = "changeit";
    private static final String KEYSTORE_KEYPASS = "changeit";
    private static final String KEYSTORE_ALIAS = "client";
    private static final String TRUSTSTORE_RESOURCE_PATH = "classpath:/tls/client-truststore.p12";
    private static final String TRUSTSTORE_STOREPASS = "changeit";
    private static final String TRUSTSTORE_ALIAS = "client";
    private final TlsAuthentication myTlsAuthentication;
    private final KeyStoreInfo myKeystoreInfo = new KeyStoreInfo("classpath:/tls/client-keystore.p12", "changeit", "changeit", "client");
    private final TrustStoreInfo myTrustStoreInfo = new TrustStoreInfo("classpath:/tls/client-truststore.p12", "changeit", "client");
    private File myTempFile;

    public TlsAuthenticationTestHelper() {
        this.myTlsAuthentication = new TlsAuthentication(Optional.of(this.myKeystoreInfo), Optional.of(this.myTrustStoreInfo));
    }

    public void afterEach(ExtensionContext theExtensionContext) throws Exception {
        if (this.myTempFile != null && this.myTempFile.exists()) {
            Assertions.assertTrue((boolean)this.myTempFile.delete());
            this.myTempFile = null;
        }
    }

    public String[] createBaseRequestGeneratingCommandArgs(String[] theBaseArgs, String theUrlFlag, boolean theAddTls, BaseRestServerHelper theRestServerHelper) {
        String[] retVal;
        if (StringUtils.isBlank((CharSequence)theUrlFlag)) {
            return theBaseArgs;
        }
        if (theAddTls) {
            int newSize = theBaseArgs.length + 4;
            retVal = Arrays.copyOf(theBaseArgs, newSize);
            retVal[newSize - 4] = theUrlFlag;
            retVal[newSize - 3] = theRestServerHelper.getSecureBase();
            this.myTempFile = this.createTlsAuthenticationFile();
            retVal[newSize - 2] = "--tls-auth";
            retVal[newSize - 1] = this.myTempFile.getAbsolutePath();
        } else {
            int newSize = theBaseArgs.length + 2;
            retVal = Arrays.copyOf(theBaseArgs, newSize);
            retVal[newSize - 2] = theUrlFlag;
            retVal[newSize - 1] = theRestServerHelper.getBase();
        }
        return retVal;
    }

    public TlsAuthentication getTlsAuthentication() {
        return this.myTlsAuthentication;
    }

    public File createTlsAuthenticationFile() {
        try {
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode keyStore = mapper.createObjectNode();
            keyStore.put("filePath", KEYSTORE_RESOURCE_PATH);
            keyStore.put("storePass", "changeit");
            keyStore.put("keyPass", "changeit");
            keyStore.put("alias", "client");
            ObjectNode trustStore = mapper.createObjectNode();
            trustStore.put("filePath", TRUSTSTORE_RESOURCE_PATH);
            trustStore.put("storePass", "changeit");
            trustStore.put("alias", "client");
            ObjectNode json = mapper.createObjectNode();
            json.set("keyStore", (JsonNode)keyStore);
            json.set("trustStore", (JsonNode)trustStore);
            File inputFile = File.createTempFile("smile-unit-test", ".json");
            try (FileWriter inputFileWriter = new FileWriter(inputFile, StandardCharsets.UTF_8, false);){
                IOUtils.write((String)json.toString(), (Writer)inputFileWriter);
            }
            return inputFile;
        }
        catch (Exception e) {
            throw new RuntimeException(Msg.code((int)2122) + "Failed to load test TLS authentication file", e);
        }
    }
}

