/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.test.utilities;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.ScheduledAnnotationBeanPostProcessor;
import org.springframework.scheduling.concurrent.ExecutorConfigurationSupport;

public class UnregisterScheduledProcessor
implements BeanFactoryPostProcessor {
    public static final String SCHEDULING_DISABLED = "scheduling_disabled";
    public static final String SCHEDULING_DISABLED_EQUALS_TRUE = "scheduling_disabled=true";
    public static final String SCHEDULING_DISABLED_EQUALS_FALSE = "scheduling_disabled=false";
    private final Environment myEnvironment;

    public UnregisterScheduledProcessor(Environment theEnv) {
        this.myEnvironment = theEnv;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        String schedulingDisabled = this.myEnvironment.getProperty(SCHEDULING_DISABLED);
        if ("true".equals(schedulingDisabled)) {
            for (String beanName : beanFactory.getBeanNamesForType(ScheduledAnnotationBeanPostProcessor.class)) {
                ((DefaultListableBeanFactory)beanFactory).removeBeanDefinition(beanName);
            }
            for (String beanName : beanFactory.getBeanNamesForType(ExecutorConfigurationSupport.class)) {
                ExecutorConfigurationSupport executorConfigSupport = (ExecutorConfigurationSupport)beanFactory.getBean(beanName, ExecutorConfigurationSupport.class);
                executorConfigSupport.shutdown();
            }
        }
    }
}

