/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.test.utilities.docker;

import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;

public class DockerRequiredCondition
implements ExecutionCondition {
    public static final String AVAILABLE_MSG = "Docker is installed so we can run these tests!";
    public static final String UNAVAILABLE_MSG = "It appears as though docker is not installed on the host machine!";
    private static final Logger ourLog = LoggerFactory.getLogger(DockerRequiredCondition.class);
    private static Boolean ourIsDockerAvailable;

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext theExtensionContext) {
        boolean isDockerAvailable = DockerRequiredCondition.isDockerAvailable();
        return isDockerAvailable ? ConditionEvaluationResult.enabled((String)AVAILABLE_MSG) : ConditionEvaluationResult.disabled((String)UNAVAILABLE_MSG);
    }

    public static boolean isDockerAvailable() {
        Boolean retVal = ourIsDockerAvailable;
        if (retVal != null) {
            return retVal;
        }
        try {
            retVal = DockerClientFactory.instance().isDockerAvailable();
        }
        catch (Exception e) {
            retVal = false;
        }
        ourLog.info("Docker available: {}", (Object)retVal);
        ourIsDockerAvailable = retVal;
        return retVal;
    }
}

