/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.test.utilities.jpa;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.ClasspathUtil;
import com.google.common.base.Ascii;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.reflect.ClassPath;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Embedded;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.persistence.UniqueConstraint;
import jakarta.validation.constraints.Size;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Subselect;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.FullTextField;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.GenericField;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.ScaledNumberField;
import org.hibernate.validator.constraints.Length;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaModelScannerAndVerifier {
    public static final int MAX_COL_LENGTH = 4000;
    private static final int MAX_LENGTH = 30;
    private static final Logger ourLog = LoggerFactory.getLogger(JpaModelScannerAndVerifier.class);
    private static final Multimap<String, String> ourIndexNameToColumn = HashMultimap.create();
    private static Set<String> ourReservedWords;

    public void scanEntities(String ... thePackageNames) throws IOException, ClassNotFoundException {
        try (InputStream is = ClasspathUtil.loadResourceAsStream((String)"/mysql-reserved-words.txt");){
            String contents = IOUtils.toString((InputStream)is, (Charset)Constants.CHARSET_UTF8);
            String[] words = contents.split("\\n");
            ourReservedWords = Arrays.stream(words).filter(StringUtils::isNotBlank).map(Ascii::toUpperCase).collect(Collectors.toSet());
        }
        for (String packageName : thePackageNames) {
            ImmutableSet classes = ClassPath.from((ClassLoader)JpaModelScannerAndVerifier.class.getClassLoader()).getTopLevelClassesRecursive(packageName);
            HashSet<String> names = new HashSet<String>();
            if (classes.size() <= 1) {
                throw new InternalErrorException(Msg.code((int)1623) + "Found no classes");
            }
            for (ClassPath.ClassInfo classInfo : classes) {
                Class<?> clazz = Class.forName(classInfo.getName());
                Entity entity = clazz.getAnnotation(Entity.class);
                Embeddable embeddable = clazz.getAnnotation(Embeddable.class);
                if (entity == null && embeddable == null) continue;
                this.scanClass(names, clazz);
            }
        }
    }

    private void scanClass(Set<String> theNames, Class<?> theClazz) {
        HashMap<String, Integer> columnNameToLength = new HashMap<String, Integer>();
        this.scanClassOrSuperclass(theNames, theClazz, false, columnNameToLength);
        Table table = theClazz.getAnnotation(Table.class);
        if (table != null) {
            int maxIndexLength = 3072;
            for (UniqueConstraint nextIndex : table.uniqueConstraints()) {
                int indexLength = JpaModelScannerAndVerifier.calculateIndexLength(nextIndex.columnNames(), columnNameToLength, nextIndex.name());
                if (indexLength <= maxIndexLength) continue;
                throw new IllegalStateException(Msg.code((int)1624) + "Index '" + nextIndex.name() + "' is too long. Length is " + indexLength + " and must not exceed " + maxIndexLength + " which is the maximum MySQL length");
            }
        }
    }

    private void scanClassOrSuperclass(Set<String> theNames, Class<?> theClazz, boolean theIsSuperClass, Map<String, Integer> columnNameToLength) {
        ourLog.info("Scanning: {}", (Object)theClazz.getSimpleName());
        Subselect subselect = theClazz.getAnnotation(Subselect.class);
        boolean isView = subselect != null;
        this.scan(theClazz, theNames, theIsSuperClass, isView);
        boolean foundId = false;
        for (Field field : theClazz.getDeclaredFields()) {
            boolean isTransient;
            boolean isId;
            if (Modifier.isStatic(field.getModifiers())) continue;
            ourLog.info(" * Scanning field: {}", (Object)field.getName());
            this.scan(field, theNames, theIsSuperClass, isView);
            Id id = field.getAnnotation(Id.class);
            boolean bl = isId = id != null;
            if (isId) {
                GeneratedValue generatedValue;
                Validate.isTrue((!foundId ? 1 : 0) != 0, (String)"Multiple fields annotated with @Id", (Object[])new Object[0]);
                foundId = true;
                if (Long.class.equals(field.getType()) && (generatedValue = field.getAnnotation(GeneratedValue.class)) != null) {
                    Validate.notBlank((CharSequence)generatedValue.generator(), (String)"Field has no @GeneratedValue.generator(): %s", (Object[])new Object[]{field});
                    JpaModelScannerAndVerifier.assertNotADuplicateName(generatedValue.generator(), theNames);
                    JpaModelScannerAndVerifier.assertEqualsForIdGenerator(field, generatedValue.strategy(), GenerationType.AUTO);
                    GenericGenerator genericGenerator = field.getAnnotation(GenericGenerator.class);
                    SequenceGenerator sequenceGenerator = field.getAnnotation(SequenceGenerator.class);
                    Validate.isTrue((boolean)(sequenceGenerator != null ^ genericGenerator != null));
                    if (genericGenerator != null) {
                        JpaModelScannerAndVerifier.assertEqualsForIdGenerator(field, "ca.uhn.fhir.jpa.model.dialect.HapiSequenceStyleGenerator", genericGenerator.type().getName());
                        JpaModelScannerAndVerifier.assertEqualsForIdGenerator(field, "native", genericGenerator.strategy());
                        JpaModelScannerAndVerifier.assertEqualsForIdGenerator(field, generatedValue.generator(), genericGenerator.name());
                    } else {
                        Validate.notNull((Object)sequenceGenerator);
                        JpaModelScannerAndVerifier.assertEqualsForIdGenerator(field, generatedValue.generator(), sequenceGenerator.name());
                        JpaModelScannerAndVerifier.assertEqualsForIdGenerator(field, generatedValue.generator(), sequenceGenerator.sequenceName());
                    }
                }
            }
            boolean bl2 = isTransient = field.getAnnotation(Transient.class) != null;
            if (isTransient) continue;
            boolean hasColumn = field.getAnnotation(Column.class) != null;
            boolean hasJoinColumn = field.getAnnotation(JoinColumn.class) != null;
            boolean hasEmbeddedId = field.getAnnotation(EmbeddedId.class) != null;
            boolean hasEmbedded = field.getAnnotation(Embedded.class) != null;
            OneToMany oneToMany = field.getAnnotation(OneToMany.class);
            OneToOne oneToOne = field.getAnnotation(OneToOne.class);
            boolean isOtherSideOfOneToManyMapping = oneToMany != null && StringUtils.isNotBlank((CharSequence)oneToMany.mappedBy());
            boolean isOtherSideOfOneToOneMapping = oneToOne != null && StringUtils.isNotBlank((CharSequence)oneToOne.mappedBy());
            boolean isField = field.getAnnotation(FullTextField.class) != null;
            isField |= field.getAnnotation(GenericField.class) != null;
            Validate.isTrue((hasEmbedded || hasColumn || hasJoinColumn || isOtherSideOfOneToManyMapping || isOtherSideOfOneToOneMapping || hasEmbeddedId || (isField |= field.getAnnotation(ScaledNumberField.class) != null) ? 1 : 0) != 0, (String)("Non-transient has no @Column or @JoinColumn or @EmbeddedId: " + field), (Object[])new Object[0]);
            int columnLength = 16;
            String columnName = null;
            boolean nullable = false;
            if (hasColumn) {
                Column column = field.getAnnotation(Column.class);
                columnName = column.name();
                columnLength = column.length();
                nullable = column.nullable();
            }
            if (hasJoinColumn) {
                JoinColumn joinColumn = field.getAnnotation(JoinColumn.class);
                columnName = joinColumn.name();
                nullable = joinColumn.nullable();
            }
            if (isId) {
                nullable = false;
            }
            if (nullable && !isView) {
                Validate.isTrue((!field.getType().isPrimitive() ? 1 : 0) != 0, (String)"Field [%s] has a nullable primitive type: %s", (Object[])new Object[]{field.getName(), field.getType()});
            }
            if (columnName == null) continue;
            if (field.getType().isAssignableFrom(String.class)) {
                columnLength *= 4;
            }
            columnNameToLength.put(columnName, columnLength);
        }
        for (AnnotatedElement annotatedElement : theClazz.getDeclaredClasses()) {
            Embeddable embeddable = ((Class)annotatedElement).getAnnotation(Embeddable.class);
            if (embeddable == null) continue;
            this.scanClassOrSuperclass(theNames, (Class<?>)annotatedElement, false, columnNameToLength);
        }
        if (theClazz.getSuperclass().equals(Object.class)) {
            return;
        }
        this.scanClassOrSuperclass(theNames, theClazz.getSuperclass(), true, columnNameToLength);
    }

    private void scan(AnnotatedElement theAnnotatedElement, Set<String> theNames, boolean theIsSuperClass, boolean theIsView) {
        Column column;
        JoinColumn joinColumn;
        Table table = theAnnotatedElement.getAnnotation(Table.class);
        if (table != null) {
            ArrayList bannedNames = Lists.newArrayList((Object[])new String[]{"CDR_USER_2FA", "TRM_VALUESET_CODE"});
            Validate.isTrue((!bannedNames.contains(table.name().toUpperCase()) ? 1 : 0) != 0);
            Validate.isTrue((boolean)table.name().toUpperCase().equals(table.name()));
            JpaModelScannerAndVerifier.assertNotADuplicateName(table.name(), theNames);
            for (UniqueConstraint uniqueConstraint : table.uniqueConstraints()) {
                JpaModelScannerAndVerifier.assertNotADuplicateName(uniqueConstraint.name(), theNames);
                Validate.isTrue((boolean)uniqueConstraint.name().startsWith("IDX_"), (String)(uniqueConstraint.name() + " must start with IDX_"), (Object[])new Object[0]);
            }
            for (UniqueConstraint uniqueConstraint : table.indexes()) {
                String[] cols;
                JpaModelScannerAndVerifier.assertNotADuplicateName(uniqueConstraint.name(), theNames);
                Validate.isTrue((uniqueConstraint.name().startsWith("IDX_") || uniqueConstraint.name().startsWith("FK_") ? 1 : 0) != 0, (String)(uniqueConstraint.name() + " must start with IDX_ or FK_ (last one when indexing a FK column)"), (Object[])new Object[0]);
                for (String col : cols = uniqueConstraint.columnList().split(",")) {
                    ourIndexNameToColumn.put((Object)uniqueConstraint.name(), (Object)col);
                }
            }
        }
        if ((joinColumn = theAnnotatedElement.getAnnotation(JoinColumn.class)) != null) {
            String columnName = joinColumn.name();
            this.validateColumnName(columnName, theAnnotatedElement);
            JpaModelScannerAndVerifier.assertNotADuplicateName(columnName, null);
            ForeignKey fk = joinColumn.foreignKey();
            if (theIsSuperClass) {
                Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)fk.name()), (String)("Foreign key on " + theAnnotatedElement + " has a name() and should not as it is a superclass"), (Object[])new Object[0]);
            } else {
                Validate.notNull((Object)fk);
                Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)fk.name()), (String)("Foreign key on " + theAnnotatedElement + " has no name()"), (Object[])new Object[0]);
                List<String> legacySPHibernateFKNames = Arrays.asList("FKC97MPK37OKWU8QVTCEG2NH9VN", "FKGXSREUTYMMFJUWDSWV3Y887DO");
                Validate.isTrue((fk.name().startsWith("FK_") || legacySPHibernateFKNames.contains(fk.name()) ? 1 : 0) != 0, (String)("Foreign key " + fk.name() + " on " + theAnnotatedElement + " must start with FK_"), (Object[])new Object[0]);
                if (ourIndexNameToColumn.containsKey((Object)fk.name())) {
                    Collection collection = ourIndexNameToColumn.get((Object)fk.name());
                    ((AbstractBooleanAssert)Assertions.assertThat((boolean)collection.contains(columnName)).as(String.format("Foreign key %s duplicates index name, but column %s is not part of the index!", fk.name(), columnName), new Object[0])).isTrue();
                } else {
                    JpaModelScannerAndVerifier.assertNotADuplicateName(fk.name(), theNames);
                }
            }
        }
        if ((column = theAnnotatedElement.getAnnotation(Column.class)) != null) {
            String columnName = column.name();
            this.validateColumnName(columnName, theAnnotatedElement);
            JpaModelScannerAndVerifier.assertNotADuplicateName(columnName, null);
            Validate.isTrue((!column.unique() ? 1 : 0) != 0, (String)("Should not use unique attribute on column (use named @UniqueConstraint instead) on " + theAnnotatedElement), (Object[])new Object[0]);
            boolean hasLob = theAnnotatedElement.getAnnotation(Lob.class) != null;
            Field field = (Field)theAnnotatedElement;
            if (field.getType().equals(String.class)) {
                if (!hasLob && !theIsView && column.length() == 255) {
                    throw new IllegalStateException(Msg.code((int)1626) + "Field does not have an explicit maximum length specified: " + field);
                }
                Size size = theAnnotatedElement.getAnnotation(Size.class);
                if (size != null && size.max() > 4000) {
                    throw new IllegalStateException(Msg.code((int)1628) + "Field is too long: " + field);
                }
                Length length = theAnnotatedElement.getAnnotation(Length.class);
                if (length != null && length.max() > 4000) {
                    throw new IllegalStateException(Msg.code((int)1629) + "Field is too long: " + field);
                }
            }
        }
    }

    private void validateColumnName(String theColumnName, AnnotatedElement theElement) {
        if (!theColumnName.equals(theColumnName.toUpperCase())) {
            throw new IllegalArgumentException(Msg.code((int)1630) + "Column name must be all upper case: " + theColumnName + " found on " + theElement);
        }
        if (ourReservedWords.contains(theColumnName)) {
            throw new IllegalArgumentException(Msg.code((int)1631) + "Column name is a reserved word: " + theColumnName + " found on " + theElement);
        }
        if (theColumnName.startsWith("_")) {
            throw new IllegalArgumentException(Msg.code((int)2272) + "Column name " + theColumnName + " starts with an '_' (underscore). This is not permitted for oracle field names. Found on " + theElement);
        }
    }

    private static int calculateIndexLength(String[] theColumnNames, Map<String, Integer> theColumnNameToLength, String theIndexName) {
        int retVal = 0;
        for (String nextName : theColumnNames) {
            Integer nextLength = theColumnNameToLength.get(nextName);
            if (nextLength == null) {
                throw new IllegalStateException(Msg.code((int)1625) + "Index '" + theIndexName + "' references unknown column: " + nextName);
            }
            retVal += nextLength.intValue();
        }
        return retVal;
    }

    private static void assertEqualsForIdGenerator(Field theSource, Object theExpectedGenerator, Object theActualGenerator) {
        Validate.isTrue((boolean)theExpectedGenerator.equals(theActualGenerator), (String)("Value " + theActualGenerator + " doesn't match expected " + theExpectedGenerator + " for ID generator on " + theSource), (Object[])new Object[0]);
    }

    private static void assertNotADuplicateName(String theName, Set<String> theNames) {
        if (StringUtils.isBlank((CharSequence)theName)) {
            return;
        }
        Validate.isTrue((theName.length() <= 30 ? 1 : 0) != 0, (String)("Identifier \"" + theName + "\" is " + theName.length() + " chars long"), (Object[])new Object[0]);
        if (theNames != null) {
            Validate.isTrue((boolean)theNames.add(theName), (String)("Duplicate name: " + theName), (Object[])new Object[0]);
        }
    }
}

