/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.test.utilities.server;

import ca.uhn.fhir.test.utilities.JettyUtil;
import ca.uhn.fhir.test.utilities.server.SpringContextGrabbingTestExecutionListener;
import jakarta.annotation.PreDestroy;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.eclipse.jetty.ee10.servlet.FilterHolder;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.ee10.websocket.jakarta.server.config.JakartaWebSocketServletContainerInitializer;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotatedBeanDefinitionReader;
import org.springframework.web.context.support.GenericWebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;

public abstract class BaseJettyServerExtension<T extends BaseJettyServerExtension<?>>
implements BeforeEachCallback,
AfterEachCallback,
AfterAllCallback {
    private static final Logger ourLog = LoggerFactory.getLogger(BaseJettyServerExtension.class);
    private final List<List<String>> myRequestHeaders = new ArrayList<List<String>>();
    private final List<String> myRequestContentTypes = new ArrayList<String>();
    private final List<Filter> myServletFilters = new ArrayList<Filter>();
    private String myServletPath = "/*";
    private Server myServer;
    private CloseableHttpClient myHttpClient;
    private int myPort = 0;
    private boolean myKeepAliveBetweenTests;
    private String myContextPath = "";
    private AtomicLong myConnectionsOpenedCounter;
    private Class<? extends WebSocketConfigurer> myEnableSpringWebsocketSupport;
    private String myEnableSpringWebsocketContextPath;
    private long myIdleTimeoutMillis = 30000L;
    private final List<Consumer<Server>> myBeforeStartServerConsumers = new ArrayList<Consumer<Server>>();

    public T withIdleTimeout(long theIdleTimeoutMillis) {
        Validate.isTrue((this.myServer == null ? 1 : 0) != 0, (String)"Server is already started", (Object[])new Object[0]);
        this.myIdleTimeoutMillis = theIdleTimeoutMillis;
        return (T)this;
    }

    public T withContextPath(String theContextPath) {
        Validate.isTrue((this.myServer == null ? 1 : 0) != 0, (String)"Server is already started", (Object[])new Object[0]);
        this.myContextPath = StringUtils.defaultString((String)theContextPath);
        return (T)this;
    }

    public T withServletFilter(Filter theFilter) {
        Validate.isTrue((this.myServer == null ? 1 : 0) != 0, (String)"Server is already started", (Object[])new Object[0]);
        Validate.notNull((Object)theFilter, (String)"theFilter must not be null", (Object[])new Object[0]);
        this.myServletFilters.add(theFilter);
        return (T)this;
    }

    public T withServerBeforeStarted(Consumer<Server> theConsumer) {
        Validate.isTrue((this.myServer == null ? 1 : 0) != 0, (String)"Server is already started", (Object[])new Object[0]);
        Validate.notNull(theConsumer, (String)"theConsumer must not be null", (Object[])new Object[0]);
        this.myBeforeStartServerConsumers.add(theConsumer);
        return (T)this;
    }

    public long getConnectionsOpenedCount() {
        return this.myConnectionsOpenedCounter.get();
    }

    public void resetConnectionsOpenedCount() {
        this.myConnectionsOpenedCounter.set(0L);
    }

    public CloseableHttpClient getHttpClient() {
        return this.myHttpClient;
    }

    public List<String> getRequestContentTypes() {
        return this.myRequestContentTypes;
    }

    public List<List<String>> getRequestHeaders() {
        return this.myRequestHeaders;
    }

    @PreDestroy
    public void stopServer() throws Exception {
        if (!this.isRunning()) {
            return;
        }
        JettyUtil.closeServer(this.myServer);
        this.myServer = null;
        this.myHttpClient.close();
        this.myHttpClient = null;
    }

    protected void startServer() throws Exception {
        if (this.isRunning()) {
            return;
        }
        this.myServer = new Server();
        this.myConnectionsOpenedCounter = new AtomicLong(0L);
        ServerConnector connector = new ServerConnector(this.myServer);
        connector.setIdleTimeout(this.myIdleTimeoutMillis);
        connector.setPort(this.myPort);
        this.myServer.setConnectors(new Connector[]{connector});
        HttpConnectionFactory connectionFactory = (HttpConnectionFactory)connector.getConnectionFactories().iterator().next();
        connectionFactory.addBean((Object)new Connection.Listener(){

            public void onOpened(Connection connection) {
                BaseJettyServerExtension.this.myConnectionsOpenedCounter.incrementAndGet();
            }

            public void onClosed(Connection connection) {
            }
        });
        ServletHolder servletHolder = new ServletHolder((Servlet)this.provideServlet());
        ArrayList<ServletContextHandler> handlerList = new ArrayList<ServletContextHandler>();
        ServletContextHandler contextHandler = new ServletContextHandler();
        contextHandler.setContextPath(this.myContextPath);
        contextHandler.addServlet(servletHolder, this.myServletPath);
        contextHandler.addFilter(new FilterHolder(this.requestCapturingFilter()), "/*", EnumSet.allOf(DispatcherType.class));
        for (Filter filter : this.myServletFilters) {
            contextHandler.addFilter(new FilterHolder(filter), "/*", EnumSet.allOf(DispatcherType.class));
        }
        handlerList.add(contextHandler);
        if (this.myEnableSpringWebsocketSupport != null) {
            GenericWebApplicationContext wac = new GenericWebApplicationContext();
            wac.setParent(SpringContextGrabbingTestExecutionListener.getApplicationContext());
            AnnotatedBeanDefinitionReader annotatedBeanDefinitionReader = new AnnotatedBeanDefinitionReader((BeanDefinitionRegistry)wac);
            annotatedBeanDefinitionReader.register(new Class[]{this.myEnableSpringWebsocketSupport});
            DispatcherServlet dispatcherServlet = new DispatcherServlet();
            dispatcherServlet.setApplicationContext((ApplicationContext)wac);
            ServletHolder subsServletHolder = new ServletHolder();
            subsServletHolder.setServlet((Servlet)dispatcherServlet);
            ServletContextHandler servletContextHandler = new ServletContextHandler();
            servletContextHandler.setContextPath(this.myEnableSpringWebsocketContextPath);
            servletContextHandler.setAllowNullPathInContext(true);
            servletContextHandler.addServlet(new ServletHolder((Servlet)dispatcherServlet), "/*");
            JakartaWebSocketServletContainerInitializer.configure((ServletContextHandler)servletContextHandler, null);
            handlerList.add(servletContextHandler);
        }
        this.myServer.setHandler((Handler)new Handler.Sequence(handlerList));
        for (Consumer consumer : this.myBeforeStartServerConsumers) {
            consumer.accept(this.myServer);
        }
        this.myServer.start();
        this.myPort = JettyUtil.getPortForStartedServer(this.myServer);
        ourLog.info("Server has started on port {}", (Object)this.myPort);
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(5000L, TimeUnit.MILLISECONDS);
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        httpClientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        this.myHttpClient = httpClientBuilder.build();
    }

    private Filter requestCapturingFilter() {
        return new RequestCapturingFilter();
    }

    public int getPort() {
        return this.myPort;
    }

    protected abstract HttpServlet provideServlet();

    public String getWebsocketContextPath() {
        return this.myEnableSpringWebsocketContextPath;
    }

    public T withServletPath(String theServletPath) {
        Validate.isTrue((boolean)theServletPath.startsWith("/"), (String)"Servlet path should start with /", (Object[])new Object[0]);
        Validate.isTrue((boolean)theServletPath.endsWith("/*"), (String)"Servlet path should end with /*", (Object[])new Object[0]);
        this.myServletPath = theServletPath;
        return (T)this;
    }

    public T withPort(int thePort) {
        this.myPort = thePort;
        return (T)this;
    }

    public T keepAliveBetweenTests() {
        this.myKeepAliveBetweenTests = true;
        return (T)this;
    }

    protected boolean isRunning() {
        return this.myServer != null;
    }

    public String getBaseUrl() {
        assert (this.myServletPath.endsWith("/*"));
        return "http://localhost:" + this.myPort + this.myContextPath + this.myServletPath.substring(0, this.myServletPath.length() - 2);
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.startServer();
        this.myRequestContentTypes.clear();
        this.myRequestHeaders.clear();
    }

    public void afterEach(ExtensionContext context) throws Exception {
        if (!this.myKeepAliveBetweenTests) {
            this.stopServer();
        }
    }

    public void afterAll(ExtensionContext context) throws Exception {
        this.stopServer();
    }

    public T withSpringWebsocketSupport(String theContextPath, Class<? extends WebSocketConfigurer> theContextConfigClass) {
        assert (!this.isRunning());
        assert (theContextConfigClass != null);
        this.myEnableSpringWebsocketSupport = theContextConfigClass;
        this.myEnableSpringWebsocketContextPath = theContextPath;
        return (T)this;
    }

    private class RequestCapturingFilter
    implements Filter {
        private RequestCapturingFilter() {
        }

        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void doFilter(ServletRequest theRequest, ServletResponse theResponse, FilterChain theChain) throws IOException, ServletException {
            HttpServletRequest request = (HttpServletRequest)theRequest;
            String header = request.getHeader("Content-Type");
            if (StringUtils.isNotBlank((CharSequence)header)) {
                BaseJettyServerExtension.this.myRequestContentTypes.add(header.replaceAll(";.*", ""));
            } else {
                BaseJettyServerExtension.this.myRequestContentTypes.add(null);
            }
            Enumeration headerNamesEnum = request.getHeaderNames();
            ArrayList<CallSite> requestHeaders = new ArrayList<CallSite>();
            BaseJettyServerExtension.this.myRequestHeaders.add(requestHeaders);
            while (headerNamesEnum.hasMoreElements()) {
                String nextName = (String)headerNamesEnum.nextElement();
                Enumeration valueEnum = request.getHeaders(nextName);
                while (valueEnum.hasMoreElements()) {
                    String nextValue = (String)valueEnum.nextElement();
                    requestHeaders.add((CallSite)((Object)(nextName + ": " + nextValue)));
                }
            }
            theChain.doFilter(theRequest, theResponse);
        }

        public void destroy() {
        }
    }
}

