/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.test.utilities.server;

import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.provider.HashMapResourceProvider;
import ca.uhn.fhir.test.utilities.server.RestfulServerExtension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class HashMapResourceProviderExtension<T extends IBaseResource>
extends HashMapResourceProvider<T>
implements BeforeEachCallback,
AfterEachCallback {
    private final RestfulServerExtension myRestfulServerExtension;
    private boolean myClearBetweenTests = true;
    private boolean myInitialized = false;
    private final List<T> myUpdates = new ArrayList<T>();

    public HashMapResourceProviderExtension(RestfulServerExtension theRestfulServerExtension, Class<T> theResourceType) {
        super(theRestfulServerExtension.getFhirContext(), theResourceType);
        this.myRestfulServerExtension = theRestfulServerExtension;
    }

    public void afterEach(ExtensionContext context) throws Exception {
        if (this.myClearBetweenTests) {
            this.myRestfulServerExtension.getRestfulServer().unregisterProvider((Object)this);
        }
    }

    @Search(allowUnknownParams=true)
    public synchronized IBundleProvider searchAll(RequestDetails theRequestDetails) {
        return super.searchAll(theRequestDetails);
    }

    public synchronized void clear() {
        super.clear();
        if (this.myUpdates != null) {
            this.myUpdates.clear();
        }
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        if (this.myClearBetweenTests) {
            this.clear();
            this.clearCounts();
            this.myRestfulServerExtension.getRestfulServer().registerProvider((Object)this);
        } else if (!this.myInitialized) {
            this.myInitialized = true;
            this.myRestfulServerExtension.getRestfulServer().registerProvider((Object)this);
        }
    }

    public synchronized MethodOutcome update(T theResource, String theConditional, RequestDetails theRequestDetails) {
        IBaseResource resourceClone = this.getFhirContext().newTerser().clone(theResource);
        this.myUpdates.add(resourceClone);
        return super.update(theResource, theConditional, theRequestDetails);
    }

    public HashMapResourceProviderExtension<T> dontClearBetweenTests() {
        this.myClearBetweenTests = false;
        return this;
    }

    public void waitForUpdateCount(long theCount) {
        Assertions.assertThat((long)theCount).isGreaterThanOrEqualTo(this.getCountUpdate());
        Awaitility.await().until(() -> this.getCountUpdate() == theCount);
    }

    public void waitForCreateCount(long theCount) {
        Assertions.assertThat((long)theCount).isGreaterThanOrEqualTo(this.getCountCreate());
        Awaitility.await().until(() -> this.getCountCreate() == theCount);
    }

    public void waitForDeleteCount(long theCount) {
        Assertions.assertThat((long)theCount).isGreaterThanOrEqualTo(this.getCountDelete());
        Awaitility.await().until(() -> this.getCountDelete() == theCount);
    }

    public List<T> getResourceUpdates() {
        return Collections.unmodifiableList(this.myUpdates);
    }
}

