/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.test.utilities.server;

import ca.uhn.fhir.rest.client.api.Header;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class RequestCaptureServlet
extends HttpServlet {
    public int ourResponseCount = 0;
    public String[] ourResponseBodies;
    public String ourResponseBody;
    public String ourResponseContentType;
    public int ourResponseStatus;
    public String ourRequestUri;
    public List<String> ourRequestUriAll;
    public String ourRequestMethod;
    public String ourRequestContentType;
    public byte[] ourRequestBodyBytes;
    public String ourRequestBodyString;
    public ArrayListMultimap<String, Header> ourRequestHeaders;
    public List<ArrayListMultimap<String, Header>> ourRequestHeadersAll;
    public Map<String, Header> ourRequestFirstHeaders;

    protected void service(HttpServletRequest theRequest, HttpServletResponse theResponse) throws IOException {
        this.ourRequestUri = theRequest.getRequestURL().toString();
        if (StringUtils.isNotBlank((CharSequence)theRequest.getQueryString())) {
            this.ourRequestUri = this.ourRequestUri + "?" + theRequest.getQueryString();
        }
        this.ourRequestUriAll.add(this.ourRequestUri);
        this.ourRequestMethod = theRequest.getMethod();
        this.ourRequestContentType = theRequest.getContentType();
        this.ourRequestBodyBytes = IOUtils.toByteArray((InputStream)theRequest.getInputStream());
        this.ourRequestBodyString = new String(this.ourRequestBodyBytes, StandardCharsets.UTF_8);
        this.ourRequestHeaders = ArrayListMultimap.create();
        this.ourRequestHeadersAll.add(this.ourRequestHeaders);
        this.ourRequestFirstHeaders = Maps.newHashMap();
        Enumeration headerNameEnum = theRequest.getHeaderNames();
        while (headerNameEnum.hasMoreElements()) {
            String nextName = (String)headerNameEnum.nextElement();
            Enumeration headerValueEnum = theRequest.getHeaders(nextName);
            while (headerValueEnum.hasMoreElements()) {
                String nextValue = (String)headerValueEnum.nextElement();
                if (!this.ourRequestFirstHeaders.containsKey(nextName)) {
                    this.ourRequestFirstHeaders.put(nextName, new Header(nextName, nextValue));
                }
                this.ourRequestHeaders.put((Object)nextName, (Object)new Header(nextName, nextValue));
            }
        }
        theResponse.setStatus(this.ourResponseStatus);
        if (this.ourResponseBody != null) {
            theResponse.setContentType(this.ourResponseContentType);
            theResponse.getWriter().write(this.ourResponseBody);
        } else if (this.ourResponseBodies != null) {
            theResponse.setContentType(this.ourResponseContentType);
            theResponse.getWriter().write(this.ourResponseBodies[this.ourResponseCount]);
        }
        ++this.ourResponseCount;
    }

    public void reset() {
        this.ourResponseCount = 0;
        this.ourRequestUri = null;
        this.ourRequestUriAll = Lists.newArrayList();
        this.ourResponseStatus = 200;
        this.ourResponseBody = null;
        this.ourResponseBodies = null;
        this.ourResponseContentType = null;
        this.ourRequestContentType = null;
        this.ourRequestBodyBytes = null;
        this.ourRequestBodyString = null;
        this.ourRequestHeaders = null;
        this.ourRequestFirstHeaders = null;
        this.ourRequestMethod = null;
        this.ourRequestHeadersAll = Lists.newArrayList();
    }
}

