/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.test.utilities.server;

import ca.uhn.fhir.test.utilities.server.RestfulServerExtension;
import org.apache.commons.lang3.Validate;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class ResourceProviderExtension<T>
implements BeforeEachCallback,
AfterEachCallback {
    private final RestfulServerExtension myRestfulServerExtension;
    private final T myProvider;

    public ResourceProviderExtension(RestfulServerExtension theRestfulServerExtension, T theProvider) {
        Validate.notNull((Object)theRestfulServerExtension);
        Validate.notNull(theProvider);
        this.myRestfulServerExtension = theRestfulServerExtension;
        this.myProvider = theProvider;
    }

    public void afterEach(ExtensionContext context) {
        this.myRestfulServerExtension.getRestfulServer().unregisterProvider(this.myProvider);
    }

    public void beforeEach(ExtensionContext context) {
        this.myRestfulServerExtension.getRestfulServer().registerProvider(this.myProvider);
    }

    public T getProvider() {
        return this.myProvider;
    }
}

