/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.test.utilities.server;

import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.test.utilities.server.RestfulServerExtension;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.springframework.util.Assert;

public class RestfulServerConfigurerExtension
implements BeforeEachCallback {
    private Supplier<RestfulServerExtension> myRestfulServerExtensionSupplier;
    private RestfulServerExtension myRestfulServerExtension;
    private final List<Consumer<RestfulServer>> myBeforeAllConsumers = new ArrayList<Consumer<RestfulServer>>();
    private final List<Consumer<RestfulServer>> myBeforeEachConsumers = new ArrayList<Consumer<RestfulServer>>();

    public RestfulServerConfigurerExtension(RestfulServerExtension theRestfulServerExtension) {
        Assert.notNull((Object)theRestfulServerExtension, (String)"theRestfulServerExtension must not be null");
        this.myRestfulServerExtension = theRestfulServerExtension;
    }

    public RestfulServerConfigurerExtension(Supplier<RestfulServerExtension> theRestfulServerExtension) {
        Assert.notNull(theRestfulServerExtension, (String)"theRestfulServerExtension must not be null");
        this.myRestfulServerExtensionSupplier = theRestfulServerExtension;
    }

    public RestfulServerConfigurerExtension withServerBeforeAll(Consumer<RestfulServer> theServer) {
        Assert.notNull(theServer, (String)"theServer must not be null");
        this.myBeforeAllConsumers.add(theServer);
        return this;
    }

    public RestfulServerConfigurerExtension withServerBeforeEach(Consumer<RestfulServer> theServer) {
        Assert.notNull(theServer, (String)"theServer must not be null");
        this.myBeforeEachConsumers.add(theServer);
        return this;
    }

    public void beforeEach(ExtensionContext theExtensionContext) throws Exception {
        this.ensureServerIsPresentAndRunning();
        String key = this.getClass().getName();
        if (!this.myRestfulServerExtension.getRunningServerUserData().containsKey(key)) {
            this.myRestfulServerExtension.getRunningServerUserData().put(key, key);
            for (Consumer<RestfulServer> next : this.myBeforeAllConsumers) {
                this.myRestfulServerExtension.withServer(next::accept);
            }
        }
        for (Consumer<RestfulServer> next : this.myBeforeEachConsumers) {
            this.myRestfulServerExtension.withServer(next::accept);
        }
    }

    private void ensureServerIsPresentAndRunning() {
        if (this.myRestfulServerExtension == null) {
            this.myRestfulServerExtension = this.myRestfulServerExtensionSupplier.get();
        }
        Assert.isTrue((boolean)this.myRestfulServerExtension.isRunning(), (String)"Server is not running");
    }
}

