/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.test.utilities.server;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.interceptor.api.IAnonymousInterceptor;
import ca.uhn.fhir.interceptor.api.IInterceptorService;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.client.api.ServerValidationModeEnum;
import ca.uhn.fhir.rest.server.IPagingProvider;
import ca.uhn.fhir.rest.server.IServerAddressStrategy;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.test.utilities.server.BaseJettyServerExtension;
import jakarta.servlet.http.HttpServlet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.lang3.Validate;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestfulServerExtension
extends BaseJettyServerExtension<RestfulServerExtension> {
    private static final Logger ourLog = LoggerFactory.getLogger(RestfulServerExtension.class);
    private FhirContext myFhirContext;
    private List<Object> myProviders = new ArrayList<Object>();
    private FhirVersionEnum myFhirVersion;
    private RestfulServer myServlet;
    private List<Consumer<RestfulServer>> myConsumers = new ArrayList<Consumer<RestfulServer>>();
    private Map<String, Object> myRunningServerUserData = new HashMap<String, Object>();
    private ServerValidationModeEnum myServerValidationMode = ServerValidationModeEnum.NEVER;
    private IPagingProvider myPagingProvider;

    public RestfulServerExtension(FhirContext theFhirContext, Object ... theProviders) {
        Validate.notNull((Object)theFhirContext);
        this.myFhirContext = theFhirContext;
        if (theProviders != null) {
            this.myProviders = new ArrayList<Object>(Arrays.asList(theProviders));
        }
    }

    public RestfulServerExtension(FhirVersionEnum theFhirVersionEnum) {
        Validate.notNull((Object)theFhirVersionEnum);
        this.myFhirVersion = theFhirVersionEnum;
    }

    public Map<String, Object> getRunningServerUserData() {
        return this.myRunningServerUserData;
    }

    @Override
    protected void startServer() throws Exception {
        super.startServer();
        this.myFhirContext.getRestfulClientFactory().setSocketTimeout(500000);
        this.myFhirContext.getRestfulClientFactory().setServerValidationMode(this.myServerValidationMode);
        ourLog.info("FHIR server has been started with base URL: {}", (Object)this.getBaseUrl());
    }

    @Override
    protected HttpServlet provideServlet() {
        if (this.myServlet == null) {
            this.myServlet = new RestfulServer(this.myFhirContext);
            this.myServlet.setDefaultPrettyPrint(true);
            if (this.myProviders != null) {
                this.myServlet.registerProviders(this.myProviders);
            }
            if (this.myPagingProvider != null) {
                this.myServlet.setPagingProvider(this.myPagingProvider);
            }
            this.myConsumers.forEach(t -> t.accept(this.myServlet));
        }
        return this.myServlet;
    }

    @Override
    public void stopServer() throws Exception {
        super.stopServer();
        if (!this.isRunning()) {
            return;
        }
        this.myRunningServerUserData.clear();
        this.myPagingProvider = null;
        this.myServlet = null;
    }

    private void createContextIfNeeded() {
        if (this.myFhirVersion != null) {
            this.myFhirContext = FhirContext.forCached((FhirVersionEnum)this.myFhirVersion);
        }
    }

    public IGenericClient getFhirClient() {
        return this.myFhirContext.newRestfulGenericClient(this.getBaseUrl());
    }

    public FhirContext getFhirContext() {
        this.createContextIfNeeded();
        return this.myFhirContext;
    }

    public RestfulServer getRestfulServer() {
        return this.myServlet;
    }

    @Override
    public void beforeEach(ExtensionContext theContext) throws Exception {
        this.createContextIfNeeded();
        super.beforeEach(theContext);
    }

    public RestfulServerExtension registerProvider(Object theProvider) {
        Validate.notNull((Object)theProvider);
        if (this.isStarted()) {
            this.myServlet.registerProvider(theProvider);
        } else {
            this.myProviders.add(theProvider);
        }
        return this;
    }

    public RestfulServerExtension withServer(Consumer<RestfulServer> theConsumer) {
        if (this.isStarted()) {
            theConsumer.accept(this.myServlet);
        } else {
            this.myConsumers.add(theConsumer);
        }
        return this;
    }

    private boolean isStarted() {
        return this.myServlet != null;
    }

    public RestfulServerExtension registerInterceptor(Object theInterceptor) {
        return this.withServer(t -> t.getInterceptorService().registerInterceptor(theInterceptor));
    }

    public RestfulServerExtension withValidationMode(ServerValidationModeEnum theValidationMode) {
        this.myServerValidationMode = theValidationMode;
        return this;
    }

    public void unregisterAllInterceptors() {
        this.myServlet.getInterceptorService().unregisterAllInterceptors();
    }

    public RestfulServerExtension withPagingProvider(IPagingProvider thePagingProvider) {
        if (this.isStarted()) {
            this.myServlet.setPagingProvider(thePagingProvider);
        } else {
            this.myPagingProvider = thePagingProvider;
        }
        return this;
    }

    public RestfulServerExtension unregisterInterceptor(Object theInterceptor) {
        return this.withServer(t -> t.getInterceptorService().unregisterInterceptor(theInterceptor));
    }

    public void unregisterProvider(Object theProvider) {
        this.withServer(t -> t.unregisterProvider(theProvider));
    }

    public Integer getDefaultPageSize() {
        return this.myServlet.getDefaultPageSize();
    }

    public void setDefaultPageSize(Integer theInitialDefaultPageSize) {
        this.myServlet.setDefaultPageSize(theInitialDefaultPageSize);
    }

    public IInterceptorService getInterceptorService() {
        return this.myServlet.getInterceptorService();
    }

    public RestfulServerExtension registerAnonymousInterceptor(Pointcut thePointcut, IAnonymousInterceptor theInterceptor) {
        return this.withServer(t -> t.getInterceptorService().registerAnonymousInterceptor(thePointcut, theInterceptor));
    }

    public RestfulServerExtension withDefaultResponseEncoding(EncodingEnum theEncodingEnum) {
        return this.withServer(t -> t.setDefaultResponseEncoding(theEncodingEnum));
    }

    public RestfulServerExtension setDefaultResponseEncoding(EncodingEnum theEncodingEnum) {
        return this.withServer(s -> this.myServlet.setDefaultResponseEncoding(theEncodingEnum));
    }

    public RestfulServerExtension setDefaultPrettyPrint(boolean theDefaultPrettyPrint) {
        this.withServer(s -> s.setDefaultPrettyPrint(theDefaultPrettyPrint));
        return this;
    }

    public RestfulServerExtension setServerAddressStrategy(IServerAddressStrategy theServerAddressStrategy) {
        this.withServer(s -> s.setServerAddressStrategy(theServerAddressStrategy));
        return this;
    }
}

