/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.test.utilities.server;

import ca.uhn.fhir.rest.annotation.Transaction;
import ca.uhn.fhir.rest.annotation.TransactionParam;
import ca.uhn.fhir.test.utilities.server.RestfulServerExtension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionCapturingProviderExtension<T extends IBaseBundle>
implements BeforeEachCallback,
AfterEachCallback {
    private static final Logger ourLog = LoggerFactory.getLogger(TransactionCapturingProviderExtension.class);
    private final RestfulServerExtension myRestfulServerExtension;
    private final PlainProvider myProvider = new PlainProvider();

    public TransactionCapturingProviderExtension(RestfulServerExtension theRestfulServerExtension, Class<T> theBundleType) {
        this.myRestfulServerExtension = theRestfulServerExtension;
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.myRestfulServerExtension.getRestfulServer().unregisterProvider((Object)this.myProvider);
        this.myProvider.clear();
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.myRestfulServerExtension.getRestfulServer().registerProvider((Object)this.myProvider);
    }

    public void waitForTransactionCount(int theCount) {
        Assertions.assertThat((int)theCount).isGreaterThanOrEqualTo(this.myProvider.size());
        Awaitility.await().until(() -> this.myProvider.size() == theCount);
    }

    public List<T> getTransactions() {
        return this.myProvider.getTransactions();
    }

    private class PlainProvider {
        private final List<T> myInputBundles = Collections.synchronizedList(new ArrayList());

        private PlainProvider() {
        }

        @Transaction
        public T transaction(@TransactionParam T theInput) {
            ourLog.info("Received transaction update");
            this.myInputBundles.add(theInput);
            return theInput;
        }

        public void clear() {
            this.myInputBundles.clear();
        }

        public int size() {
            return this.myInputBundles.size();
        }

        public List<T> getTransactions() {
            return Collections.unmodifiableList(this.myInputBundles);
        }
    }
}

