/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.test.utilities.validation;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.rest.annotation.RequiredParam;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.param.UriParam;
import ca.uhn.fhir.rest.server.IResourceProvider;
import ca.uhn.fhir.util.ClasspathUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IDomainResource;

public interface IValidationProviders {
    public static final String CODE_SYSTEM = "http://code.system/url";
    public static final String CODE_SYSTEM_VERSION = "1.0.0";
    public static final String CODE_SYSTEM_NAME = "Test Code System";
    public static final String CODE = "CODE";
    public static final String VALUE_SET_URL = "http://value.set/url";
    public static final String DISPLAY = "Explanation for code TestCode.";
    public static final String LANGUAGE = "en";
    public static final String ERROR_MESSAGE = "This is an error message";

    public static interface IMyLookupCodeProvider
    extends IResourceProvider {
        public void setLookupCodeResult(IValidationSupport.LookupCodeResult var1);
    }

    public static abstract class MyValidationProvider<T extends IDomainResource>
    implements IMyValidationProvider {
        private final Map<String, Exception> myExceptionMap = new HashMap<String, Exception>();
        private boolean myShouldThrowExceptionForResourceNotFound = true;
        private final Map<String, IBaseParameters> myTerminologyResponseMap = new HashMap<String, IBaseParameters>();
        private final Map<String, T> myTerminologyResourceMap = new HashMap<String, T>();

        static String getInputKey(String theOperation, String theUrl, String theCode) {
            return theOperation + "-" + theUrl + "#" + theCode;
        }

        public void setShouldThrowExceptionForResourceNotFound(boolean theShouldThrowExceptionForResourceNotFound) {
            this.myShouldThrowExceptionForResourceNotFound = theShouldThrowExceptionForResourceNotFound;
        }

        @Override
        public void addException(String theOperation, String theUrl, String theCode, Exception theException) {
            String inputKey = MyValidationProvider.getInputKey(theOperation, theUrl, theCode);
            this.myExceptionMap.put(inputKey, theException);
        }

        abstract Class<? extends IBaseParameters> getParameterType();

        @Override
        public <P extends IBaseParameters> void addTerminologyResponse(String theOperation, String theUrl, String theCode, P theReturnParams) {
            this.myTerminologyResponseMap.put(MyValidationProvider.getInputKey(theOperation, theUrl, theCode), theReturnParams);
        }

        @Override
        public IBaseParameters addTerminologyResponse(String theOperation, String theUrl, String theCode, FhirContext theFhirContext, String theTerminologyResponseFile) {
            IBaseParameters responseParams = (IBaseParameters)ClasspathUtil.loadResource((FhirContext)theFhirContext, this.getParameterType(), (String)theTerminologyResponseFile);
            this.addTerminologyResponse(theOperation, theUrl, theCode, responseParams);
            return responseParams;
        }

        protected void addTerminologyResource(String theUrl, T theResource) {
            this.myTerminologyResourceMap.put(theUrl, theResource);
        }

        public abstract T addTerminologyResource(String var1);

        protected IBaseParameters getTerminologyResponse(String theOperation, String theUrl, String theCode) throws Exception {
            String inputKey = MyValidationProvider.getInputKey(theOperation, theUrl, theCode);
            if (this.myExceptionMap.containsKey(inputKey)) {
                throw this.myExceptionMap.get(inputKey);
            }
            IBaseParameters params = this.myTerminologyResponseMap.get(inputKey);
            if (params == null) {
                throw new IllegalStateException("Test setup incomplete. Missing return params for " + inputKey);
            }
            return params;
        }

        protected T getTerminologyResource(UriParam theUrlParam) {
            if (theUrlParam.isEmpty()) {
                throw new IllegalStateException("CodeSystem url should not be null.");
            }
            String urlValue = theUrlParam.getValue();
            if (!this.myTerminologyResourceMap.containsKey(urlValue) && this.myShouldThrowExceptionForResourceNotFound) {
                throw new IllegalStateException("Test setup incomplete. CodeSystem not found " + urlValue);
            }
            return (T)((IDomainResource)this.myTerminologyResourceMap.get(urlValue));
        }

        @Search
        public List<T> find(@RequiredParam(name="url") UriParam theUrlParam) {
            T resource = this.getTerminologyResource(theUrlParam);
            return resource != null ? List.of(resource) : List.of();
        }
    }

    public static interface IMyValidationProvider
    extends IResourceProvider {
        public void addException(String var1, String var2, String var3, Exception var4);

        public <P extends IBaseParameters> void addTerminologyResponse(String var1, String var2, String var3, P var4);

        public IBaseParameters addTerminologyResponse(String var1, String var2, String var3, FhirContext var4, String var5);
    }
}

