/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.test.utilities.validation;

import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.test.utilities.validation.IValidationProviders;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.CodeSystem;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.IdType;
import org.hl7.fhir.dstu3.model.Parameters;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;

public interface IValidationProvidersDstu3 {

    public static class MyValueSetProviderDstu3
    extends IValidationProviders.MyValidationProvider<ValueSet> {
        @Operation(name="$validate-code", idempotent=true, returnParameters={@OperationParam(name="result", type=BooleanType.class, min=1), @OperationParam(name="message", type=StringType.class), @OperationParam(name="display", type=StringType.class)})
        public IBaseParameters validateCode(HttpServletRequest theServletRequest, @IdParam(optional=true) IdType theId, @OperationParam(name="url", min=0, max=1) UriType theValueSetUrl, @OperationParam(name="code", min=0, max=1) CodeType theCode, @OperationParam(name="system", min=0, max=1) UriType theSystem, @OperationParam(name="display", min=0, max=1) StringType theDisplay, @OperationParam(name="valueSet") ValueSet theValueSet) throws Exception {
            String url = theValueSetUrl != null ? (String)theValueSetUrl.getValue() : null;
            String code = theCode != null ? (String)theCode.getValue() : null;
            return this.getTerminologyResponse("$validate-code", url, code);
        }

        public Class<? extends IBaseResource> getResourceType() {
            return ValueSet.class;
        }

        @Override
        Class<Parameters> getParameterType() {
            return Parameters.class;
        }

        @Override
        public ValueSet addTerminologyResource(String theUrl) {
            ValueSet valueSet = new ValueSet();
            valueSet.setId(theUrl.substring(0, theUrl.lastIndexOf("/")));
            valueSet.setUrl(theUrl);
            this.addTerminologyResource(theUrl, valueSet);
            return valueSet;
        }
    }

    public static class MyCodeSystemProviderDstu3
    extends IValidationProviders.MyValidationProvider<CodeSystem> {
        @Operation(name="$validate-code", idempotent=true, returnParameters={@OperationParam(name="result", type=BooleanType.class, min=1), @OperationParam(name="message", type=StringType.class), @OperationParam(name="display", type=StringType.class)})
        public IBaseParameters validateCode(HttpServletRequest theServletRequest, @IdParam(optional=true) IdType theId, @OperationParam(name="url", min=0, max=1) UriType theCodeSystemUrl, @OperationParam(name="code", min=0, max=1) CodeType theCode, @OperationParam(name="display", min=0, max=1) StringType theDisplay) throws Exception {
            String url = theCodeSystemUrl != null ? (String)theCodeSystemUrl.getValue() : null;
            String code = theCode != null ? (String)theCode.getValue() : null;
            return this.getTerminologyResponse("$validate-code", url, code);
        }

        @Operation(name="$lookup", idempotent=true, returnParameters={@OperationParam(name="name", type=StringType.class, min=1), @OperationParam(name="version", type=StringType.class), @OperationParam(name="display", type=StringType.class, min=1), @OperationParam(name="abstract", type=BooleanType.class, min=1), @OperationParam(name="property", type=StringType.class, min=0, max=-1)})
        public IBaseParameters lookup(HttpServletRequest theServletRequest, @OperationParam(name="code", max=1) CodeType theCode, @OperationParam(name="system", max=1) UriType theSystem, @OperationParam(name="coding", max=1) Coding theCoding, @OperationParam(name="version", max=1) StringType theVersion, @OperationParam(name="displayLanguage", max=1) CodeType theDisplayLanguage, @OperationParam(name="property", max=-1) List<CodeType> thePropertyNames, RequestDetails theRequestDetails) throws Exception {
            String url = theSystem != null ? (String)theSystem.getValue() : null;
            String code = theCode != null ? (String)theCode.getValue() : null;
            return this.getTerminologyResponse("$lookup", url, code);
        }

        public Class<? extends IBaseResource> getResourceType() {
            return CodeSystem.class;
        }

        @Override
        Class<Parameters> getParameterType() {
            return Parameters.class;
        }

        @Override
        public CodeSystem addTerminologyResource(String theUrl) {
            CodeSystem codeSystem = new CodeSystem();
            codeSystem.setId(theUrl.substring(0, theUrl.lastIndexOf("/")));
            codeSystem.setUrl(theUrl);
            this.addTerminologyResource(theUrl, codeSystem);
            return codeSystem;
        }
    }
}

