/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.test.concurrency;

import java.util.concurrent.Phaser;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockstepEnumPhaser<E extends Enum<E>> {
    private static final Logger ourLog = LoggerFactory.getLogger(LockstepEnumPhaser.class);
    final Phaser myPhaser;
    final Class<E> myEnumClass;
    final E[] myEnumConstants;

    public LockstepEnumPhaser(int theParticipantCount, Class<E> theEnumClass) {
        this.myPhaser = new Phaser(theParticipantCount);
        this.myEnumClass = theEnumClass;
        this.myEnumConstants = (Enum[])this.myEnumClass.getEnumConstants();
    }

    public void assertInPhase(E theStageEnum) {
        ((AbstractComparableAssert)Assertions.assertThat(theStageEnum).as("In stage" + theStageEnum, new Object[0])).isEqualTo(this.getPhase());
    }

    public E getPhase() {
        return this.phaseToEnum(this.myPhaser.getPhase());
    }

    public E arriveAndAwaitSharedEndOf(E thePhase) {
        this.checkAwait(thePhase);
        E current = this.arrive();
        org.junit.jupiter.api.Assertions.assertEquals(current, thePhase);
        return this.doAwait(thePhase);
    }

    public E arriveAndDeregister() {
        return this.phaseToEnum(this.myPhaser.arriveAndDeregister());
    }

    public E register() {
        return this.phaseToEnum(this.myPhaser.register());
    }

    E arrive() {
        E result = this.phaseToEnum(this.myPhaser.arrive());
        ourLog.info("Arrive to my end of phase {}", result);
        return result;
    }

    private E doAwait(E thePhase) {
        ourLog.debug("Start doAwait - {}", thePhase);
        E phase = this.phaseToEnum(this.myPhaser.awaitAdvance(((Enum)thePhase).ordinal()));
        ourLog.info("Done waiting for end of {}.  Now starting {}", thePhase, this.getPhase());
        return phase;
    }

    private void checkAwait(E thePhase) {
        E currentPhase = this.getPhase();
        if (((Enum)currentPhase).ordinal() < ((Enum)thePhase).ordinal()) {
            Fail.fail((String)String.format("Can't wait for end of phase %s, still in phase %s", thePhase, currentPhase));
        } else if (((Enum)currentPhase).ordinal() > ((Enum)thePhase).ordinal()) {
            Fail.fail((String)String.format("Can't wait for end of phase %s, already in phase %s", thePhase, currentPhase));
        }
    }

    private E phaseToEnum(int resultOrdinal) {
        if (resultOrdinal >= this.myEnumConstants.length) {
            throw new IllegalStateException("Enum " + this.myEnumClass.getName() + " should declare one more enum value for post-completion reporting of phase " + resultOrdinal);
        }
        return this.myEnumConstants[resultOrdinal];
    }
}

