/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.test.concurrency;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IAnonymousInterceptor;
import ca.uhn.fhir.interceptor.api.IPointcut;
import ca.uhn.test.concurrency.IPointcutLatch;
import ca.uhn.test.concurrency.PointcutLatchException;
import ca.uhn.test.concurrency.PointcutLatchSession;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointcutLatch
implements IAnonymousInterceptor,
IPointcutLatch {
    private static final Logger ourLog = LoggerFactory.getLogger(PointcutLatch.class);
    private static final int DEFAULT_TIMEOUT_SECONDS = 10;
    private final String myName;
    private final IPointcut myPointcut;
    private boolean myStrict = true;
    private final AtomicLong myLastInvoke = new AtomicLong();
    private int myDefaultTimeoutSeconds = 10;
    private final List<PointcutLatchException> myUnexpectedInvocations = new ArrayList<PointcutLatchException>();
    private final AtomicReference<PointcutLatchSession> myPointcutLatchSession = new AtomicReference();

    public PointcutLatch(IPointcut thePointcut) {
        this.myName = thePointcut.name();
        this.myPointcut = thePointcut;
    }

    public PointcutLatch(String theName) {
        this.myName = theName;
        this.myPointcut = null;
    }

    public void runWithExpectedCount(int theExpectedCount, Runnable r) throws InterruptedException {
        this.setExpectedCount(theExpectedCount);
        r.run();
        this.awaitExpected();
    }

    public long getLastInvoke() {
        return this.myLastInvoke.get();
    }

    public void setDefaultTimeoutSeconds(int theDefaultTimeoutSeconds) {
        this.myDefaultTimeoutSeconds = theDefaultTimeoutSeconds;
    }

    @Override
    public void setExpectedCount(int theCount) {
        this.setExpectedCount(theCount, true);
    }

    public void setExpectedCount(int theCount, boolean theExactMatch) {
        if (this.myPointcutLatchSession.get() != null) {
            String previousStack = this.myPointcutLatchSession.get().getStackTrace();
            throw new PointcutLatchException(Msg.code((int)1480) + "setExpectedCount() called before previous awaitExpected() completed. Previous set stack:\n" + previousStack, this.myName);
        }
        this.startSession(theCount, theExactMatch);
        if (theExactMatch) {
            ourLog.info("Expecting exactly {} calls to {} latch", (Object)theCount, (Object)this.myName);
        } else {
            ourLog.info("Expecting at least {} calls to {} latch", (Object)theCount, (Object)this.myName);
        }
    }

    public void setExpectAtLeast(int theCount) {
        this.setExpectedCount(theCount, false);
    }

    public boolean isSet() {
        return this.myPointcutLatchSession.get() != null;
    }

    private void startSession(int theCount, boolean theExactMatch) {
        this.myPointcutLatchSession.set(new PointcutLatchSession(this.getName(), theCount, theExactMatch));
    }

    private String getName() {
        return this.myName + " " + this.getClass().getSimpleName();
    }

    @Override
    public List<HookParams> awaitExpected() throws InterruptedException {
        return this.awaitExpectedWithTimeout(this.myDefaultTimeoutSeconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HookParams> awaitExpectedWithTimeout(int theTimeoutSecond) throws InterruptedException {
        List<HookParams> retval;
        block4: {
            PointcutLatchSession initialSession = this.myPointcutLatchSession.get();
            try {
                if (this.isSet()) {
                    retval = this.myPointcutLatchSession.get().awaitExpectedWithTimeout(theTimeoutSecond);
                    Validate.isTrue((boolean)initialSession.equals(this.myPointcutLatchSession.get()), (String)"Concurrency error: Latch session switched while waiting.", (Object[])new Object[0]);
                    break block4;
                }
                throw new PointcutLatchException("awaitExpected() called before setExpected() called.", this.myName);
            }
            finally {
                this.clear();
            }
        }
        return retval;
    }

    @Override
    public void clear() {
        ourLog.debug("Clearing latch {}", (Object)this.getName());
        this.checkExceptions();
        this.myPointcutLatchSession.set(null);
        this.myUnexpectedInvocations.clear();
    }

    private void checkExceptions() {
        if (!this.myStrict) {
            return;
        }
        if (this.myUnexpectedInvocations.size() > 0) {
            PointcutLatchException firstException = this.myUnexpectedInvocations.get(0);
            int size = this.myUnexpectedInvocations.size();
            if (firstException != null) {
                throw new AssertionError(Msg.code((int)2344) + this.getName() + " had " + size + " exceptions.  Throwing first one.", firstException);
            }
        }
    }

    public void invoke(IPointcut thePointcut, HookParams theArgs) {
        this.myLastInvoke.set(System.currentTimeMillis());
        try {
            PointcutLatchSession session = this.myPointcutLatchSession.get();
            if (session == null) {
                throw new PointcutLatchException(Msg.code((int)1485) + "invoke() called outside of setExpectedCount() .. awaitExpected().  Probably got more invocations than expected or clear() was called before invoke().", this.myName, theArgs);
            }
            session.invoke(theArgs);
        }
        catch (PointcutLatchException e) {
            this.myUnexpectedInvocations.add(e);
            throw e;
        }
    }

    public void call(Object arg) {
        this.invoke(this.myPointcut, new HookParams(new Object[]{arg}));
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.myName).append("pointCutLatchSession", this.myPointcutLatchSession).toString();
    }

    public void setStrict(Boolean theStrict) {
        this.myStrict = theStrict;
    }

    public static <T> T getInvocationParameterOfType(List<HookParams> theHookParams, Class<T> theType) {
        Validate.notNull(theHookParams);
        Validate.isTrue((theHookParams.size() == 1 ? 1 : 0) != 0, (String)"Expected Pointcut to be invoked 1 time", (Object[])new Object[0]);
        HookParams hookParams = theHookParams.get(0);
        ListMultimap paramsForType = hookParams.getParamsForType();
        List objects = paramsForType.get(theType);
        Validate.isTrue((objects.size() == 1 ? 1 : 0) != 0);
        return (T)objects.get(0);
    }

    public static Object getLatchInvocationParameter(List<HookParams> theHookParams) {
        Validate.notNull(theHookParams);
        Validate.isTrue((theHookParams.size() == 1 ? 1 : 0) != 0, (String)"Expected Pointcut to be invoked 1 time", (Object[])new Object[0]);
        return PointcutLatch.getLatchInvocationParameter(theHookParams, 0);
    }

    public static Object getLatchInvocationParameter(List<HookParams> theHookParams, int index) {
        Validate.notNull(theHookParams);
        HookParams arg = theHookParams.get(index);
        Validate.isTrue((arg.values().size() == 1 ? 1 : 0) != 0, (String)"Expected pointcut to be invoked with 1 argument", (Object[])new Object[0]);
        return arg.values().iterator().next();
    }
}

