/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.test.concurrency;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.test.concurrency.LatchTimedOutError;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointcutLatchSession {
    private static final Logger ourLog = LoggerFactory.getLogger(PointcutLatchSession.class);
    private final List<String> myFailures = Collections.synchronizedList(new ArrayList());
    private final List<HookParams> myCalledWith = Collections.synchronizedList(new ArrayList());
    private final CountDownLatch myCountdownLatch;
    private final String myStacktrace;
    private final String myName;
    private final int myInitialCount;
    private final boolean myExactMatch;

    PointcutLatchSession(String theName, int theCount, boolean theExactMatch) {
        this.myName = theName;
        this.myInitialCount = theCount;
        this.myCountdownLatch = new CountDownLatch(theCount);
        this.myExactMatch = theExactMatch;
        try {
            throw new Exception(Msg.code((int)1481));
        }
        catch (Exception e) {
            this.myStacktrace = ExceptionUtils.getStackTrace((Throwable)e);
            return;
        }
    }

    String getStackTrace() {
        return this.myStacktrace;
    }

    List<HookParams> awaitExpectedWithTimeout(int theTimeoutSecond) throws InterruptedException {
        if (!this.myCountdownLatch.await(theTimeoutSecond, TimeUnit.SECONDS)) {
            if (!this.myFailures.isEmpty()) {
                ourLog.error(String.join((CharSequence)",", this.myFailures));
            }
            throw new LatchTimedOutError(Msg.code((int)1483) + this.myName + " timed out waiting " + theTimeoutSecond + " seconds for latch to countdown from " + this.myInitialCount + " to 0.  Is " + this.myCountdownLatch.getCount() + ".");
        }
        Object error = this.myName;
        if (this.myFailures.size() > 0) {
            ArrayList<String> failures = new ArrayList<String>(this.myFailures);
            error = failures.size() > 1 ? (String)error + " ERRORS: \n" : (String)error + " ERROR: ";
            error = (String)error + String.join((CharSequence)"\n", failures);
            error = (String)error + "\nLatch called " + this.myCalledWith.size() + " times with values:\n" + StringUtils.join(this.myCalledWith, (String)"\n");
            throw new AssertionError((Object)(Msg.code((int)1484) + (String)error));
        }
        return this.myCalledWith;
    }

    void invoke(HookParams theArgs) {
        if (this.myExactMatch && this.myCountdownLatch.getCount() <= 0L) {
            this.myFailures.add("invoke() called when countdown was zero.");
        }
        this.myCalledWith.add(theArgs);
        ourLog.debug("Called {} {} with {}", new Object[]{this.myName, this.myCountdownLatch, theArgs});
        this.myCountdownLatch.countDown();
    }

    List<HookParams> getCalledWith() {
        return this.myCalledWith;
    }
}

