/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.test.junit;

import ca.uhn.test.junit.JunitFieldProvider;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.ReflectionUtils;

public class JunitFieldParameterProviderExtension
implements BeforeAllCallback,
BeforeEachCallback,
ParameterResolver {
    Set<Object> myValues = new HashSet<Object>();

    public JunitFieldParameterProviderExtension() {
    }

    public JunitFieldParameterProviderExtension(Object ... theValues) {
        Collections.addAll(this.myValues, theValues);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> paramType = parameterContext.getParameter().getType();
        return this.myValues.stream().anyMatch(v -> paramType.isAssignableFrom(v.getClass()));
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> paramType = parameterContext.getParameter().getType();
        return this.myValues.stream().filter(v -> paramType.isAssignableFrom(v.getClass())).findAny().orElseThrow();
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        this.collectFields(null, context.getRequiredTestClass(), ReflectionUtils::isStatic);
    }

    public void beforeEach(ExtensionContext context) {
        context.getRequiredTestInstances().getAllInstances().forEach(instance -> this.collectFields(instance, instance.getClass(), ReflectionUtils::isStatic));
    }

    private void collectFields(Object testInstance, Class<?> testClass, Predicate<Field> predicate) {
        AnnotationUtils.findAnnotatedFields(testClass, JunitFieldProvider.class, predicate).forEach(field -> {
            try {
                ReflectionUtils.makeAccessible((AccessibleObject)field);
                this.myValues.add(field.get(testInstance));
            }
            catch (Exception t) {
                ExceptionUtils.throwAsUncheckedException((Throwable)t);
            }
        });
    }
}

