/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.test.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.SoftAssertions;

public class AssertJson
extends AbstractAssert<AssertJson, String> {
    public AssertJson(String actual) {
        super((Object)actual, AssertJson.class);
    }

    public static AssertJson assertThat(String actual) {
        return new AssertJson(actual);
    }

    public AssertJson hasPath(String thePath) {
        this.isNotNull();
        this.isNotEmpty(thePath);
        Assertions.assertThat((boolean)this.isJsonObjStr(this.actual)).isTrue();
        Map<String, Object> actualMap = AssertJson.getMap((String)this.actual);
        Assertions.assertThat(actualMap).isNotNull();
        this.getPathMap(thePath);
        return this;
    }

    private AssertJson isNotEmpty(String thePath) {
        Assertions.assertThat((String)thePath).isNotEmpty();
        return this;
    }

    public AssertJson hasKeys(String ... theKeys) {
        this.isNotNull();
        Map<String, Object> map = AssertJson.getMap((String)this.actual);
        Assertions.assertThat(map).isNotNull();
        Assertions.assertThat(map.keySet()).containsAll(Arrays.asList(theKeys));
        return this;
    }

    public AssertJson hasExactlyKeys(String ... theKeys) {
        this.isNotNull();
        Map<String, Object> map = AssertJson.getMap((String)this.actual);
        Assertions.assertThat(map).isNotNull();
        Assertions.assertThat(map.keySet()).hasSameElementsAs(Arrays.asList(theKeys));
        return this;
    }

    public AssertJson hasExactlyKeysWithValues(List<String> theKeys, List<? extends Serializable> theValues) {
        this.isNotNull();
        if (!this.checkSizes(theKeys.size(), theValues.size())) {
            return this;
        }
        Map<String, Object> map = AssertJson.getMap((String)this.actual);
        Assertions.assertThat(map).isNotNull();
        Assertions.assertThat(map.keySet()).hasSameElementsAs(theKeys);
        for (int i = 0; i < theKeys.size(); ++i) {
            this.hasKeyWithValue(theKeys.get(i), theValues.get(i));
        }
        return this;
    }

    public AssertJson hasKeyWithValue(String theKey, Object theExpectedValue) {
        this.isNotNull();
        Map<String, Object> actualMap = AssertJson.getMap((String)this.actual);
        Assertions.assertThat(actualMap).isNotNull();
        Object actualValue = actualMap.get(theKey);
        JsonTestTypes actualValueType = this.getType(actualValue);
        JsonTestTypes expectedValueType = this.getType(theExpectedValue);
        if (actualValueType != expectedValueType) {
            Fail.fail((String)this.getDifferentTypesMessage(theKey, actualValueType, expectedValueType));
        }
        if (this.isJsonObjStr(theExpectedValue)) {
            this.assertJsonObject(actualMap, theKey, theExpectedValue);
            return this;
        }
        if (this.isJsonList(theExpectedValue)) {
            this.assertJsonList(actualMap, theKey, theExpectedValue);
            return this;
        }
        Assertions.assertThat(actualMap).extracting(theKey).isEqualTo(theExpectedValue);
        return this;
    }

    private void assertJsonList(Map<String, Object> theActualMap, String theKey, Object theExpectedValue) {
        List<?> expectedValueList = this.getList((String)theExpectedValue);
        Assertions.assertThat(expectedValueList).isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)theActualMap.get(theKey)).isNotNull()).isInstanceOf(Collection.class);
        List actualValueList = (List)theActualMap.get(theKey);
        Assertions.assertThat((List)actualValueList).asList().hasSameElementsAs(expectedValueList);
    }

    private JsonTestTypes getType(Object theValue) {
        if (theValue instanceof Map) {
            return JsonTestTypes.JSON_OBJECT;
        }
        if (this.isJsonObjStr(theValue)) {
            AssertJson.getMap((String)theValue);
            return JsonTestTypes.JSON_OBJECT;
        }
        if (this.isJsonList(theValue)) {
            return JsonTestTypes.JSON_LIST;
        }
        return JsonTestTypes.STRING_NOT_JSON;
    }

    private String getDifferentTypesMessage(String theKey, JsonTestTypes theActualValueType, JsonTestTypes theExpectedValueType) {
        return "Types mismatch. Te expected " + (String)(theKey == null ? " " : "'" + theKey + "' ") + "value is a " + theExpectedValueType.myDisplay + " whereas the actual value is a " + theActualValueType.myDisplay;
    }

    private boolean isJsonList(Object theValue) {
        String stringValue;
        return theValue instanceof Collection || theValue instanceof String && (stringValue = (String)theValue).trim().startsWith("[") && stringValue.trim().endsWith("]");
    }

    private void assertJsonObject(Map<String, Object> theActualMap, String theKey, Object theValue) {
        Map<String, Object> expectedValueMap = AssertJson.getMap((String)theValue);
        Assertions.assertThat(expectedValueMap).isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)theActualMap.get(theKey)).isNotNull()).isInstanceOf(Map.class);
        Map actualValueMap = (Map)theActualMap.get(theKey);
        SoftAssertions lazyly = new SoftAssertions();
        for (String key : actualValueMap.keySet()) {
            ((MapAssert)lazyly.assertThat(actualValueMap).as("Unexpected value for key: " + key + ":", new Object[0])).extracting(key).isEqualTo(expectedValueMap.get(key));
        }
        lazyly.assertAll();
    }

    private boolean isJsonObjStr(Object theValue) {
        if (theValue instanceof String) {
            String strValue = (String)theValue;
            String trimmed = this.trimAll(strValue);
            return trimmed.startsWith("{") && trimmed.endsWith("}") && this.isValidJson(trimmed);
        }
        return false;
    }

    private String trimAll(String theString) {
        return theString.trim().replace("\n", "").replace("\t", "");
    }

    private boolean isValidJson(String theStrValue) {
        AssertJson.getMap(theStrValue);
        return true;
    }

    public AssertJson hasKeysWithValues(List<String> theKeys, List<Object> theValues) {
        this.isNotNull();
        this.checkSizes(theKeys.size(), theValues.size());
        Map<String, Object> map = AssertJson.getMap((String)this.actual);
        Assertions.assertThat(map).isNotNull();
        Assertions.assertThat(map.keySet()).containsAll(theKeys);
        this.checkKeysAndValues(map, theKeys, theValues);
        return this;
    }

    private void checkKeysAndValues(Map<String, Object> theExpected, List<String> theKeys, List<Object> theValues) {
        SoftAssertions lazyly = new SoftAssertions();
        for (int i = 0; i < theKeys.size(); ++i) {
            ((MapAssert)lazyly.assertThat(theExpected).as("Unexpected value for key: " + theKeys.get(i) + ":", new Object[0])).extracting(theKeys.get(i)).isEqualTo(theValues.get(i));
        }
        lazyly.assertAll();
    }

    private boolean checkSizes(int keysSize, int valuesSize) {
        if (keysSize != valuesSize) {
            Fail.fail((String)("Keys and values should have same size. Received " + keysSize + " keys and " + valuesSize + " values."));
            return false;
        }
        return true;
    }

    @Nonnull
    private static Map<String, Object> getMap(String theJsonString) {
        try {
            return (Map)new ObjectMapper().readValue((InputStream)new ByteArrayInputStream(theJsonString.getBytes()), (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException theE) {
            Fail.fail((String)("IOException: " + theE));
            return Collections.emptyMap();
        }
    }

    private List<?> getList(String theJsonString) {
        try {
            return (List)new ObjectMapper().readValue((InputStream)new ByteArrayInputStream(theJsonString.getBytes()), new TypeReference<List<?>>(){});
        }
        catch (IOException theE) {
            Fail.fail((String)("IOException: " + theE));
            return Collections.emptyList();
        }
    }

    public AssertJson hasPaths(String ... thePaths) {
        for (String path : thePaths) {
            this.hasPath(path);
        }
        return this;
    }

    public AssertJson hasPathWithValue(String thePath, String theValue) {
        String[] pathElements = thePath.split("\\.");
        if (pathElements.length == 1) {
            this.hasKeyWithValue(thePath, theValue);
        }
        Map<String, Object> pathMap = this.getPathMap(thePath);
        String lastPathElement = pathElements[pathElements.length - 1];
        if (this.isJsonObjStr(theValue)) {
            Assertions.assertThat(pathMap).extracting(lastPathElement).isEqualTo(AssertJson.getMap(theValue));
            return this;
        }
        if (this.isJsonList(theValue)) {
            Assertions.assertThat(pathMap).extracting(lastPathElement).asList().hasSameElementsAs(this.getList(theValue));
            return this;
        }
        Assertions.assertThat(pathMap).extracting(pathElements[pathElements.length - 1]).isEqualTo((Object)theValue);
        return this;
    }

    public AssertJson hasPathsWithValues(List<String> thePaths, List<String> theValues) {
        if (thePaths.size() != theValues.size()) {
            Fail.fail((String)("Paths size (" + thePaths.size() + ") is different than values size (" + theValues.size() + ")"));
            return this;
        }
        for (int i = 0; i < thePaths.size(); ++i) {
            this.hasPathWithValue(thePaths.get(i), theValues.get(i));
        }
        return this;
    }

    private Map<String, Object> getPathMap(String thePath) {
        String[] pathElements = thePath.split("\\.");
        StringBuilder pathSoFar = new StringBuilder();
        Map pathMap = AssertJson.getMap((String)this.actual);
        for (int i = 0; i < pathElements.length - 1; ++i) {
            Map aMap;
            String pathElement = pathElements[i];
            pathSoFar.append((String)(StringUtils.isNotEmpty((CharSequence)pathSoFar) ? "." + pathElement : pathElement));
            Object pathValue = pathMap.get(pathElement);
            this.assertIsJsonObject(pathSoFar.toString(), pathValue);
            pathMap = aMap = (Map)pathValue;
        }
        return pathMap;
    }

    private void assertIsJsonObject(String thePath, Object theValue) {
        if (theValue instanceof Map) {
            return;
        }
        if (theValue instanceof String) {
            String stringValue = (String)theValue;
            if (!this.isJsonObjStr(theValue)) {
                Fail.fail((String)(thePath + " doesn't contain a json object but a plain string"));
                return;
            }
            try {
                AssertJson.getMap(stringValue);
            }
            catch (Exception theE) {
                Fail.fail((String)(thePath + " doesn't contain a json object"));
            }
            return;
        }
        String msg = "Path: " + thePath + "' is not a json object but a Json  list";
        if (this.isJsonList(theValue)) {
            ((ObjectAssert)Assertions.assertThat((Object)theValue).as(msg, new Object[0])).isInstanceOf(Map.class);
        }
    }

    static enum JsonTestTypes {
        STRING_NOT_JSON("plain string (not json)"),
        JSON_OBJECT("json object"),
        JSON_LIST("json list"),
        JSON_STRING("json string");

        final String myDisplay;

        private JsonTestTypes(String theDisplay) {
            this.myDisplay = theDisplay;
        }
    }
}

