/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.test.util;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.read.ListAppender;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogbackTestExtension
implements BeforeEachCallback,
AfterEachCallback {
    private final ch.qos.logback.classic.Logger myLogger;
    private final Level myLevel;
    private ListAppender<ILoggingEvent> myListAppender = null;
    private Level mySavedLevel;

    public LogbackTestExtension(ch.qos.logback.classic.Logger theLogger) {
        this.myLogger = theLogger;
        this.myLevel = null;
    }

    public LogbackTestExtension(ch.qos.logback.classic.Logger theLogger, Level theTestLogLevel) {
        this.myLogger = theLogger;
        this.myLevel = theTestLogLevel;
    }

    public LogbackTestExtension(String theLoggerName) {
        this((ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)theLoggerName));
    }

    public LogbackTestExtension() {
        this("ROOT");
    }

    public LogbackTestExtension(String theLoggerName, Level theLevel) {
        this((ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)theLoggerName), theLevel);
    }

    public LogbackTestExtension(Class<?> theClass) {
        this(theClass.getName());
    }

    public LogbackTestExtension(Class<?> theClass, Level theLevel) {
        this(theClass.getName(), theLevel);
    }

    public LogbackTestExtension(Logger theLogger) {
        this((ch.qos.logback.classic.Logger)theLogger);
    }

    public List<ILoggingEvent> getLogEvents() {
        return new ArrayList<ILoggingEvent>(this.myListAppender.list);
    }

    public void clearEvents() {
        this.myListAppender.list.clear();
    }

    public ListAppender<ILoggingEvent> getAppender() {
        return this.myListAppender;
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.setUp();
    }

    public void setUp() {
        this.setUp(this.myLevel);
    }

    public void setUp(Level theLevel) {
        this.myListAppender = new ListAppender();
        this.myListAppender.start();
        this.myLogger.addAppender(this.myListAppender);
        if (theLevel != null) {
            this.mySavedLevel = this.myLogger.getLevel();
            this.myLogger.setLevel(theLevel);
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.myLogger.detachAppender(this.myListAppender);
        this.myListAppender.stop();
        if (this.myLevel != null) {
            this.myLogger.setLevel(this.mySavedLevel);
        }
    }

    public List<ILoggingEvent> getLogEvents(Predicate<ILoggingEvent> thePredicate) {
        return this.getLogEvents().stream().filter(thePredicate).toList();
    }

    @Nonnull
    public List<String> getLogMessages() {
        return this.getLogEvents().stream().map(ILoggingEvent::getMessage).toList();
    }
}

