/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.test.util;

import ca.uhn.test.util.LogbackTestExtension;
import ca.uhn.test.util.LoggingEventPredicates;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import jakarta.annotation.Nonnull;
import java.util.function.Predicate;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;

public class LogbackTestExtensionAssert
extends AbstractAssert<LogbackTestExtensionAssert, LogbackTestExtension> {
    private static final String HAS_ERROR_MSG_1 = "has logging message with message containing %s";
    private static final String HAS_ERROR_MSG_2 = "has logging message with level %s and message containing %s";

    @Nonnull
    public static LogbackTestExtensionAssert assertThat(@Nonnull LogbackTestExtension theLogbackTestExtension) {
        return new LogbackTestExtensionAssert(theLogbackTestExtension, LogbackTestExtensionAssert.class);
    }

    private LogbackTestExtensionAssert(LogbackTestExtension theLogbackTestExtension, Class<?> selfType) {
        super((Object)theLogbackTestExtension, selfType);
    }

    @Nonnull
    public LogbackTestExtensionAssert containsExactMessages(String ... theMessages) {
        this.isNotNull();
        Assertions.assertThat(((LogbackTestExtension)this.actual).getLogMessages()).containsExactly((Object[])theMessages);
        return this;
    }

    @Nonnull
    public LogbackTestExtensionAssert hasMessage(@Nonnull String theMessage) {
        this.isNotNull();
        Predicate<ILoggingEvent> predicate = LoggingEventPredicates.makeMessageContains(theMessage);
        Condition condition = new Condition(LoggingEventPredicates.makeAnyMatch(predicate), HAS_ERROR_MSG_1, new Object[]{theMessage});
        Assertions.assertThat(((LogbackTestExtension)this.actual).getLogEvents()).has(condition);
        return this;
    }

    public LogbackTestExtensionAssert doesNotHaveMessage(@Nonnull String theMessage) {
        this.isNotNull();
        Predicate<ILoggingEvent> predicate = LoggingEventPredicates.makeMessageContains(theMessage);
        Condition condition = new Condition(LoggingEventPredicates.makeAnyMatch(predicate), HAS_ERROR_MSG_1, new Object[]{theMessage});
        Assertions.assertThat(((LogbackTestExtension)this.actual).getLogEvents()).doesNotHave(condition);
        return this;
    }

    @Nonnull
    public LogbackTestExtensionAssert hasErrorMessage(@Nonnull String theMessage) {
        this.isNotNull();
        Predicate<ILoggingEvent> predicate = LoggingEventPredicates.makeLevelEquals(Level.ERROR).and(LoggingEventPredicates.makeMessageContains(theMessage));
        Condition condition = new Condition(LoggingEventPredicates.makeAnyMatch(predicate), HAS_ERROR_MSG_2, new Object[]{Level.ERROR, theMessage});
        Assertions.assertThat(((LogbackTestExtension)this.actual).getLogEvents()).has(condition);
        return this;
    }

    @Nonnull
    public LogbackTestExtensionAssert hasInfoMessage(@Nonnull String theMessage) {
        this.isNotNull();
        Predicate<ILoggingEvent> predicate = LoggingEventPredicates.makeLevelEquals(Level.INFO).and(LoggingEventPredicates.makeMessageContains(theMessage));
        Condition condition = new Condition(LoggingEventPredicates.makeAnyMatch(predicate), HAS_ERROR_MSG_2, new Object[]{Level.INFO, theMessage});
        Assertions.assertThat(((LogbackTestExtension)this.actual).getLogEvents()).has(condition);
        return this;
    }

    @Nonnull
    public LogbackTestExtensionAssert doesNotHaveInfoMessage(@Nonnull String theMessage) {
        this.isNotNull();
        Predicate<ILoggingEvent> predicate = LoggingEventPredicates.makeLevelEquals(Level.INFO).and(LoggingEventPredicates.makeMessageContains(theMessage));
        Condition condition = new Condition(LoggingEventPredicates.makeAnyMatch(predicate), HAS_ERROR_MSG_2, new Object[]{Level.INFO, theMessage});
        Assertions.assertThat(((LogbackTestExtension)this.actual).getLogEvents()).doesNotHave(condition);
        return this;
    }

    @Nonnull
    public LogbackTestExtensionAssert hasWarnMessage(@Nonnull String theMessage) {
        this.isNotNull();
        Predicate<ILoggingEvent> predicate = LoggingEventPredicates.makeLevelEquals(Level.WARN).and(LoggingEventPredicates.makeMessageContains(theMessage));
        Condition condition = new Condition(LoggingEventPredicates.makeAnyMatch(predicate), HAS_ERROR_MSG_2, new Object[]{Level.WARN, theMessage});
        Assertions.assertThat(((LogbackTestExtension)this.actual).getLogEvents()).has(condition);
        return this;
    }

    @Nonnull
    public LogbackTestExtensionAssert hasDebugMessage(@Nonnull String theMessage) {
        this.isNotNull();
        Predicate<ILoggingEvent> predicate = LoggingEventPredicates.makeLevelEquals(Level.DEBUG).and(LoggingEventPredicates.makeMessageContains(theMessage));
        Condition condition = new Condition(LoggingEventPredicates.makeAnyMatch(predicate), HAS_ERROR_MSG_2, new Object[]{Level.DEBUG, theMessage});
        Assertions.assertThat(((LogbackTestExtension)this.actual).getLogEvents()).has(condition);
        return this;
    }

    @Nonnull
    public LogbackTestExtensionAssert anyMatch(@Nonnull Predicate<ILoggingEvent> thePredicate) {
        this.isNotNull();
        Assertions.assertThat(((LogbackTestExtension)this.actual).getLogEvents()).anyMatch(thePredicate);
        return this;
    }

    @Nonnull
    public LogbackTestExtensionAssert isEmpty() {
        Assertions.assertThat(((LogbackTestExtension)this.actual).getLogEvents()).isEmpty();
        return this;
    }

    @Nonnull
    public LogbackTestExtensionAssert isNotEmpty() {
        this.isNotNull();
        Assertions.assertThat(((LogbackTestExtension)this.actual).getLogEvents()).isNotEmpty();
        return this;
    }

    @Nonnull
    public LogbackTestExtensionAssert hasSize(int theExpected) {
        this.isNotNull();
        Assertions.assertThat(((LogbackTestExtension)this.actual).getLogEvents()).hasSize(theExpected);
        return this;
    }
}

