/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.test.util;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.function.Predicate;

public final class LoggingEventPredicates {
    private LoggingEventPredicates() {
    }

    @Nonnull
    public static Predicate<ILoggingEvent> makeLevelEquals(@Nonnull Level theLevel) {
        return loggingEvent -> loggingEvent.getLevel().equals(theLevel);
    }

    @Nonnull
    public static Predicate<ILoggingEvent> makeMessageEquals(@Nonnull String theMessage) {
        return loggingEvent -> loggingEvent.getFormattedMessage().equals(theMessage);
    }

    @Nonnull
    public static Predicate<ILoggingEvent> makeMessageContains(@Nonnull String theMessage) {
        return loggingEvent -> loggingEvent.getFormattedMessage().contains(theMessage);
    }

    @Nonnull
    public static Predicate<ILoggingEvent> makeExceptionMessageContains(@Nonnull String theExceptionMessage) {
        return loggingEvent -> loggingEvent.getThrowableProxy().getMessage().contains(theExceptionMessage);
    }

    @Nonnull
    public static Predicate<List<? extends ILoggingEvent>> makeAnyMatch(@Nonnull Predicate<ILoggingEvent> thePredicate) {
        return loggingEvents -> loggingEvents.stream().anyMatch(thePredicate);
    }
}

