/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.to.model;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.client.api.ServerValidationModeEnum;
import ca.uhn.fhir.rest.client.impl.GenericClient;
import ca.uhn.fhir.rest.server.IncomingRequestAddressStrategy;
import ca.uhn.fhir.rest.server.util.ITestingUiClientFactory;
import ca.uhn.fhir.to.BaseController;
import ca.uhn.fhir.to.TesterConfig;
import ca.uhn.fhir.to.model.BufferResponseInterceptor;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.MDC;
import org.springframework.web.bind.annotation.ModelAttribute;

public class HomeRequest {
    private String myEncoding;
    private String myPretty;
    private String myResource;
    private String myServerId;
    private String mySummary;

    @ModelAttribute(value="encoding")
    public String getEncoding() {
        return this.myEncoding;
    }

    @ModelAttribute(value="encoding")
    public String getPretty() {
        return this.myPretty;
    }

    @ModelAttribute(value="_summary")
    public String get_summary() {
        return this.mySummary;
    }

    @ModelAttribute(value="resource")
    public String getResource() {
        return this.myResource;
    }

    public String getServerBase(HttpServletRequest theRequest, TesterConfig theConfig) {
        String retVal = StringUtils.isBlank((CharSequence)this.myServerId) && !theConfig.getIdToServerBase().containsKey(this.myServerId) ? (String)theConfig.getIdToServerBase().entrySet().iterator().next().getValue() : (String)theConfig.getIdToServerBase().get(this.myServerId);
        if (retVal.contains("${serverBase}")) {
            IncomingRequestAddressStrategy strategy = new IncomingRequestAddressStrategy();
            strategy.setServletPath("");
            String base = strategy.determineServerBase(theRequest.getServletContext(), theRequest);
            if (base.endsWith("/")) {
                base = base.substring(0, base.length() - 1);
            }
            if (base.endsWith("/resource")) {
                base = base.substring(0, base.length() - "/resource".length());
            }
            retVal = retVal.replace("${serverBase}", base);
        }
        return retVal;
    }

    @ModelAttribute(value="serverId")
    public String getServerId() {
        return this.myServerId;
    }

    public String getServerIdWithDefault(TesterConfig theConfig) {
        String retVal = this.myServerId;
        if (StringUtils.isBlank((CharSequence)retVal)) {
            retVal = (String)theConfig.getIdToServerBase().keySet().iterator().next();
        }
        return retVal;
    }

    public FhirVersionEnum getFhirVersion(TesterConfig theConfig) {
        if (StringUtils.isBlank((CharSequence)this.myServerId) && !theConfig.getIdToFhirVersion().containsKey(this.myServerId)) {
            return (FhirVersionEnum)theConfig.getIdToFhirVersion().entrySet().iterator().next().getValue();
        }
        return (FhirVersionEnum)theConfig.getIdToFhirVersion().get(this.myServerId);
    }

    public String getServerName(TesterConfig theConfig) {
        if (StringUtils.isBlank((CharSequence)this.myServerId) && !theConfig.getIdToServerName().containsKey(this.myServerId)) {
            return (String)theConfig.getIdToServerName().entrySet().iterator().next().getValue();
        }
        return (String)theConfig.getIdToServerName().get(this.myServerId);
    }

    public void setEncoding(String theEncoding) {
        this.myEncoding = theEncoding;
    }

    public void setPretty(String thePretty) {
        this.myPretty = thePretty;
    }

    public void set_summary(String theSummary) {
        this.mySummary = theSummary;
    }

    public void setResource(String theResource) {
        this.myResource = theResource;
    }

    public void setServerId(String theServerId) {
        this.myServerId = theServerId;
    }

    public GenericClient newClient(HttpServletRequest theRequest, FhirContext theContext, TesterConfig theConfig, @Nullable BaseController.CaptureInterceptor theInterceptor) {
        SummaryEnum summary;
        theContext.getRestfulClientFactory().setServerValidationMode(ServerValidationModeEnum.NEVER);
        theContext.getRestfulClientFactory().setConnectTimeout(60000);
        theContext.getRestfulClientFactory().setConnectionRequestTimeout(60000);
        theContext.getRestfulClientFactory().setSocketTimeout(60000);
        ITestingUiClientFactory clientFactory = theConfig.getClientFactory();
        GenericClient retVal = clientFactory != null ? (GenericClient)clientFactory.newClient(theContext, theRequest, this.getServerBase(theRequest, theConfig)) : (GenericClient)theContext.newRestfulGenericClient(this.getServerBase(theRequest, theConfig));
        retVal.registerInterceptor((Object)new BufferResponseInterceptor());
        retVal.setKeepResponses(true);
        if ("true".equals(this.getPretty())) {
            retVal.setPrettyPrint(Boolean.valueOf(true));
        } else if ("false".equals(this.getPretty())) {
            retVal.setPrettyPrint(Boolean.valueOf(false));
        }
        if ("xml".equals(this.getEncoding())) {
            retVal.setEncoding(EncodingEnum.XML);
        } else if ("json".equals(this.getEncoding())) {
            retVal.setEncoding(EncodingEnum.JSON);
        }
        if (StringUtils.isNotBlank((CharSequence)this.get_summary()) && (summary = SummaryEnum.fromCode((String)this.get_summary())) != null) {
            retVal.setSummary(summary);
        }
        if (theInterceptor != null) {
            retVal.registerInterceptor((Object)theInterceptor);
        }
        String remoteAddr = MDC.get((String)"req.remoteAddr");
        retVal.registerInterceptor((Object)new /* Unavailable Anonymous Inner Class!! */);
        return retVal;
    }

    public IParser newParser(FhirContext theCtx) {
        if ("json".equals(this.getEncoding())) {
            return theCtx.newJsonParser();
        }
        return theCtx.newXmlParser();
    }

    public String getApiKey(HttpServletRequest theServletRequest, TesterConfig theConfig) {
        Boolean allowsApiKey = StringUtils.isBlank((CharSequence)this.myServerId) && !theConfig.getIdToFhirVersion().containsKey(this.myServerId) ? (Boolean)theConfig.getIdToAllowsApiKey().entrySet().iterator().next().getValue() : (Boolean)theConfig.getIdToAllowsApiKey().get(this.myServerId);
        if (!Boolean.TRUE.equals(allowsApiKey)) {
            return null;
        }
        return StringUtils.defaultString((String)theServletRequest.getParameter("apiKey"));
    }
}

