/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.to;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.fql.executor.HfqlDataTypeEnum;
import ca.uhn.fhir.jpa.fql.executor.IHfqlExecutionResult;
import ca.uhn.fhir.jpa.fql.jdbc.HfqlRestClient;
import ca.uhn.fhir.jpa.fql.jdbc.RemoteHfqlExecutionResult;
import ca.uhn.fhir.jpa.fql.parser.HfqlStatement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.dstu2.resource.Conformance;
import ca.uhn.fhir.model.dstu2.valueset.SearchParamTypeEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.client.impl.GenericClient;
import ca.uhn.fhir.rest.gclient.ICreateTyped;
import ca.uhn.fhir.rest.gclient.IHistory;
import ca.uhn.fhir.rest.gclient.IHistoryTyped;
import ca.uhn.fhir.rest.gclient.IHistoryUntyped;
import ca.uhn.fhir.rest.gclient.IOperationUnnamed;
import ca.uhn.fhir.rest.gclient.IParam;
import ca.uhn.fhir.rest.gclient.IQuery;
import ca.uhn.fhir.rest.gclient.IUntypedQuery;
import ca.uhn.fhir.rest.gclient.IValidateUntyped;
import ca.uhn.fhir.rest.gclient.NumberClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.to.BaseController;
import ca.uhn.fhir.to.model.HomeRequest;
import ca.uhn.fhir.to.model.ResourceRequest;
import ca.uhn.fhir.to.model.TransactionRequest;
import ca.uhn.fhir.to.util.HfqlRenderingUtil;
import ca.uhn.fhir.util.StopWatch;
import ca.uhn.fhir.util.UrlUtil;
import com.google.gson.stream.JsonWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.dstu3.model.CapabilityStatement;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.CapabilityStatement;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.Enumerations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@org.springframework.stereotype.Controller
public class Controller
extends BaseController {
    static final Logger ourLog = LoggerFactory.getLogger(Controller.class);
    public static final int ROW_LIMIT = 200;

    @RequestMapping(value={"/about"})
    public String actionAbout(HttpServletRequest theServletRequest, HomeRequest theRequest, ModelMap theModel) {
        this.addCommonParams(theServletRequest, theRequest, theModel);
        theModel.put((Object)"notHome", (Object)true);
        theModel.put((Object)"extraBreadcrumb", (Object)"About");
        ourLog.info(this.logPrefix(theModel) + "Displayed about page");
        return "about";
    }

    @RequestMapping(value={"/conformance"})
    public String actionConformance(HttpServletRequest theServletRequest, HomeRequest theRequest, BindingResult theBindingResult, ModelMap theModel) {
        this.addCommonParams(theServletRequest, theRequest, theModel);
        BaseController.CaptureInterceptor interceptor = new BaseController.CaptureInterceptor();
        FhirContext context = this.getContext(theRequest);
        GenericClient client = theRequest.newClient(theServletRequest, context, this.myConfig, interceptor);
        BaseController.ResultType returnsResource = BaseController.ResultType.RESOURCE;
        long start = System.currentTimeMillis();
        try {
            String name = "CapabilityStatement";
            if (context.getVersion().getVersion().isOlderThan(FhirVersionEnum.DSTU3)) {
                name = "Conformance";
            }
            Class type = context.getResourceDefinition(name).getImplementingClass();
            client.fetchConformance().ofType(type).execute();
        }
        catch (Exception e) {
            returnsResource = this.handleClientException(client, e, theModel);
        }
        long delay = System.currentTimeMillis() - start;
        this.processAndAddLastClientInvocation(client, returnsResource, theModel, delay, "Loaded conformance", interceptor, theRequest);
        ourLog.info(this.logPrefix(theModel) + "Displayed conformance profile");
        return "result";
    }

    @RequestMapping(value={"/create"})
    public String actionCreate(HttpServletRequest theReq, HomeRequest theRequest, BindingResult theBindingResult, ModelMap theModel) {
        this.doActionCreateOrValidate(theReq, theRequest, theBindingResult, theModel, "create");
        return "result";
    }

    @RequestMapping(value={"/delete"})
    public String actionDelete(HttpServletRequest theServletRequest, HomeRequest theRequest, BindingResult theBindingResult, ModelMap theModel) {
        RuntimeResourceDefinition def;
        this.addCommonParams(theServletRequest, theRequest, theModel);
        BaseController.CaptureInterceptor interceptor = new BaseController.CaptureInterceptor();
        GenericClient client = theRequest.newClient(theServletRequest, this.getContext(theRequest), this.myConfig, interceptor);
        try {
            def = this.getResourceType(theRequest, theServletRequest);
        }
        catch (ServletException e) {
            this.populateModelForResource(theServletRequest, theRequest, theModel);
            theModel.put((Object)"errorMsg", (Object)this.toDisplayError(e.toString(), (Exception)((Object)e)));
            return "resource";
        }
        String id = UrlUtil.sanitizeUrlPart((CharSequence)StringUtils.defaultString((String)theServletRequest.getParameter("resource-delete-id")));
        if (StringUtils.isBlank((CharSequence)id)) {
            this.populateModelForResource(theServletRequest, theRequest, theModel);
            theModel.put((Object)"errorMsg", (Object)this.toDisplayError("No ID specified", null));
            return "resource";
        }
        BaseController.ResultType returnsResource = BaseController.ResultType.RESOURCE;
        String outcomeDescription = "Delete Resource";
        long start = System.currentTimeMillis();
        try {
            IdDt resourceId = new IdDt(id);
            if (!resourceId.hasResourceType()) {
                resourceId = resourceId.withResourceType(def.getName());
            }
            client.delete().resourceById((IIdType)resourceId).execute();
        }
        catch (Exception e) {
            returnsResource = this.handleClientException(client, e, theModel);
        }
        long delay = System.currentTimeMillis() - start;
        this.processAndAddLastClientInvocation(client, returnsResource, theModel, delay, outcomeDescription, interceptor, theRequest);
        ourLog.info(this.logPrefix(theModel) + "Deleted resource of type " + def.getName());
        return "result";
    }

    @RequestMapping(value={"/history-server"})
    public String actionHistoryServer(HttpServletRequest theReq, HomeRequest theRequest, BindingResult theBindingResult, ModelMap theModel) {
        this.doActionHistory(theReq, theRequest, theBindingResult, theModel, "history-server", "Server History");
        return "result";
    }

    @RequestMapping(value={"/history-type"})
    public String actionHistoryType(HttpServletRequest theReq, HomeRequest theRequest, BindingResult theBindingResult, ModelMap theModel) {
        this.doActionHistory(theReq, theRequest, theBindingResult, theModel, "history-type", "History");
        return "result";
    }

    @RequestMapping(value={"/", "/home"})
    public String actionHome(HttpServletRequest theServletRequest, HomeRequest theRequest, BindingResult theBindingResult, ModelMap theModel) {
        this.addCommonParams(theServletRequest, theRequest, theModel);
        theModel.put((Object)"page", (Object)"home");
        return "home";
    }

    @RequestMapping(value={"/page"})
    public String actionPage(HttpServletRequest theReq, HomeRequest theRequest, BindingResult theBindingResult, ModelMap theModel) {
        this.addCommonParams(theReq, theRequest, theModel);
        BaseController.CaptureInterceptor interceptor = new BaseController.CaptureInterceptor();
        FhirContext context = this.getContext(theRequest);
        GenericClient client = theRequest.newClient(theReq, context, this.myConfig, interceptor);
        String url = UrlUtil.sanitizeUrlPart((CharSequence)StringUtils.defaultString((String)theReq.getParameter("page-url")));
        if (this.myConfig.isRefuseToFetchThirdPartyUrls() && !url.startsWith(theModel.get((Object)"base").toString())) {
            ourLog.warn(this.logPrefix(theModel) + "Refusing to load page URL: {}", (Object)url);
            theModel.put((Object)"errorMsg", (Object)this.toDisplayError("Invalid page URL: " + url, null));
            return "result";
        }
        url = url.replace("&amp;", "&");
        BaseController.ResultType returnsResource = BaseController.ResultType.BUNDLE;
        long start = System.currentTimeMillis();
        try {
            ourLog.info(this.logPrefix(theModel) + "Loading paging URL: {}", (Object)url);
            Class bundleType = context.getResourceDefinition("Bundle").getImplementingClass();
            client.loadPage().byUrl(url).andReturnBundle(bundleType).execute();
        }
        catch (Exception e) {
            returnsResource = this.handleClientException(client, e, theModel);
        }
        long delay = System.currentTimeMillis() - start;
        String outcomeDescription = "Bundle Page";
        this.processAndAddLastClientInvocation(client, returnsResource, theModel, delay, outcomeDescription, interceptor, theRequest);
        return "result";
    }

    @RequestMapping(value={"/read"})
    public String actionRead(HttpServletRequest theServletRequest, HomeRequest theRequest, BindingResult theBindingResult, ModelMap theModel) {
        String outcomeDescription;
        RuntimeResourceDefinition def;
        this.addCommonParams(theServletRequest, theRequest, theModel);
        BaseController.CaptureInterceptor interceptor = new BaseController.CaptureInterceptor();
        GenericClient client = theRequest.newClient(theServletRequest, this.getContext(theRequest), this.myConfig, interceptor);
        try {
            def = this.getResourceType(theRequest, theServletRequest);
        }
        catch (ServletException e) {
            this.populateModelForResource(theServletRequest, theRequest, theModel);
            theModel.put((Object)"errorMsg", (Object)this.toDisplayError(e.toString(), (Exception)((Object)e)));
            return "resource";
        }
        String id = UrlUtil.sanitizeUrlPart((CharSequence)UrlUtil.unescape((String)theServletRequest.getParameter("id")));
        if (StringUtils.isBlank((CharSequence)id)) {
            this.populateModelForResource(theServletRequest, theRequest, theModel);
            theModel.put((Object)"errorMsg", (Object)this.toDisplayError("No ID specified", null));
            return "resource";
        }
        BaseController.ResultType returnsResource = BaseController.ResultType.RESOURCE;
        String versionId = UrlUtil.sanitizeUrlPart((CharSequence)UrlUtil.unescape((String)theServletRequest.getParameter("vid")));
        if (StringUtils.isBlank((CharSequence)versionId)) {
            versionId = null;
            outcomeDescription = "Read Resource";
        } else {
            outcomeDescription = "VRead Resource";
        }
        long start = System.currentTimeMillis();
        try {
            IdDt resid = new IdDt(def.getName(), id, versionId);
            ourLog.info(this.logPrefix(theModel) + "Reading resource: {}", (Object)resid);
            if (resid.hasVersionIdPart()) {
                client.vread(def.getImplementingClass(), resid);
            } else {
                client.read(def.getImplementingClass(), (UriDt)resid);
            }
        }
        catch (Exception e) {
            returnsResource = this.handleClientException(client, e, theModel);
        }
        long delay = System.currentTimeMillis() - start;
        this.processAndAddLastClientInvocation(client, returnsResource, theModel, delay, outcomeDescription, interceptor, theRequest);
        return "result";
    }

    @RequestMapping(value={"/resource"})
    public String actionResource(HttpServletRequest theServletRequest, ResourceRequest theRequest, BindingResult theBindingResult, ModelMap theModel) {
        String resourceName = theRequest.getResource();
        this.populateModelForResource(theServletRequest, theRequest, theModel);
        if (StringUtils.isNotBlank((CharSequence)theRequest.getUpdateId())) {
            String updateId = theRequest.getUpdateId();
            String updateVid = (String)StringUtils.defaultIfEmpty((CharSequence)theRequest.getUpdateVid(), null);
            BaseController.CaptureInterceptor interceptor = new BaseController.CaptureInterceptor();
            GenericClient client = theRequest.newClient(theServletRequest, this.getContext(theRequest), this.myConfig, interceptor);
            RuntimeResourceDefinition def = this.getContext(theRequest).getResourceDefinition(theRequest.getResource());
            IBaseResource updateResource = client.read(def.getImplementingClass(), (UriDt)new IdDt(resourceName, updateId, updateVid));
            String updateResourceString = theRequest.newParser(this.getContext(theRequest)).setPrettyPrint(true).encodeResourceToString(updateResource);
            theModel.put((Object)"updateResource", (Object)updateResourceString);
            theModel.put((Object)"updateResourceId", (Object)updateId);
        }
        ourLog.info(this.logPrefix(theModel) + "Showing resource page: {}", (Object)resourceName);
        return "resource";
    }

    @RequestMapping(value={"/hfql"}, method={RequestMethod.GET})
    public String actionHfqlHome(HttpServletRequest theServletRequest, @RequestParam(value="hfql-query", required=false) String theHfqlQuery, HomeRequest theRequest, BindingResult theBindingResult, ModelMap theModel) {
        this.addCommonParamsForHfql(theServletRequest, theRequest, theModel);
        String query = theHfqlQuery;
        if (StringUtils.isBlank((CharSequence)query)) {
            query = "SELECT\n   id AS ID, meta.versionId AS Version,\n   name[0].family AS FamilyName, name[0].given[0] AS GivenName,\n   identifier AS Identifiers\nFROM\n   Patient";
        }
        theModel.put((Object)"query", (Object)query);
        return "hfql";
    }

    @RequestMapping(value={"/hfql"}, method={RequestMethod.POST})
    public String actionHfqlExecuteQuery(HttpServletRequest theServletRequest, @RequestParam(value="hfql-query") String theHfqlQuery, HomeRequest theRequest, BindingResult theBindingResult, ModelMap theModel) {
        this.addCommonParamsForHfql(theServletRequest, theRequest, theModel);
        ourLog.info("Executing HFQL query: {}", (Object)theHfqlQuery.replaceAll("\\s+", " "));
        StopWatch sw = new StopWatch();
        List<Object> rows = new ArrayList();
        try {
            IHfqlExecutionResult result = this.executeHfqlStatement(theServletRequest, theHfqlQuery, theRequest, 200);
            while (result.hasNext()) {
                List nextRowValues = result.getNextRow().getRowValues();
                if (nextRowValues.size() < 1) continue;
                List nextRow = nextRowValues.stream().map(t -> t != null ? t.toString() : null).collect(Collectors.toList());
                rows.add(nextRow);
            }
            List columnNames = result.getStatement().getSelectClauses().stream().map(HfqlStatement.SelectClause::getAlias).collect(Collectors.toList());
            theModel.put((Object)"columnNames", columnNames);
            List columnTypes = result.getStatement().getSelectClauses().stream().map(t -> t.getDataType().name()).collect(Collectors.toList());
            theModel.put((Object)"columnTypes", columnTypes);
        }
        catch (IOException e) {
            ourLog.warn("Failed to execute HFQL query: {}", (Object)e.toString());
            theModel.put((Object)"columnNames", List.of("Error"));
            theModel.put((Object)"columnTypes", List.of(HfqlDataTypeEnum.STRING));
            rows = List.of(List.of(e.getMessage()));
        }
        theModel.put((Object)"HfqlRenderingUtil", (Object)new HfqlRenderingUtil());
        theModel.put((Object)"query", (Object)theHfqlQuery);
        theModel.put((Object)"resultRows", rows);
        theModel.put((Object)"executionTime", (Object)sw.toString());
        return "hfql";
    }

    @Nonnull
    protected IHfqlExecutionResult executeHfqlStatement(HttpServletRequest theServletRequest, String theHfqlQuery, HomeRequest theRequest, int theRowLimit) throws IOException {
        Parameters requestParameters = HfqlRestClient.newQueryRequestParameters((String)theHfqlQuery, (Integer)theRowLimit, (int)theRowLimit);
        GenericClient client = theRequest.newClient(theServletRequest, this.getContext(theRequest), this.myConfig, null);
        return new RemoteHfqlExecutionResult(requestParameters, (IGenericClient)client);
    }

    protected CapabilityStatement addCommonParamsForHfql(HttpServletRequest theServletRequest, HomeRequest theRequest, ModelMap theModel) {
        theModel.put((Object)"page", (Object)"hfql");
        theModel.put((Object)"rowLimit", (Object)200);
        return super.addCommonParams(theServletRequest, theRequest, theModel);
    }

    private void populateModelForResource(HttpServletRequest theServletRequest, HomeRequest theRequest, ModelMap theModel) {
        CapabilityStatement conformance = this.addCommonParams(theServletRequest, theRequest, theModel);
        String resourceName = theRequest.getResource();
        TreeSet<String> includes = new TreeSet<String>();
        TreeSet<String> revIncludes = new TreeSet<String>();
        TreeSet<String> sortParams = new TreeSet<String>();
        boolean haveSearchParams = false;
        ArrayList<List<String>> queryIncludes = new ArrayList<List<String>>();
        haveSearchParams = this.extractSearchParamsR5CapabilityStatement((IBaseResource)conformance, resourceName, includes, revIncludes, sortParams, haveSearchParams, queryIncludes);
        theModel.put((Object)"includes", includes);
        theModel.put((Object)"revincludes", revIncludes);
        theModel.put((Object)"queries", Collections.emptyList());
        theModel.put((Object)"haveSearchParams", (Object)haveSearchParams);
        theModel.put((Object)"queryIncludes", queryIncludes);
        theModel.put((Object)"sortParams", sortParams);
    }

    @RequestMapping(value={"/search"})
    public String actionSearch(HttpServletRequest theServletRequest, HomeRequest theRequest, BindingResult theBindingResult, ModelMap theModel) throws IOException {
        BaseController.ResultType returnsResource;
        String paramIdxString;
        boolean shouldContinue;
        IQuery query;
        this.addCommonParams(theServletRequest, theRequest, theModel);
        StringWriter clientCodeJsonStringWriter = new StringWriter();
        JsonWriter clientCodeJsonWriter = new JsonWriter((Writer)clientCodeJsonStringWriter);
        clientCodeJsonWriter.beginObject();
        clientCodeJsonWriter.name("action");
        clientCodeJsonWriter.value("search");
        clientCodeJsonWriter.name("base");
        clientCodeJsonWriter.value((String)theModel.get((Object)"base"));
        BaseController.CaptureInterceptor interceptor = new BaseController.CaptureInterceptor();
        GenericClient client = theRequest.newClient(theServletRequest, this.getContext(theRequest), this.myConfig, interceptor);
        IUntypedQuery search = client.search();
        if (StringUtils.isNotBlank((CharSequence)theServletRequest.getParameter("resource"))) {
            try {
                query = search.forResource(this.getResourceType(theRequest, theServletRequest).getImplementingClass());
            }
            catch (ServletException e) {
                this.populateModelForResource(theServletRequest, theRequest, theModel);
                theModel.put((Object)"errorMsg", (Object)this.toDisplayError(e.toString(), (Exception)((Object)e)));
                return "resource";
            }
            clientCodeJsonWriter.name("resource");
            clientCodeJsonWriter.value(UrlUtil.sanitizeUrlPart((CharSequence)theServletRequest.getParameter("resource")));
        } else {
            query = search.forAllResources();
            clientCodeJsonWriter.name("resource");
            clientCodeJsonWriter.nullValue();
        }
        if (client.isPrettyPrint()) {
            clientCodeJsonWriter.name("pretty");
            clientCodeJsonWriter.value("true");
        } else {
            clientCodeJsonWriter.name("pretty");
            clientCodeJsonWriter.nullValue();
        }
        if (client.getEncoding() != null) {
            clientCodeJsonWriter.name("format");
            clientCodeJsonWriter.value(client.getEncoding().getFormatContentType());
        } else {
            clientCodeJsonWriter.name("format");
            clientCodeJsonWriter.nullValue();
        }
        String outcomeDescription = "Search for Resources";
        clientCodeJsonWriter.name("params");
        clientCodeJsonWriter.beginArray();
        int paramIdx = -1;
        while (shouldContinue = this.handleSearchParam(paramIdxString = Integer.toString(++paramIdx), theServletRequest, query, clientCodeJsonWriter)) {
        }
        clientCodeJsonWriter.endArray();
        clientCodeJsonWriter.name("includes");
        clientCodeJsonWriter.beginArray();
        String[] incValues = UrlUtil.sanitizeUrlPart((String[])theServletRequest.getParameterValues("_include"));
        if (incValues != null) {
            for (String next : incValues) {
                if (!StringUtils.isNotBlank((CharSequence)next)) continue;
                query.include(new Include(next));
                clientCodeJsonWriter.value(next);
            }
        }
        clientCodeJsonWriter.endArray();
        clientCodeJsonWriter.name("revincludes");
        clientCodeJsonWriter.beginArray();
        String[] revIncValues = UrlUtil.sanitizeUrlPart((String[])theServletRequest.getParameterValues("_revinclude"));
        if (revIncValues != null) {
            for (String next : revIncValues) {
                if (!StringUtils.isNotBlank((CharSequence)next)) continue;
                query.revInclude(new Include(next));
                clientCodeJsonWriter.value(next);
            }
        }
        clientCodeJsonWriter.endArray();
        String limit = UrlUtil.sanitizeUrlPart((CharSequence)theServletRequest.getParameter("resource-search-limit"));
        if (StringUtils.isNotBlank((CharSequence)limit)) {
            if (!limit.matches("[0-9]+")) {
                this.populateModelForResource(theServletRequest, theRequest, theModel);
                theModel.put((Object)"errorMsg", (Object)this.toDisplayError("Search limit must be a numeric value.", null));
                return "resource";
            }
            int limitInt = Integer.parseInt(limit);
            query.count(limitInt);
            clientCodeJsonWriter.name("limit");
            clientCodeJsonWriter.value(limit);
        } else {
            clientCodeJsonWriter.name("limit");
            clientCodeJsonWriter.nullValue();
        }
        String[] sort = UrlUtil.sanitizeUrlPart((String[])theServletRequest.getParameterValues("sort_by"));
        if (sort != null) {
            for (String next : sort) {
                if (StringUtils.isBlank((CharSequence)next)) continue;
                String direction = UrlUtil.sanitizeUrlPart((CharSequence)theServletRequest.getParameter("sort_direction"));
                if ("asc".equals(direction)) {
                    query.sort().ascending((IParam)new StringClientParam(next));
                    continue;
                }
                if ("desc".equals(direction)) {
                    query.sort().descending((IParam)new StringClientParam(next));
                    continue;
                }
                query.sort().defaultOrder((IParam)new StringClientParam(next));
            }
        }
        Class bundleType = client.getFhirContext().getResourceDefinition("Bundle").getImplementingClass();
        IQuery queryTyped = query.returnBundle(bundleType);
        long start = System.currentTimeMillis();
        try {
            ourLog.info(this.logPrefix(theModel) + "Executing a search");
            queryTyped.execute();
            returnsResource = BaseController.ResultType.BUNDLE;
        }
        catch (Exception e) {
            returnsResource = this.handleClientException(client, e, theModel);
        }
        long delay = System.currentTimeMillis() - start;
        this.processAndAddLastClientInvocation(client, returnsResource, theModel, delay, outcomeDescription, interceptor, theRequest);
        clientCodeJsonWriter.endObject();
        clientCodeJsonWriter.close();
        String clientCodeJson = clientCodeJsonStringWriter.toString();
        theModel.put((Object)"clientCodeJson", (Object)clientCodeJson);
        return "result";
    }

    @RequestMapping(value={"/transaction"})
    public String actionTransaction(HttpServletRequest theServletRequest, TransactionRequest theRequest, BindingResult theBindingResult, ModelMap theModel) {
        this.addCommonParams(theServletRequest, theRequest, theModel);
        BaseController.CaptureInterceptor interceptor = new BaseController.CaptureInterceptor();
        FhirContext context = this.getContext(theRequest);
        GenericClient client = theRequest.newClient(theServletRequest, context, this.myConfig, interceptor);
        String body = this.preProcessMessageBody(theRequest.getTransactionBody());
        try {
            if (!body.startsWith("{") && !body.startsWith("<")) {
                theModel.put((Object)"errorMsg", (Object)this.toDisplayError("Message body does not appear to be a valid FHIR resource instance document. Body should start with '<' (for XML encoding) or '{' (for JSON encoding).", null));
                return "home";
            }
        }
        catch (DataFormatException e) {
            ourLog.warn("Failed to parse bundle", (Throwable)e);
            theModel.put((Object)"errorMsg", (Object)this.toDisplayError("Failed to parse transaction bundle body. Error was: " + e.getMessage(), (Exception)((Object)e)));
            return "home";
        }
        BaseController.ResultType returnsResource = BaseController.ResultType.BUNDLE;
        long start = System.currentTimeMillis();
        try {
            ourLog.info(this.logPrefix(theModel) + "Executing transaction");
            client.transaction().withBundle(body).execute();
        }
        catch (Exception e) {
            returnsResource = this.handleClientException(client, e, theModel);
        }
        long delay = System.currentTimeMillis() - start;
        this.processAndAddLastClientInvocation(client, returnsResource, theModel, delay, "Transaction", interceptor, theRequest);
        return "result";
    }

    @RequestMapping(value={"/update"})
    public String actionUpdate(HttpServletRequest theReq, HomeRequest theRequest, BindingResult theBindingResult, ModelMap theModel) {
        this.doActionCreateOrValidate(theReq, theRequest, theBindingResult, theModel, "update");
        return "result";
    }

    @RequestMapping(value={"/validate"})
    public String actionValidate(HttpServletRequest theReq, HomeRequest theRequest, BindingResult theBindingResult, ModelMap theModel) {
        this.doActionCreateOrValidate(theReq, theRequest, theBindingResult, theModel, "validate");
        return "result";
    }

    private void doActionCreateOrValidate(HttpServletRequest theReq, HomeRequest theRequest, BindingResult theBindingResult, ModelMap theModel, String theMethod) {
        IBaseResource resource;
        String body;
        GenericClient client;
        BaseController.CaptureInterceptor interceptor;
        boolean validate;
        block18: {
            validate = "validate".equals(theMethod);
            this.addCommonParams(theReq, theRequest, theModel);
            interceptor = new BaseController.CaptureInterceptor();
            client = theRequest.newClient(theReq, this.getContext(theRequest), this.myConfig, interceptor);
            client.setPrettyPrint(Boolean.valueOf(true));
            Class type = null;
            if ("history-type".equals(theMethod)) {
                RuntimeResourceDefinition def = this.getContext(theRequest).getResourceDefinition(theRequest.getResource());
                type = def.getImplementingClass();
            }
            String string = body = validate ? theReq.getParameter("resource-validate-body") : theReq.getParameter("resource-create-body");
            if (StringUtils.isBlank((CharSequence)body)) {
                theModel.put((Object)"errorMsg", (Object)this.toDisplayError("No message body specified", null));
                return;
            }
            body = this.preProcessMessageBody(body);
            try {
                if (body.startsWith("{")) {
                    resource = this.getContext(theRequest).newJsonParser().parseResource(type, body);
                    client.setEncoding(EncodingEnum.JSON);
                    break block18;
                }
                if (body.startsWith("<")) {
                    resource = this.getContext(theRequest).newXmlParser().parseResource(type, body);
                    client.setEncoding(EncodingEnum.XML);
                    break block18;
                }
                theModel.put((Object)"errorMsg", (Object)this.toDisplayError("Message body does not appear to be a valid FHIR resource instance document. Body should start with '<' (for XML encoding) or '{' (for JSON encoding).", null));
                return;
            }
            catch (DataFormatException e) {
                ourLog.warn("Failed to parse resource", (Throwable)e);
                theModel.put((Object)"errorMsg", (Object)this.toDisplayError("Failed to parse message body. Error was: " + e.getMessage(), (Exception)((Object)e)));
                return;
            }
        }
        long start = System.currentTimeMillis();
        BaseController.ResultType returnsResource = BaseController.ResultType.RESOURCE;
        String outcomeDescription = "";
        boolean update = false;
        try {
            if (validate) {
                outcomeDescription = "Validate Resource";
                ((IValidateUntyped)client.validate().resource(resource).prettyPrint()).execute();
            } else {
                String id = UrlUtil.sanitizeUrlPart((CharSequence)theReq.getParameter("resource-create-id"));
                if ("update".equals(theMethod)) {
                    outcomeDescription = "Update Resource";
                    client.update(id, resource);
                    update = true;
                } else {
                    outcomeDescription = "Create Resource";
                    ICreateTyped create = client.create().resource(body);
                    create.execute();
                }
            }
        }
        catch (Exception e) {
            returnsResource = this.handleClientException(client, e, theModel);
        }
        long delay = System.currentTimeMillis() - start;
        this.processAndAddLastClientInvocation(client, returnsResource, theModel, delay, outcomeDescription, interceptor, theRequest);
        try {
            if (validate) {
                ourLog.info(this.logPrefix(theModel) + "Validated resource of type " + this.getResourceType(theRequest, theReq).getName());
            } else if (update) {
                ourLog.info(this.logPrefix(theModel) + "Updated resource of type " + this.getResourceType(theRequest, theReq).getName());
            } else {
                ourLog.info(this.logPrefix(theModel) + "Created resource of type " + this.getResourceType(theRequest, theReq).getName());
            }
        }
        catch (Exception e) {
            ourLog.warn("Failed to determine resource type from request", (Throwable)e);
        }
    }

    @RequestMapping(value={"/operation"})
    public String actionOperation(HttpServletRequest theReq, HomeRequest theRequest, BindingResult theBindingResult, ModelMap theModel) {
        String instanceType = UrlUtil.sanitizeUrlPart((CharSequence)UrlUtil.unescape((String)theReq.getParameter("instanceType")));
        String instanceId = UrlUtil.sanitizeUrlPart((CharSequence)UrlUtil.unescape((String)theReq.getParameter("instanceId")));
        String operationName = UrlUtil.sanitizeUrlPart((CharSequence)UrlUtil.unescape((String)theReq.getParameter("operationName")));
        boolean finished = false;
        this.addCommonParams(theReq, theRequest, theModel);
        BaseController.CaptureInterceptor interceptor = new BaseController.CaptureInterceptor();
        GenericClient client = theRequest.newClient(theReq, this.getContext(theRequest), this.myConfig, interceptor);
        client.setPrettyPrint(Boolean.valueOf(true));
        Class type = this.getContext(theRequest).getResourceDefinition(instanceType).getImplementingClass();
        Class parametersType = this.getContext(theRequest).getResourceDefinition("Parameters").getImplementingClass();
        StopWatch sw = new StopWatch();
        BaseController.ResultType returnsResource = Controller.getReturnedTypeBasedOnOperation(operationName);
        try {
            ((IOperationUnnamed)client.operation().onInstance(instanceType + "/" + instanceId)).named(operationName).withNoParameters(parametersType).useHttpGet().execute();
        }
        catch (DataFormatException e) {
            ourLog.warn("Failed to parse resource", (Throwable)e);
            theModel.put((Object)"errorMsg", (Object)this.toDisplayError("Failed to parse message body. Error was: " + e.getMessage(), (Exception)((Object)e)));
            finished = true;
        }
        catch (BaseServerResponseException e) {
            theModel.put((Object)"errorMsg", (Object)e.getMessage());
            returnsResource = BaseController.ResultType.RESOURCE;
        }
        String outcomeDescription = "Execute " + operationName + " Operation";
        this.processAndAddLastClientInvocation(client, returnsResource, theModel, sw.getMillis(), outcomeDescription, interceptor, theRequest);
        return "result";
    }

    private void doActionHistory(HttpServletRequest theReq, HomeRequest theRequest, BindingResult theBindingResult, ModelMap theModel, String theMethod, String theMethodDescription) {
        this.addCommonParams(theReq, theRequest, theModel);
        BaseController.CaptureInterceptor interceptor = new BaseController.CaptureInterceptor();
        GenericClient client = theRequest.newClient(theReq, this.getContext(theRequest), this.myConfig, interceptor);
        String id = null;
        Class type = null;
        if ("history-type".equals(theMethod)) {
            RuntimeResourceDefinition def = this.getContext(theRequest).getResourceDefinition(theRequest.getResource());
            type = def.getImplementingClass();
            id = UrlUtil.sanitizeUrlPart((CharSequence)StringUtils.defaultString((String)theReq.getParameter("resource-history-id")));
        }
        DateTimeDt since = null;
        String sinceStr = UrlUtil.sanitizeUrlPart((CharSequence)theReq.getParameter("since"));
        if (StringUtils.isNotBlank((CharSequence)sinceStr)) {
            since = new DateTimeDt(sinceStr);
        }
        Integer limit = null;
        String limitStr = UrlUtil.sanitizeUrlPart((CharSequence)theReq.getParameter("limit"));
        if (StringUtils.isNotBlank((CharSequence)limitStr)) {
            limit = Integer.parseInt(limitStr);
        }
        BaseController.ResultType returnsResource = BaseController.ResultType.BUNDLE;
        long start = System.currentTimeMillis();
        try {
            ourLog.info(this.logPrefix(theModel) + "Retrieving history for type {} ID {} since {}", new Object[]{type, id, since});
            IHistory hist0 = client.history();
            IHistoryUntyped hist1 = StringUtils.isNotBlank((CharSequence)id) ? (IHistoryUntyped)hist0.onInstance((IIdType)new IdDt(theRequest.getResource(), id)) : (type != null ? (IHistoryUntyped)hist0.onType(type) : (IHistoryUntyped)hist0.onServer());
            IHistoryTyped hist2 = hist1.andReturnBundle(client.getFhirContext().getResourceDefinition("Bundle").getImplementingClass(IBaseBundle.class));
            if (since != null) {
                hist2.since((IPrimitiveType)since);
            }
            if (limit != null) {
                hist2.count(limit);
            }
            hist2.execute();
        }
        catch (Exception e) {
            returnsResource = this.handleClientException(client, e, theModel);
        }
        long delay = System.currentTimeMillis() - start;
        this.processAndAddLastClientInvocation(client, returnsResource, theModel, delay, theMethodDescription, interceptor, theRequest);
    }

    private boolean extractSearchParamsDstu2(IBaseResource theConformance, String resourceName, TreeSet<String> includes, TreeSet<String> theRevIncludes, TreeSet<String> sortParams, boolean haveSearchParams, List<List<String>> queryIncludes) {
        Conformance conformance = (Conformance)theConformance;
        for (Conformance.Rest nextRest : conformance.getRest()) {
            for (Conformance.RestResource nextRes : nextRest.getResource()) {
                if (((String)nextRes.getTypeElement().getValue()).equals(resourceName)) {
                    for (StringDt next : nextRes.getSearchInclude()) {
                        if (next.isEmpty()) continue;
                        includes.add((String)next.getValue());
                    }
                    for (StringDt next : nextRes.getSearchParam()) {
                        if (next.getTypeElement().getValueAsEnum() == SearchParamTypeEnum.COMPOSITE) continue;
                        sortParams.add((String)next.getNameElement().getValue());
                    }
                    if (nextRes.getSearchParam().size() <= 0) continue;
                    haveSearchParams = true;
                    continue;
                }
                for (StringDt next : nextRes.getSearchParam()) {
                    if (next.getTypeElement().getValueAsEnum() != SearchParamTypeEnum.REFERENCE) continue;
                    for (BoundCodeDt nextTargetType : next.getTarget()) {
                        if (!((String)nextTargetType.getValue()).equals(resourceName)) continue;
                        theRevIncludes.add((String)nextRes.getTypeElement().getValue() + ":" + next.getName());
                    }
                }
            }
        }
        return haveSearchParams;
    }

    private boolean extractSearchParamsDstu3CapabilityStatement(IBaseResource theConformance, String resourceName, TreeSet<String> includes, TreeSet<String> theRevIncludes, TreeSet<String> sortParams, boolean haveSearchParams, List<List<String>> queryIncludes) {
        org.hl7.fhir.dstu3.model.CapabilityStatement conformance = (org.hl7.fhir.dstu3.model.CapabilityStatement)theConformance;
        for (CapabilityStatement.CapabilityStatementRestComponent nextRest : conformance.getRest()) {
            for (CapabilityStatement.CapabilityStatementRestResourceComponent nextRes : nextRest.getResource()) {
                if (((String)nextRes.getTypeElement().getValue()).equals(resourceName)) {
                    for (org.hl7.fhir.dstu3.model.StringType next : nextRes.getSearchInclude()) {
                        if (next.isEmpty()) continue;
                        includes.add((String)next.getValue());
                    }
                    for (org.hl7.fhir.dstu3.model.StringType next : nextRes.getSearchParam()) {
                        if (next.getTypeElement().getValue() == Enumerations.SearchParamType.COMPOSITE) continue;
                        sortParams.add((String)next.getNameElement().getValue());
                    }
                    if (nextRes.getSearchParam().size() <= 0) continue;
                    haveSearchParams = true;
                    continue;
                }
                for (org.hl7.fhir.dstu3.model.StringType next : nextRes.getSearchParam()) {
                    if (next.getTypeElement().getValue() != Enumerations.SearchParamType.REFERENCE) continue;
                }
            }
        }
        return haveSearchParams;
    }

    private boolean extractSearchParamsR4CapabilityStatement(IBaseResource theConformance, String resourceName, TreeSet<String> includes, TreeSet<String> theRevIncludes, TreeSet<String> sortParams, boolean haveSearchParams, List<List<String>> queryIncludes) {
        org.hl7.fhir.r4.model.CapabilityStatement conformance = (org.hl7.fhir.r4.model.CapabilityStatement)theConformance;
        for (CapabilityStatement.CapabilityStatementRestComponent nextRest : conformance.getRest()) {
            for (CapabilityStatement.CapabilityStatementRestResourceComponent nextRes : nextRest.getResource()) {
                if (((String)nextRes.getTypeElement().getValue()).equals(resourceName)) {
                    for (StringType next : nextRes.getSearchInclude()) {
                        if (next.isEmpty()) continue;
                        includes.add((String)next.getValue());
                    }
                    for (StringType next : nextRes.getSearchParam()) {
                        if (next.getTypeElement().getValue() == Enumerations.SearchParamType.COMPOSITE) continue;
                        sortParams.add((String)next.getNameElement().getValue());
                    }
                    if (nextRes.getSearchParam().size() <= 0) continue;
                    haveSearchParams = true;
                    continue;
                }
                for (StringType next : nextRes.getSearchParam()) {
                    if (next.getTypeElement().getValue() != Enumerations.SearchParamType.REFERENCE) continue;
                }
            }
        }
        return haveSearchParams;
    }

    private boolean extractSearchParamsR5CapabilityStatement(IBaseResource theConformance, String resourceName, TreeSet<String> includes, TreeSet<String> theRevIncludes, TreeSet<String> sortParams, boolean haveSearchParams, List<List<String>> queryIncludes) {
        CapabilityStatement conformance = (CapabilityStatement)theConformance;
        for (CapabilityStatement.CapabilityStatementRestComponent nextRest : conformance.getRest()) {
            for (CapabilityStatement.CapabilityStatementRestResourceComponent nextRes : nextRest.getResource()) {
                if (((String)nextRes.getTypeElement().getValue()).equals(resourceName)) {
                    for (org.hl7.fhir.r5.model.StringType next : nextRes.getSearchInclude()) {
                        if (next.isEmpty()) continue;
                        includes.add((String)next.getValue());
                    }
                    for (org.hl7.fhir.r5.model.StringType next : nextRes.getSearchParam()) {
                        if (next.getTypeElement().getValue() == Enumerations.SearchParamType.COMPOSITE) continue;
                        sortParams.add((String)next.getNameElement().getValue());
                    }
                    if (nextRes.getSearchParam().size() <= 0) continue;
                    haveSearchParams = true;
                    continue;
                }
                for (org.hl7.fhir.r5.model.StringType next : nextRes.getSearchParam()) {
                    if (next.getTypeElement().getValue() != Enumerations.SearchParamType.REFERENCE) continue;
                }
            }
        }
        return haveSearchParams;
    }

    /*
     * WARNING - void declaration
     */
    private boolean handleSearchParam(String paramIdxString, HttpServletRequest theReq, IQuery theQuery, JsonWriter theClientCodeJsonWriter) throws IOException {
        List<Object> values;
        String nextName = UrlUtil.sanitizeUrlPart((CharSequence)theReq.getParameter("param." + paramIdxString + ".name"));
        if (StringUtils.isBlank((CharSequence)nextName)) {
            return false;
        }
        String nextQualifier = UrlUtil.sanitizeUrlPart((CharSequence)StringUtils.defaultString((String)theReq.getParameter("param." + paramIdxString + ".qualifier")));
        String nextType = UrlUtil.sanitizeUrlPart((CharSequence)theReq.getParameter("param." + paramIdxString + ".type"));
        ArrayList<String> parts = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            parts.add(UrlUtil.sanitizeUrlPart((CharSequence)StringUtils.defaultString((String)theReq.getParameter("param." + paramIdxString + "." + i))));
        }
        boolean addToWhere = true;
        if ("token".equals(nextType)) {
            if (StringUtils.isBlank((CharSequence)((CharSequence)parts.get(1)))) {
                return true;
            }
            addToWhere = false;
            if (StringUtils.isBlank((CharSequence)((CharSequence)parts.get(0)))) {
                values = Collections.singletonList((String)parts.get(1));
                theQuery.where(new TokenClientParam(nextName + nextQualifier).exactly().code((String)parts.get(1)));
            } else {
                values = Collections.singletonList((String)parts.get(0) + "|" + (String)parts.get(1));
                theQuery.where(new TokenClientParam(nextName + nextQualifier).exactly().systemAndCode((String)parts.get(0), (String)parts.get(1)));
            }
        } else if ("date".equals(nextType)) {
            values = new ArrayList();
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)parts.get(1)))) {
                values.add(StringUtils.join((Object[])new String[]{(String)parts.get(0), (String)parts.get(1)}));
            }
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)parts.get(3)))) {
                values.add(StringUtils.join((Object[])new String[]{(String)parts.get(2), (String)parts.get(3)}));
            }
            if (values.isEmpty()) {
                return true;
            }
        } else if ("quantity".equals(nextType)) {
            void var12_19;
            values = new ArrayList();
            addToWhere = false;
            QuantityClientParam param = new QuantityClientParam(nextName);
            if ("~".equals(parts.get(0))) {
                NumberClientParam.IMatches iMatches = param.approximately();
            } else if ("=".equals(parts.get(0))) {
                NumberClientParam.IMatches iMatches = param.exactly();
            } else if (">=".equals(parts.get(0))) {
                NumberClientParam.IMatches iMatches = param.greaterThanOrEquals();
            } else if ("<=".equals(parts.get(0))) {
                NumberClientParam.IMatches iMatches = param.lessThanOrEquals();
            } else if (">".equals(parts.get(0))) {
                NumberClientParam.IMatches iMatches = param.greaterThan();
            } else if ("<".equals(parts.get(0))) {
                NumberClientParam.IMatches iMatches = param.lessThan();
            } else {
                throw new Error(Msg.code((int)191) + "Unknown qualifier: " + (String)parts.get(0));
            }
            QuantityClientParam.IAndUnits number = (QuantityClientParam.IAndUnits)var12_19.number((String)parts.get(1));
            if (StringUtils.isBlank((CharSequence)((CharSequence)parts.get(3)))) {
                theQuery.where(number.andNoUnits());
            } else if (StringUtils.isBlank((CharSequence)((CharSequence)parts.get(2)))) {
                theQuery.where(number.andUnits((String)parts.get(3)));
            } else {
                theQuery.where(number.andUnits((String)parts.get(2), (String)parts.get(3)));
            }
            values.add((String)parts.get(0) + (String)parts.get(1) + "|" + (String)parts.get(2) + "|" + (String)parts.get(3));
            if (values.isEmpty()) {
                return true;
            }
        } else {
            values = Collections.singletonList(StringUtils.join(parts, (String)""));
            if (StringUtils.isBlank((CharSequence)((CharSequence)values.get(0)))) {
                return true;
            }
        }
        for (String string : values) {
            theClientCodeJsonWriter.beginObject();
            theClientCodeJsonWriter.name("type");
            theClientCodeJsonWriter.value(nextType);
            theClientCodeJsonWriter.name("name");
            theClientCodeJsonWriter.value(nextName);
            theClientCodeJsonWriter.name("qualifier");
            theClientCodeJsonWriter.value(nextQualifier);
            theClientCodeJsonWriter.name("value");
            theClientCodeJsonWriter.value(string);
            theClientCodeJsonWriter.endObject();
            if (!addToWhere) continue;
            theQuery.where(new StringClientParam(nextName + nextQualifier).matches().value(string));
        }
        if (StringUtils.isNotBlank((CharSequence)theReq.getParameter("param." + paramIdxString + ".0.name"))) {
            this.handleSearchParam(paramIdxString + ".0", theReq, theQuery, theClientCodeJsonWriter);
        }
        return true;
    }

    private static BaseController.ResultType getReturnedTypeBasedOnOperation(@Nullable String operationName) {
        return "$diff".equals(operationName) ? BaseController.ResultType.PARAMETERS : BaseController.ResultType.BUNDLE;
    }
}

