/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.to;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.server.util.ITestingUiClientFactory;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TesterConfig {
    public static final String SYSPROP_FORCE_SERVERS = "ca.uhn.fhir.to.TesterConfig_SYSPROP_FORCE_SERVERS";
    private static final Logger ourLog = LoggerFactory.getLogger(TesterConfig.class);
    private final LinkedHashMap<String, Boolean> myIdToAllowsApiKey = new LinkedHashMap();
    private final LinkedHashMap<String, FhirVersionEnum> myIdToFhirVersion = new LinkedHashMap();
    private final LinkedHashMap<String, String> myIdToServerBase = new LinkedHashMap();
    private final LinkedHashMap<String, String> myIdToServerName = new LinkedHashMap();
    private final List<ServerBuilder> myServerBuilders = new ArrayList<ServerBuilder>();
    private final LinkedHashMap<String, Map<String, IInclusionChecker>> myServerIdToTypeToOperationNameToInclusionChecker = new LinkedHashMap();
    private final LinkedHashMap<String, Map<RestOperationTypeEnum, IInclusionChecker>> myServerIdToTypeToInteractionNameToInclusionChecker = new LinkedHashMap();
    private ITestingUiClientFactory myClientFactory;
    private boolean myRefuseToFetchThirdPartyUrls = true;
    private boolean myDebugTemplatesMode;

    public IServerBuilderStep1 addServer() {
        ServerBuilder retVal = new ServerBuilder();
        this.myServerBuilders.add(retVal);
        return retVal;
    }

    @PostConstruct
    public void build() {
        for (ServerBuilder next : this.myServerBuilders) {
            Validate.notBlank((CharSequence)next.myId, (String)"Found invalid server configuration - No ID supplied", (Object[])new Object[0]);
            Validate.notNull((Object)next.myVersion, (String)"Found invalid server configuration - No FHIR version supplied", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)next.myBaseUrl, (String)"Found invalid server configuration - No base URL supplied", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)next.myName, (String)"Found invalid server configuration - No name supplied", (Object[])new Object[0]);
            this.myIdToFhirVersion.put(next.myId, next.myVersion);
            this.myIdToServerBase.put(next.myId, next.myBaseUrl);
            this.myIdToServerName.put(next.myId, next.myName);
            this.myIdToAllowsApiKey.put(next.myId, next.myAllowsApiKey);
            this.myServerIdToTypeToOperationNameToInclusionChecker.put(next.myId, next.myOperationNameToInclusionChecker);
            this.myServerIdToTypeToInteractionNameToInclusionChecker.put(next.myId, next.mySearchResultRowInteractionEnabled);
            if (!next.myEnableDebugTemplates) continue;
            this.myDebugTemplatesMode = true;
        }
        this.myServerBuilders.clear();
    }

    public ITestingUiClientFactory getClientFactory() {
        return this.myClientFactory;
    }

    public void setClientFactory(ITestingUiClientFactory theClientFactory) {
        this.myClientFactory = theClientFactory;
    }

    public boolean getDebugTemplatesMode() {
        return this.myDebugTemplatesMode;
    }

    public LinkedHashMap<String, Boolean> getIdToAllowsApiKey() {
        return this.myIdToAllowsApiKey;
    }

    public LinkedHashMap<String, FhirVersionEnum> getIdToFhirVersion() {
        return this.myIdToFhirVersion;
    }

    public LinkedHashMap<String, String> getIdToServerBase() {
        return this.myIdToServerBase;
    }

    public LinkedHashMap<String, String> getIdToServerName() {
        return this.myIdToServerName;
    }

    public boolean isRefuseToFetchThirdPartyUrls() {
        return this.myRefuseToFetchThirdPartyUrls;
    }

    public void setRefuseToFetchThirdPartyUrls(boolean theRefuseToFetchThirdPartyUrls) {
        this.myRefuseToFetchThirdPartyUrls = theRefuseToFetchThirdPartyUrls;
    }

    public List<String> getSearchResultRowOperations(String theId, IIdType theResourceId) {
        ArrayList<String> retVal = new ArrayList<String>();
        Map<String, IInclusionChecker> operationNamesToInclusionCheckers = this.myServerIdToTypeToOperationNameToInclusionChecker.get(theId);
        for (String operationName : operationNamesToInclusionCheckers.keySet()) {
            IInclusionChecker checker = operationNamesToInclusionCheckers.get(operationName);
            if (!checker.shouldInclude(theResourceId)) continue;
            retVal.add(operationName);
        }
        return retVal;
    }

    public boolean isSearchResultRowInteractionEnabled(String theServerId, String theInteractionName, IIdType theResourceId) {
        ArrayList retVal = new ArrayList();
        Map<RestOperationTypeEnum, IInclusionChecker> interactionNamesToInclusionCheckers = this.myServerIdToTypeToInteractionNameToInclusionChecker.get(theServerId);
        RestOperationTypeEnum interaction = RestOperationTypeEnum.forCode((String)theInteractionName);
        Validate.isTrue((interaction != null ? 1 : 0) != 0, (String)"Unknown interaction: %s", (Object[])new Object[]{theInteractionName});
        IInclusionChecker inclusionChecker = interactionNamesToInclusionCheckers.getOrDefault(interaction, id -> false);
        return inclusionChecker.shouldInclude(theResourceId);
    }

    public void setServers(List<String> theServers) {
        List<String> servers = theServers;
        String force = System.getProperty(SYSPROP_FORCE_SERVERS);
        if (StringUtils.isNotBlank((CharSequence)force)) {
            ourLog.warn("Forcing server configuration because of system property: {}", (Object)force);
            servers = Collections.singletonList(force);
        }
        for (String nextRaw : servers) {
            String[] nextSplit = nextRaw.split(",");
            if (nextSplit.length < 3) {
                throw new IllegalArgumentException(Msg.code((int)195) + "Invalid server line '" + nextRaw + "' - Must be comma separated");
            }
            Validate.notBlank((CharSequence)nextSplit[0], (String)"theId can not be blank", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)nextSplit[1], (String)"theVersion can not be blank", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)nextSplit[2], (String)"theDisplayName can not be blank", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)nextSplit[3], (String)"theServerBase can not be blank", (Object[])new Object[0]);
            this.myIdToServerName.put(nextSplit[0].trim(), nextSplit[2].trim());
            this.myIdToServerBase.put(nextSplit[0].trim(), nextSplit[3].trim());
            this.myIdToFhirVersion.put(nextSplit[0].trim(), FhirVersionEnum.valueOf((String)nextSplit[1].trim().toUpperCase().replace('.', '_')));
        }
    }

    public class ServerBuilder
    implements IServerBuilderStep1,
    IServerBuilderStep2,
    IServerBuilderStep3,
    IServerBuilderStep4,
    IServerBuilderStep5 {
        private final Map<String, IInclusionChecker> myOperationNameToInclusionChecker = new LinkedHashMap<String, IInclusionChecker>();
        private final Map<RestOperationTypeEnum, IInclusionChecker> mySearchResultRowInteractionEnabled = new LinkedHashMap<RestOperationTypeEnum, IInclusionChecker>();
        private boolean myAllowsApiKey;
        private String myBaseUrl;
        private String myId;
        private String myName;
        private FhirVersionEnum myVersion;
        private boolean myEnableDebugTemplates;

        public ServerBuilder() {
            this.mySearchResultRowInteractionEnabled.put(RestOperationTypeEnum.READ, id -> true);
            this.mySearchResultRowInteractionEnabled.put(RestOperationTypeEnum.UPDATE, id -> true);
        }

        @Override
        public IServerBuilderStep1 addServer() {
            ServerBuilder retVal = new ServerBuilder();
            TesterConfig.this.myServerBuilders.add(retVal);
            return retVal;
        }

        @Override
        public IServerBuilderStep5 allowsApiKey() {
            this.myAllowsApiKey = true;
            return this;
        }

        @Override
        public IServerBuilderStep5 enableDebugTemplates() {
            this.myEnableDebugTemplates = true;
            return this;
        }

        @Override
        public ServerBuilder withSearchResultRowOperation(String theOperationName, IInclusionChecker theResourceType) {
            this.myOperationNameToInclusionChecker.put(theOperationName, theResourceType);
            return this;
        }

        @Override
        public ServerBuilder withSearchResultRowInteraction(RestOperationTypeEnum theInteraction, IInclusionChecker theEnabled) {
            this.mySearchResultRowInteractionEnabled.put(theInteraction, theEnabled);
            return this;
        }

        @Override
        public IServerBuilderStep4 withBaseUrl(String theBaseUrl) {
            Validate.notBlank((CharSequence)theBaseUrl, (String)"theBaseUrl can not be blank", (Object[])new Object[0]);
            this.myBaseUrl = theBaseUrl;
            return this;
        }

        @Override
        public IServerBuilderStep3 withFhirVersion(FhirVersionEnum theVersion) {
            Validate.notNull((Object)theVersion);
            this.myVersion = theVersion;
            return this;
        }

        @Override
        public IServerBuilderStep2 withId(String theId) {
            Validate.notBlank((CharSequence)theId, (String)"theId can not be blank", (Object[])new Object[0]);
            this.myId = theId;
            return this;
        }

        @Override
        public IServerBuilderStep5 withName(String theName) {
            Validate.notBlank((CharSequence)theName, (String)"theName can not be blank", (Object[])new Object[0]);
            this.myName = theName;
            return this;
        }
    }

    public static interface IInclusionChecker {
        public boolean shouldInclude(IIdType var1);
    }

    public static interface IServerBuilderStep5 {
        public IServerBuilderStep1 addServer();

        public IServerBuilderStep5 allowsApiKey();

        public IServerBuilderStep5 enableDebugTemplates();

        public ServerBuilder withSearchResultRowOperation(String var1, IInclusionChecker var2);

        public ServerBuilder withSearchResultRowInteraction(RestOperationTypeEnum var1, IInclusionChecker var2);
    }

    public static interface IServerBuilderStep4 {
        public IServerBuilderStep5 withName(String var1);
    }

    public static interface IServerBuilderStep3 {
        public IServerBuilderStep4 withBaseUrl(String var1);
    }

    public static interface IServerBuilderStep2 {
        public IServerBuilderStep3 withFhirVersion(FhirVersionEnum var1);
    }

    public static interface IServerBuilderStep1 {
        public IServerBuilderStep2 withId(String var1);
    }
}

