/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.SourceDataLine;

public class SoundUtilities {
    public static float SAMPLE_RATE = 8000.0f;

    public static void tone(int hz, int msecs) {
        SoundUtilities.tone(hz, msecs, 1.0);
    }

    public static void tone(int hz, int msecs, double vol) {
        try {
            byte[] buf = new byte[1];
            AudioFormat af = new AudioFormat(SAMPLE_RATE, 8, 1, true, false);
            SourceDataLine sdl = AudioSystem.getSourceDataLine(af);
            sdl.open(af);
            sdl.start();
            for (int i = 0; i < msecs * 8; ++i) {
                double angle = (double)((float)i / (SAMPLE_RATE / (float)hz)) * 2.0 * Math.PI;
                buf[0] = (byte)(Math.sin(angle) * 127.0 * vol);
                sdl.write(buf, 0, 1);
            }
            sdl.drain();
            sdl.stop();
            sdl.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

