/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.ucum;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.hl7.fhir.exceptions.UcumException;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.ucum.BaseUnit;
import org.hl7.fhir.utilities.ucum.Decimal;
import org.hl7.fhir.utilities.ucum.DefinedUnit;
import org.hl7.fhir.utilities.ucum.Prefix;
import org.hl7.fhir.utilities.ucum.UcumModel;
import org.hl7.fhir.utilities.ucum.Value;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class DefinitionParser {
    public UcumModel parse(String filename) throws UcumException, XmlPullParserException, IOException, ParseException {
        return this.parse(new FileInputStream(new File(filename)));
    }

    public UcumModel parse(InputStream stream) throws XmlPullParserException, IOException, ParseException, UcumException {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        factory.setNamespaceAware(true);
        XmlPullParser xpp = factory.newPullParser();
        xpp.setInput(stream, null);
        int eventType = xpp.next();
        if (eventType != 2) {
            throw new XmlPullParserException("Unable to process XML document");
        }
        if (!xpp.getName().equals("root")) {
            throw new XmlPullParserException("Unable to process XML document: expected 'root' but found '" + xpp.getName() + "'");
        }
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss' 'Z");
        Date date = fmt.parse(xpp.getAttributeValue(null, "revision-date").substring(7, 32));
        UcumModel root = new UcumModel(xpp.getAttributeValue(null, "version"), xpp.getAttributeValue(null, "revision"), date);
        xpp.next();
        while (xpp.getEventType() != 3) {
            if (xpp.getEventType() == 4) {
                if (Utilities.isWhitespace(xpp.getText())) {
                    xpp.next();
                    continue;
                }
                throw new XmlPullParserException("Unexpected text " + xpp.getText());
            }
            if (xpp.getName().equals("prefix")) {
                root.getPrefixes().add(this.parsePrefix(xpp));
                continue;
            }
            if (xpp.getName().equals("base-unit")) {
                root.getBaseUnits().add(this.parseBaseUnit(xpp));
                continue;
            }
            if (xpp.getName().equals("unit")) {
                root.getDefinedUnits().add(this.parseUnit(xpp));
                continue;
            }
            throw new XmlPullParserException("unknown element name " + xpp.getName());
        }
        return root;
    }

    private DefinedUnit parseUnit(XmlPullParser xpp) throws XmlPullParserException, IOException, UcumException {
        DefinedUnit unit = new DefinedUnit(xpp.getAttributeValue(null, "Code"), xpp.getAttributeValue(null, "CODE"));
        unit.setMetric("yes".equals(xpp.getAttributeValue(null, "isMetric")));
        unit.setSpecial("yes".equals(xpp.getAttributeValue(null, "isSpecial")));
        unit.setClass_(xpp.getAttributeValue(null, "class"));
        xpp.next();
        this.skipWhitespace(xpp);
        while (xpp.getEventType() == 2 && "name".equals(xpp.getName())) {
            unit.getNames().add(this.readElement(xpp, "name", "unit " + unit.getCode(), false));
        }
        if (xpp.getEventType() == 2 && "printSymbol".equals(xpp.getName())) {
            unit.setPrintSymbol(this.readElement(xpp, "printSymbol", "unit " + unit.getCode(), true));
        }
        unit.setProperty(this.readElement(xpp, "property", "unit " + unit.getCode(), false));
        unit.setValue(this.parseValue(xpp, "unit " + unit.getCode()));
        xpp.next();
        this.skipWhitespace(xpp);
        return unit;
    }

    private Value parseValue(XmlPullParser xpp, String context) throws XmlPullParserException, UcumException, IOException {
        this.checkAtElement(xpp, "value", context);
        Decimal val = null;
        if (xpp.getAttributeValue(null, "value") != null) {
            try {
                val = xpp.getAttributeValue(null, "value").contains(".") ? new Decimal(xpp.getAttributeValue(null, "value"), 24) : new Decimal(xpp.getAttributeValue(null, "value"));
            }
            catch (NumberFormatException e) {
                throw new XmlPullParserException("Error reading " + context + ": " + e.getMessage());
            }
        }
        Value value = new Value(xpp.getAttributeValue(null, "Unit"), xpp.getAttributeValue(null, "UNIT"), val);
        value.setText(this.readElement(xpp, "value", context, true));
        return value;
    }

    private BaseUnit parseBaseUnit(XmlPullParser xpp) throws XmlPullParserException, IOException {
        BaseUnit base = new BaseUnit(xpp.getAttributeValue(null, "Code"), xpp.getAttributeValue(null, "CODE"));
        base.setDim(xpp.getAttributeValue(null, "dim").charAt(0));
        xpp.next();
        this.skipWhitespace(xpp);
        base.getNames().add(this.readElement(xpp, "name", "base-unit " + base.getCode(), false));
        base.setPrintSymbol(this.readElement(xpp, "printSymbol", "base-unit " + base.getCode(), false));
        base.setProperty(this.readElement(xpp, "property", "base-unit " + base.getCode(), false));
        xpp.next();
        this.skipWhitespace(xpp);
        return base;
    }

    private Prefix parsePrefix(XmlPullParser xpp) throws XmlPullParserException, IOException, UcumException {
        Prefix prefix = new Prefix(xpp.getAttributeValue(null, "Code"), xpp.getAttributeValue(null, "CODE"));
        xpp.next();
        this.skipWhitespace(xpp);
        prefix.getNames().add(this.readElement(xpp, "name", "prefix " + prefix.getCode(), false));
        prefix.setPrintSymbol(this.readElement(xpp, "printSymbol", "prefix " + prefix.getCode(), false));
        this.checkAtElement(xpp, "value", "prefix " + prefix.getCode());
        prefix.setValue(new Decimal(xpp.getAttributeValue(null, "value"), 24));
        this.readElement(xpp, "value", "prefix " + prefix.getCode(), true);
        xpp.next();
        this.skipWhitespace(xpp);
        return prefix;
    }

    private String readElement(XmlPullParser xpp, String name, String context, boolean complex) throws XmlPullParserException, IOException {
        this.checkAtElement(xpp, name, context);
        xpp.next();
        this.skipWhitespace(xpp);
        String val = null;
        if (complex) {
            val = this.readText(xpp);
        } else if (xpp.getEventType() == 4) {
            val = xpp.getText();
            xpp.next();
            this.skipWhitespace(xpp);
        }
        if (xpp.getEventType() != 3) {
            throw new XmlPullParserException("Unexpected content reading " + context);
        }
        xpp.next();
        this.skipWhitespace(xpp);
        return val;
    }

    private String readText(XmlPullParser xpp) throws XmlPullParserException, IOException {
        StringBuilder bldr = new StringBuilder();
        while (xpp.getEventType() != 3) {
            if (xpp.getEventType() == 4) {
                bldr.append(xpp.getText());
                xpp.next();
                continue;
            }
            xpp.next();
            bldr.append(this.readText(xpp));
            xpp.next();
            this.skipWhitespace(xpp);
        }
        return bldr.toString();
    }

    private void skipWhitespace(XmlPullParser xpp) throws XmlPullParserException, IOException {
        while (xpp.getEventType() == 4 && Utilities.isWhitespace(xpp.getText())) {
            xpp.next();
        }
    }

    private void checkAtElement(XmlPullParser xpp, String name, String context) throws XmlPullParserException {
        if (xpp.getEventType() != 2) {
            throw new XmlPullParserException("Unexpected state looking for " + name + ": at " + Integer.toString(xpp.getEventType()) + "  reading " + context);
        }
        if (!xpp.getName().equals(name)) {
            throw new XmlPullParserException("Unexpected element looking for " + name + ": found " + xpp.getName() + "  reading " + context);
        }
    }
}

