/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.hapi.validation;

import ca.uhn.fhir.context.FhirContext;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu2.model.StructureDefinition;
import org.hl7.fhir.dstu2.model.ValueSet;
import org.hl7.fhir.instance.hapi.validation.IValidationSupport;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class ValidationSupportChain
implements IValidationSupport {
    private List<IValidationSupport> myChain = new ArrayList<IValidationSupport>();

    public ValidationSupportChain() {
    }

    public ValidationSupportChain(IValidationSupport ... theValidationSupportModules) {
        this();
        for (IValidationSupport next : theValidationSupportModules) {
            if (next == null) continue;
            this.myChain.add(next);
        }
    }

    public void addValidationSupport(IValidationSupport theValidationSupport) {
        this.myChain.add(theValidationSupport);
    }

    @Override
    public List<StructureDefinition> allStructures() {
        ArrayList<StructureDefinition> retVal = new ArrayList<StructureDefinition>();
        for (IValidationSupport next : this.myChain) {
            retVal.addAll(next.allStructures());
        }
        return retVal;
    }

    @Override
    public ValueSet.ValueSetExpansionComponent expandValueSet(FhirContext theCtx, ValueSet.ConceptSetComponent theInclude) {
        for (IValidationSupport next : this.myChain) {
            if (!next.isCodeSystemSupported(theCtx, theInclude.getSystem())) continue;
            return next.expandValueSet(theCtx, theInclude);
        }
        return this.myChain.get(0).expandValueSet(theCtx, theInclude);
    }

    @Override
    public ValueSet fetchCodeSystem(FhirContext theCtx, String theSystem) {
        for (IValidationSupport next : this.myChain) {
            ValueSet retVal = next.fetchCodeSystem(theCtx, theSystem);
            if (retVal == null) continue;
            return retVal;
        }
        return null;
    }

    @Override
    public <T extends IBaseResource> T fetchResource(FhirContext theContext, Class<T> theClass, String theUri) {
        for (IValidationSupport next : this.myChain) {
            T retVal = next.fetchResource(theContext, theClass, theUri);
            if (retVal == null) continue;
            return retVal;
        }
        return null;
    }

    @Override
    public boolean isCodeSystemSupported(FhirContext theCtx, String theSystem) {
        for (IValidationSupport next : this.myChain) {
            if (!next.isCodeSystemSupported(theCtx, theSystem)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IValidationSupport.CodeValidationResult validateCode(FhirContext theCtx, String theCodeSystem, String theCode, String theDisplay) {
        for (IValidationSupport next : this.myChain) {
            if (theCodeSystem == null || !next.isCodeSystemSupported(theCtx, theCodeSystem)) continue;
            return next.validateCode(theCtx, theCodeSystem, theCode, theDisplay);
        }
        return this.myChain.get(0).validateCode(theCtx, theCodeSystem, theCode, theDisplay);
    }
}

