/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.common.hapi.validation.support;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.context.support.ValueSetExpansionOptions;
import ca.uhn.fhir.model.dstu2.resource.ValueSet;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.util.VersionIndependentConcept;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.convertors.conv10_50.ValueSet10_50;
import org.hl7.fhir.convertors.conv30_50.CodeSystem30_50;
import org.hl7.fhir.convertors.conv30_50.ValueSet30_50;
import org.hl7.fhir.convertors.conv40_50.CodeSystem40_50;
import org.hl7.fhir.convertors.conv40_50.ValueSet40_50;
import org.hl7.fhir.dstu2.model.ValueSet;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.ValueSet;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class InMemoryTerminologyServerValidationSupport
implements IValidationSupport {
    private final FhirContext myCtx;

    public InMemoryTerminologyServerValidationSupport(FhirContext theCtx) {
        Validate.notNull((Object)theCtx, (String)"theCtx must not be null", (Object[])new Object[0]);
        this.myCtx = theCtx;
    }

    public FhirContext getFhirContext() {
        return this.myCtx;
    }

    public IValidationSupport.ValueSetExpansionOutcome expandValueSet(ValidationSupportContext theValidationSupportContext, ValueSetExpansionOptions theExpansionOptions, IBaseResource theValueSetToExpand) {
        org.hl7.fhir.r5.model.ValueSet expansion;
        org.hl7.fhir.r5.model.ValueSet expansionR5 = this.expandValueSetToCanonical(theValidationSupportContext, theValueSetToExpand, null, null);
        if (expansionR5 == null) {
            return null;
        }
        switch (this.myCtx.getVersion().getVersion()) {
            case DSTU2_HL7ORG: {
                expansion = ValueSet10_50.convertValueSet((org.hl7.fhir.r5.model.ValueSet)expansionR5);
                break;
            }
            case DSTU3: {
                expansion = ValueSet30_50.convertValueSet((org.hl7.fhir.r5.model.ValueSet)expansionR5);
                break;
            }
            case R4: {
                expansion = ValueSet40_50.convertValueSet((org.hl7.fhir.r5.model.ValueSet)expansionR5);
                break;
            }
            case R5: {
                expansion = expansionR5;
                break;
            }
            default: {
                throw new IllegalArgumentException("Can not handle version: " + this.myCtx.getVersion().getVersion());
            }
        }
        return new IValidationSupport.ValueSetExpansionOutcome((IBaseResource)expansion, null);
    }

    private org.hl7.fhir.r5.model.ValueSet expandValueSetToCanonical(ValidationSupportContext theValidationSupportContext, IBaseResource theValueSetToExpand, @Nullable String theWantSystem, @Nullable String theWantCode) {
        org.hl7.fhir.r5.model.ValueSet expansionR5;
        switch (theValueSetToExpand.getStructureFhirVersionEnum()) {
            case DSTU2: {
                expansionR5 = this.expandValueSetDstu2(theValidationSupportContext, (ca.uhn.fhir.model.dstu2.resource.ValueSet)theValueSetToExpand, theWantSystem, theWantCode);
                break;
            }
            case DSTU2_HL7ORG: {
                expansionR5 = this.expandValueSetDstu2Hl7Org(theValidationSupportContext, (org.hl7.fhir.dstu2.model.ValueSet)theValueSetToExpand, theWantSystem, theWantCode);
                break;
            }
            case DSTU3: {
                expansionR5 = this.expandValueSetDstu3(theValidationSupportContext, (ValueSet)theValueSetToExpand, theWantSystem, theWantCode);
                break;
            }
            case R4: {
                expansionR5 = this.expandValueSetR4(theValidationSupportContext, (org.hl7.fhir.r4.model.ValueSet)theValueSetToExpand, theWantSystem, theWantCode);
                break;
            }
            case R5: {
                expansionR5 = this.expandValueSetR5(theValidationSupportContext, (org.hl7.fhir.r5.model.ValueSet)theValueSetToExpand);
                break;
            }
            default: {
                throw new IllegalArgumentException("Can not handle version: " + this.myCtx.getVersion().getVersion());
            }
        }
        if (expansionR5 == null) {
            return null;
        }
        return expansionR5;
    }

    public IValidationSupport.CodeValidationResult validateCodeInValueSet(ValidationSupportContext theValidationSupportContext, ConceptValidationOptions theOptions, String theCodeSystem, String theCode, String theDisplay, @Nonnull IBaseResource theValueSet) {
        org.hl7.fhir.r5.model.ValueSet expansion = this.expandValueSetToCanonical(theValidationSupportContext, theValueSet, theCodeSystem, theCode);
        if (expansion == null) {
            return null;
        }
        return this.validateCodeInExpandedValueSet(theValidationSupportContext, theOptions, theCodeSystem, theCode, theDisplay, (IBaseResource)expansion);
    }

    public IValidationSupport.CodeValidationResult validateCode(ValidationSupportContext theValidationSupportContext, ConceptValidationOptions theOptions, String theCodeSystem, String theCode, String theDisplay, String theValueSetUrl) {
        IValidationSupport.ValueSetExpansionOutcome valueSetExpansionOutcome;
        IBaseResource vs;
        if (StringUtils.isNotBlank((CharSequence)theValueSetUrl)) {
            vs = theValidationSupportContext.getRootValidationSupport().fetchValueSet(theValueSetUrl);
            if (vs == null) {
                return null;
            }
        } else {
            switch (this.myCtx.getVersion().getVersion()) {
                case DSTU2_HL7ORG: {
                    vs = new org.hl7.fhir.dstu2.model.ValueSet().setCompose(new ValueSet.ValueSetComposeComponent().addInclude(new ValueSet.ConceptSetComponent().setSystem(theCodeSystem)));
                    break;
                }
                case DSTU3: {
                    vs = new ValueSet().setCompose(new ValueSet.ValueSetComposeComponent().addInclude(new ValueSet.ConceptSetComponent().setSystem(theCodeSystem)));
                    break;
                }
                case R4: {
                    vs = new org.hl7.fhir.r4.model.ValueSet().setCompose(new ValueSet.ValueSetComposeComponent().addInclude(new ValueSet.ConceptSetComponent().setSystem(theCodeSystem)));
                    break;
                }
                case R5: {
                    vs = new org.hl7.fhir.r5.model.ValueSet().setCompose(new ValueSet.ValueSetComposeComponent().addInclude(new ValueSet.ConceptSetComponent().setSystem(theCodeSystem)));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Can not handle version: " + this.myCtx.getVersion().getVersion());
                }
            }
        }
        if ((valueSetExpansionOutcome = this.expandValueSet(theValidationSupportContext, null, vs)) == null) {
            return null;
        }
        IBaseResource expansion = valueSetExpansionOutcome.getValueSet();
        return this.validateCodeInExpandedValueSet(theValidationSupportContext, theOptions, theCodeSystem, theCode, theDisplay, expansion);
    }

    private IValidationSupport.CodeValidationResult validateCodeInExpandedValueSet(ValidationSupportContext theValidationSupportContext, ConceptValidationOptions theOptions, String theCodeSystem, String theCode, String theDisplay, IBaseResource theExpansion) {
        String message;
        ValidationMessage.IssueSeverity severity;
        assert (theExpansion != null);
        boolean caseSensitive = true;
        IBaseResource system = null;
        if (!theOptions.isInferSystem() && StringUtils.isNotBlank((CharSequence)theCodeSystem)) {
            system = theValidationSupportContext.getRootValidationSupport().fetchCodeSystem(theCodeSystem);
        }
        ArrayList<VersionIndependentConcept> codes = new ArrayList<VersionIndependentConcept>();
        switch (theExpansion.getStructureFhirVersionEnum()) {
            case DSTU2_HL7ORG: {
                org.hl7.fhir.dstu2.model.ValueSet expansionVs = (org.hl7.fhir.dstu2.model.ValueSet)theExpansion;
                List contains = expansionVs.getExpansion().getContains();
                InMemoryTerminologyServerValidationSupport.flattenAndConvertCodesDstu2(contains, codes);
                break;
            }
            case DSTU3: {
                org.hl7.fhir.dstu2.model.ValueSet expansionVs = (ValueSet)theExpansion;
                List contains = expansionVs.getExpansion().getContains();
                InMemoryTerminologyServerValidationSupport.flattenAndConvertCodesDstu3(contains, codes);
                break;
            }
            case R4: {
                org.hl7.fhir.dstu2.model.ValueSet expansionVs = (org.hl7.fhir.r4.model.ValueSet)theExpansion;
                List contains = expansionVs.getExpansion().getContains();
                InMemoryTerminologyServerValidationSupport.flattenAndConvertCodesR4(contains, codes);
                break;
            }
            case R5: {
                org.hl7.fhir.dstu2.model.ValueSet expansionVs = (org.hl7.fhir.r5.model.ValueSet)theExpansion;
                List contains = expansionVs.getExpansion().getContains();
                InMemoryTerminologyServerValidationSupport.flattenAndConvertCodesR5(contains, codes);
                break;
            }
            default: {
                throw new IllegalArgumentException("Can not handle version: " + this.myCtx.getVersion().getVersion());
            }
        }
        String codeSystemName = null;
        String codeSystemVersion = null;
        String codeSystemContentMode = null;
        if (system != null) {
            switch (system.getStructureFhirVersionEnum()) {
                case DSTU2_HL7ORG: {
                    caseSensitive = true;
                    break;
                }
                case DSTU3: {
                    org.hl7.fhir.dstu3.model.CodeSystem systemDstu3 = (org.hl7.fhir.dstu3.model.CodeSystem)system;
                    caseSensitive = systemDstu3.getCaseSensitive();
                    codeSystemName = systemDstu3.getName();
                    codeSystemVersion = systemDstu3.getVersion();
                    codeSystemContentMode = systemDstu3.getContentElement().getValueAsString();
                    break;
                }
                case R4: {
                    CodeSystem systemR4 = (CodeSystem)system;
                    caseSensitive = systemR4.getCaseSensitive();
                    codeSystemName = systemR4.getName();
                    codeSystemVersion = systemR4.getVersion();
                    codeSystemContentMode = systemR4.getContentElement().getValueAsString();
                    break;
                }
                case R5: {
                    org.hl7.fhir.r5.model.CodeSystem systemR5 = (org.hl7.fhir.r5.model.CodeSystem)system;
                    caseSensitive = systemR5.getCaseSensitive();
                    codeSystemName = systemR5.getName();
                    codeSystemVersion = systemR5.getVersion();
                    codeSystemContentMode = systemR5.getContentElement().getValueAsString();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Can not handle version: " + this.myCtx.getVersion().getVersion());
                }
            }
        }
        for (VersionIndependentConcept nextExpansionCode : codes) {
            boolean codeMatches = caseSensitive ? StringUtils.defaultString((String)theCode).equals(nextExpansionCode.getCode()) : StringUtils.defaultString((String)theCode).equalsIgnoreCase(nextExpansionCode.getCode());
            if (!codeMatches || !theOptions.isInferSystem() && !nextExpansionCode.getSystem().equals(theCodeSystem)) continue;
            if (!theOptions.isValidateDisplay() || StringUtils.isBlank((CharSequence)nextExpansionCode.getDisplay()) || StringUtils.isBlank((CharSequence)theDisplay) || nextExpansionCode.getDisplay().equals(theDisplay)) {
                return new IValidationSupport.CodeValidationResult().setCode(theCode).setDisplay(nextExpansionCode.getDisplay()).setCodeSystemName(codeSystemName).setCodeSystemVersion(codeSystemVersion);
            }
            return new IValidationSupport.CodeValidationResult().setSeverity(IValidationSupport.IssueSeverity.ERROR).setDisplay(nextExpansionCode.getDisplay()).setMessage("Concept Display \"" + theDisplay + "\" does not match expected \"" + nextExpansionCode.getDisplay() + "\"").setCodeSystemName(codeSystemName).setCodeSystemVersion(codeSystemVersion);
        }
        if ("fragment".equals(codeSystemContentMode)) {
            severity = ValidationMessage.IssueSeverity.WARNING;
            message = "Unknown code in fragment CodeSystem '" + (StringUtils.isNotBlank((CharSequence)theCodeSystem) ? theCodeSystem + "#" : "") + theCode + "'";
        } else {
            severity = ValidationMessage.IssueSeverity.ERROR;
            message = "Unknown code '" + (StringUtils.isNotBlank((CharSequence)theCodeSystem) ? theCodeSystem + "#" : "") + theCode + "'";
        }
        return new IValidationSupport.CodeValidationResult().setSeverityCode(severity.toCode()).setMessage(message);
    }

    public IValidationSupport.LookupCodeResult lookupCode(ValidationSupportContext theValidationSupportContext, String theSystem, String theCode) {
        return this.validateCode(theValidationSupportContext, new ConceptValidationOptions(), theSystem, theCode, null, null).asLookupCodeResult(theSystem, theCode);
    }

    @Nullable
    private org.hl7.fhir.r5.model.ValueSet expandValueSetDstu2Hl7Org(ValidationSupportContext theValidationSupportContext, org.hl7.fhir.dstu2.model.ValueSet theInput, @Nullable String theWantSystem, @Nullable String theWantCode) {
        Function<String, org.hl7.fhir.r5.model.CodeSystem> codeSystemLoader = t -> {
            org.hl7.fhir.dstu2.model.ValueSet codeSystem = (org.hl7.fhir.dstu2.model.ValueSet)theValidationSupportContext.getRootValidationSupport().fetchCodeSystem(t);
            org.hl7.fhir.r5.model.CodeSystem retVal = new org.hl7.fhir.r5.model.CodeSystem();
            this.addCodesDstu2Hl7Org(codeSystem.getCodeSystem().getConcept(), retVal.getConcept());
            return retVal;
        };
        Function<String, org.hl7.fhir.r5.model.ValueSet> valueSetLoader = t -> {
            org.hl7.fhir.dstu2.model.ValueSet valueSet = (org.hl7.fhir.dstu2.model.ValueSet)theValidationSupportContext.getRootValidationSupport().fetchValueSet(t);
            return ValueSet10_50.convertValueSet((org.hl7.fhir.dstu2.model.ValueSet)valueSet);
        };
        org.hl7.fhir.r5.model.ValueSet input = ValueSet10_50.convertValueSet((org.hl7.fhir.dstu2.model.ValueSet)theInput);
        org.hl7.fhir.r5.model.ValueSet output = this.expandValueSetR5(theValidationSupportContext, input, codeSystemLoader, valueSetLoader, theWantSystem, theWantCode);
        return output;
    }

    @Nullable
    private org.hl7.fhir.r5.model.ValueSet expandValueSetDstu2(ValidationSupportContext theValidationSupportContext, ca.uhn.fhir.model.dstu2.resource.ValueSet theInput, @Nullable String theWantSystem, @Nullable String theWantCode) {
        IParser parserRi = FhirContext.forCached((FhirVersionEnum)FhirVersionEnum.DSTU2_HL7ORG).newJsonParser();
        IParser parserHapi = FhirContext.forCached((FhirVersionEnum)FhirVersionEnum.DSTU2).newJsonParser();
        Function<String, org.hl7.fhir.r5.model.CodeSystem> codeSystemLoader = t -> {
            ca.uhn.fhir.model.dstu2.resource.ValueSet codeSystem = theInput;
            org.hl7.fhir.r5.model.CodeSystem retVal = null;
            if (codeSystem != null) {
                retVal = new org.hl7.fhir.r5.model.CodeSystem();
                retVal.setUrl(codeSystem.getUrl());
                this.addCodesDstu2(codeSystem.getCodeSystem().getConcept(), retVal.getConcept());
            }
            return retVal;
        };
        Function<String, org.hl7.fhir.r5.model.ValueSet> valueSetLoader = t -> {
            ca.uhn.fhir.model.dstu2.resource.ValueSet valueSet = (ca.uhn.fhir.model.dstu2.resource.ValueSet)theValidationSupportContext.getRootValidationSupport().fetchValueSet(t);
            org.hl7.fhir.dstu2.model.ValueSet valueSetRi = (org.hl7.fhir.dstu2.model.ValueSet)parserRi.parseResource(org.hl7.fhir.dstu2.model.ValueSet.class, parserHapi.encodeResourceToString((IBaseResource)valueSet));
            return ValueSet10_50.convertValueSet((org.hl7.fhir.dstu2.model.ValueSet)valueSetRi);
        };
        org.hl7.fhir.dstu2.model.ValueSet valueSetRi = (org.hl7.fhir.dstu2.model.ValueSet)parserRi.parseResource(org.hl7.fhir.dstu2.model.ValueSet.class, parserHapi.encodeResourceToString((IBaseResource)theInput));
        org.hl7.fhir.r5.model.ValueSet input = ValueSet10_50.convertValueSet((org.hl7.fhir.dstu2.model.ValueSet)valueSetRi);
        org.hl7.fhir.r5.model.ValueSet output = this.expandValueSetR5(theValidationSupportContext, input, codeSystemLoader, valueSetLoader, theWantSystem, theWantCode);
        return output;
    }

    public boolean isCodeSystemSupported(ValidationSupportContext theValidationSupportContext, String theSystem) {
        IPrimitiveType content;
        if (StringUtils.isBlank((CharSequence)theSystem)) {
            return false;
        }
        IBaseResource cs = theValidationSupportContext.getRootValidationSupport().fetchCodeSystem(theSystem);
        if (!this.myCtx.getVersion().getVersion().isEqualOrNewerThan(FhirVersionEnum.DSTU2_1)) {
            return cs != null;
        }
        return cs != null && !"not-present".equals((content = (IPrimitiveType)this.getFhirContext().newTerser().getSingleValueOrNull((IBase)cs, "content", IPrimitiveType.class)).getValueAsString());
    }

    public boolean isValueSetSupported(ValidationSupportContext theValidationSupportContext, String theValueSetUrl) {
        return StringUtils.isNotBlank((CharSequence)theValueSetUrl) && theValidationSupportContext.getRootValidationSupport().fetchValueSet(theValueSetUrl) != null;
    }

    private void addCodesDstu2Hl7Org(List<ValueSet.ConceptDefinitionComponent> theSourceList, List<CodeSystem.ConceptDefinitionComponent> theTargetList) {
        for (ValueSet.ConceptDefinitionComponent nextSource : theSourceList) {
            CodeSystem.ConceptDefinitionComponent targetConcept = new CodeSystem.ConceptDefinitionComponent().setCode(nextSource.getCode()).setDisplay(nextSource.getDisplay());
            theTargetList.add(targetConcept);
            this.addCodesDstu2Hl7Org(nextSource.getConcept(), targetConcept.getConcept());
        }
    }

    private void addCodesDstu2(List<ValueSet.CodeSystemConcept> theSourceList, List<CodeSystem.ConceptDefinitionComponent> theTargetList) {
        for (ValueSet.CodeSystemConcept nextSource : theSourceList) {
            CodeSystem.ConceptDefinitionComponent targetConcept = new CodeSystem.ConceptDefinitionComponent().setCode(nextSource.getCode()).setDisplay(nextSource.getDisplay());
            theTargetList.add(targetConcept);
            this.addCodesDstu2(nextSource.getConcept(), targetConcept.getConcept());
        }
    }

    @Nullable
    private org.hl7.fhir.r5.model.ValueSet expandValueSetDstu3(ValidationSupportContext theValidationSupportContext, ValueSet theInput, @Nullable String theWantSystem, @Nullable String theWantCode) {
        Function<String, org.hl7.fhir.r5.model.CodeSystem> codeSystemLoader = t -> {
            org.hl7.fhir.dstu3.model.CodeSystem codeSystem = (org.hl7.fhir.dstu3.model.CodeSystem)theValidationSupportContext.getRootValidationSupport().fetchCodeSystem(t);
            return CodeSystem30_50.convertCodeSystem((org.hl7.fhir.dstu3.model.CodeSystem)codeSystem);
        };
        Function<String, org.hl7.fhir.r5.model.ValueSet> valueSetLoader = t -> {
            ValueSet valueSet = (ValueSet)theValidationSupportContext.getRootValidationSupport().fetchValueSet(t);
            return ValueSet30_50.convertValueSet((ValueSet)valueSet);
        };
        org.hl7.fhir.r5.model.ValueSet input = ValueSet30_50.convertValueSet((ValueSet)theInput);
        org.hl7.fhir.r5.model.ValueSet output = this.expandValueSetR5(theValidationSupportContext, input, codeSystemLoader, valueSetLoader, theWantSystem, theWantCode);
        return output;
    }

    @Nullable
    private org.hl7.fhir.r5.model.ValueSet expandValueSetR4(ValidationSupportContext theValidationSupportContext, org.hl7.fhir.r4.model.ValueSet theInput, @Nullable String theWantSystem, @Nullable String theWantCode) {
        Function<String, org.hl7.fhir.r5.model.CodeSystem> codeSystemLoader = t -> {
            CodeSystem codeSystem = (CodeSystem)theValidationSupportContext.getRootValidationSupport().fetchCodeSystem(t);
            return CodeSystem40_50.convertCodeSystem((CodeSystem)codeSystem);
        };
        Function<String, org.hl7.fhir.r5.model.ValueSet> valueSetLoader = t -> {
            org.hl7.fhir.r4.model.ValueSet valueSet = (org.hl7.fhir.r4.model.ValueSet)theValidationSupportContext.getRootValidationSupport().fetchValueSet(t);
            return ValueSet40_50.convertValueSet((org.hl7.fhir.r4.model.ValueSet)valueSet);
        };
        org.hl7.fhir.r5.model.ValueSet input = ValueSet40_50.convertValueSet((org.hl7.fhir.r4.model.ValueSet)theInput);
        org.hl7.fhir.r5.model.ValueSet output = this.expandValueSetR5(theValidationSupportContext, input, codeSystemLoader, valueSetLoader, theWantSystem, theWantCode);
        return output;
    }

    @Nullable
    private org.hl7.fhir.r5.model.ValueSet expandValueSetR5(ValidationSupportContext theValidationSupportContext, org.hl7.fhir.r5.model.ValueSet theInput) {
        Function<String, org.hl7.fhir.r5.model.CodeSystem> codeSystemLoader = t -> (org.hl7.fhir.r5.model.CodeSystem)theValidationSupportContext.getRootValidationSupport().fetchCodeSystem(t);
        Function<String, org.hl7.fhir.r5.model.ValueSet> valueSetLoader = t -> (org.hl7.fhir.r5.model.ValueSet)theValidationSupportContext.getRootValidationSupport().fetchValueSet(t);
        return this.expandValueSetR5(theValidationSupportContext, theInput, codeSystemLoader, valueSetLoader, null, null);
    }

    @Nullable
    private org.hl7.fhir.r5.model.ValueSet expandValueSetR5(ValidationSupportContext theValidationSupportContext, org.hl7.fhir.r5.model.ValueSet theInput, Function<String, org.hl7.fhir.r5.model.CodeSystem> theCodeSystemLoader, Function<String, org.hl7.fhir.r5.model.ValueSet> theValueSetLoader, @Nullable String theWantSystem, @Nullable String theWantCode) {
        HashSet<VersionIndependentConcept> concepts = new HashSet<VersionIndependentConcept>();
        try {
            this.expandValueSetR5IncludeOrExclude(theValidationSupportContext, concepts, theCodeSystemLoader, theValueSetLoader, theInput.getCompose().getInclude(), true, theWantSystem, theWantCode);
            this.expandValueSetR5IncludeOrExclude(theValidationSupportContext, concepts, theCodeSystemLoader, theValueSetLoader, theInput.getCompose().getExclude(), false, theWantSystem, theWantCode);
        }
        catch (ExpansionCouldNotBeCompletedInternallyException e) {
            return null;
        }
        org.hl7.fhir.r5.model.ValueSet retVal = new org.hl7.fhir.r5.model.ValueSet();
        for (VersionIndependentConcept next : concepts) {
            ValueSet.ValueSetExpansionContainsComponent contains = retVal.getExpansion().addContains();
            contains.setSystem(next.getSystem());
            contains.setCode(next.getCode());
            contains.setDisplay(next.getDisplay());
        }
        return retVal;
    }

    private void expandValueSetR5IncludeOrExclude(ValidationSupportContext theValidationSupportContext, Set<VersionIndependentConcept> theConcepts, Function<String, org.hl7.fhir.r5.model.CodeSystem> theCodeSystemLoader, Function<String, org.hl7.fhir.r5.model.ValueSet> theValueSetLoader, List<ValueSet.ConceptSetComponent> theComposeList, boolean theComposeListIsInclude, @Nullable String theWantSystem, @Nullable String theWantCode) throws ExpansionCouldNotBeCompletedInternallyException {
        for (ValueSet.ConceptSetComponent nextInclude : theComposeList) {
            ArrayList<VersionIndependentConcept> nextCodeList = new ArrayList<VersionIndependentConcept>();
            String system = nextInclude.getSystem();
            if (StringUtils.isNotBlank((CharSequence)system)) {
                if (theWantSystem != null && !theWantSystem.equals(system)) continue;
                org.hl7.fhir.r5.model.CodeSystem codeSystem = theCodeSystemLoader.apply(system);
                Set<String> wantCodes = nextInclude.getConcept().isEmpty() ? null : nextInclude.getConcept().stream().map(t -> t.getCode()).collect(Collectors.toSet());
                boolean ableToHandleCode = false;
                if (codeSystem == null || codeSystem.getContent() == CodeSystem.CodeSystemContentMode.NOTPRESENT) {
                    if (theWantCode != null) {
                        if (theValidationSupportContext.getRootValidationSupport().isCodeSystemSupported(theValidationSupportContext, system)) {
                            IValidationSupport.LookupCodeResult lookup = theValidationSupportContext.getRootValidationSupport().lookupCode(theValidationSupportContext, system, theWantCode);
                            if (lookup != null && lookup.isFound()) {
                                CodeSystem.ConceptDefinitionComponent conceptDefinition = new CodeSystem.ConceptDefinitionComponent().addConcept().setCode(theWantCode).setDisplay(lookup.getCodeDisplay());
                                List<CodeSystem.ConceptDefinitionComponent> codesList = Collections.singletonList(conceptDefinition);
                                this.addCodes(system, codesList, nextCodeList, wantCodes);
                                ableToHandleCode = true;
                            }
                        } else if (theComposeListIsInclude) {
                            for (ValueSet.ConceptSetComponent next : theComposeList) {
                                Optional<ValueSet.ConceptReferenceComponent> matchingEnumeratedConcept;
                                if (!Objects.equals(next.getSystem(), theWantSystem) || !(matchingEnumeratedConcept = next.getConcept().stream().filter(t -> Objects.equals(t.getCode(), theWantCode)).findFirst()).isPresent()) continue;
                                CodeSystem.ConceptDefinitionComponent conceptDefinition = new CodeSystem.ConceptDefinitionComponent().addConcept().setCode(theWantCode).setDisplay(matchingEnumeratedConcept.get().getDisplay());
                                List<CodeSystem.ConceptDefinitionComponent> codesList = Collections.singletonList(conceptDefinition);
                                this.addCodes(system, codesList, nextCodeList, wantCodes);
                                ableToHandleCode = true;
                                break;
                            }
                        }
                    }
                } else {
                    ableToHandleCode = true;
                }
                if (!ableToHandleCode) {
                    throw new ExpansionCouldNotBeCompletedInternallyException();
                }
                if (codeSystem != null && codeSystem.getContent() != CodeSystem.CodeSystemContentMode.NOTPRESENT) {
                    this.addCodes(system, codeSystem.getConcept(), nextCodeList, wantCodes);
                }
            }
            for (CanonicalType nextValueSetInclude : nextInclude.getValueSet()) {
                org.hl7.fhir.r5.model.ValueSet vs = theValueSetLoader.apply(nextValueSetInclude.getValueAsString());
                if (vs == null) continue;
                org.hl7.fhir.r5.model.ValueSet subExpansion = this.expandValueSetR5(theValidationSupportContext, vs, theCodeSystemLoader, theValueSetLoader, theWantSystem, theWantCode);
                if (subExpansion == null) {
                    throw new ExpansionCouldNotBeCompletedInternallyException();
                }
                for (ValueSet.ValueSetExpansionContainsComponent next : subExpansion.getExpansion().getContains()) {
                    nextCodeList.add(new VersionIndependentConcept(next.getSystem(), next.getCode(), next.getDisplay()));
                }
            }
            if (theComposeListIsInclude) {
                theConcepts.addAll(nextCodeList);
                continue;
            }
            theConcepts.removeAll(nextCodeList);
        }
    }

    private void addCodes(String theSystem, List<CodeSystem.ConceptDefinitionComponent> theSource, List<VersionIndependentConcept> theTarget, Set<String> theCodeFilter) {
        for (CodeSystem.ConceptDefinitionComponent next : theSource) {
            if (StringUtils.isNotBlank((CharSequence)next.getCode()) && (theCodeFilter == null || theCodeFilter.contains(next.getCode()))) {
                theTarget.add(new VersionIndependentConcept(theSystem, next.getCode(), next.getDisplay()));
            }
            this.addCodes(theSystem, next.getConcept(), theTarget, theCodeFilter);
        }
    }

    private static void flattenAndConvertCodesDstu2(List<ValueSet.ValueSetExpansionContainsComponent> theInput, List<VersionIndependentConcept> theVersionIndependentConcepts) {
        for (ValueSet.ValueSetExpansionContainsComponent next : theInput) {
            theVersionIndependentConcepts.add(new VersionIndependentConcept(next.getSystem(), next.getCode(), next.getDisplay()));
            InMemoryTerminologyServerValidationSupport.flattenAndConvertCodesDstu2(next.getContains(), theVersionIndependentConcepts);
        }
    }

    private static void flattenAndConvertCodesDstu3(List<ValueSet.ValueSetExpansionContainsComponent> theInput, List<VersionIndependentConcept> theVersionIndependentConcepts) {
        for (ValueSet.ValueSetExpansionContainsComponent next : theInput) {
            theVersionIndependentConcepts.add(new VersionIndependentConcept(next.getSystem(), next.getCode(), next.getDisplay()));
            InMemoryTerminologyServerValidationSupport.flattenAndConvertCodesDstu3(next.getContains(), theVersionIndependentConcepts);
        }
    }

    private static void flattenAndConvertCodesR4(List<ValueSet.ValueSetExpansionContainsComponent> theInput, List<VersionIndependentConcept> theVersionIndependentConcepts) {
        for (ValueSet.ValueSetExpansionContainsComponent next : theInput) {
            theVersionIndependentConcepts.add(new VersionIndependentConcept(next.getSystem(), next.getCode(), next.getDisplay()));
            InMemoryTerminologyServerValidationSupport.flattenAndConvertCodesR4(next.getContains(), theVersionIndependentConcepts);
        }
    }

    private static void flattenAndConvertCodesR5(List<ValueSet.ValueSetExpansionContainsComponent> theInput, List<VersionIndependentConcept> theVersionIndependentConcepts) {
        for (ValueSet.ValueSetExpansionContainsComponent next : theInput) {
            theVersionIndependentConcepts.add(new VersionIndependentConcept(next.getSystem(), next.getCode(), next.getDisplay()));
            InMemoryTerminologyServerValidationSupport.flattenAndConvertCodesR5(next.getContains(), theVersionIndependentConcepts);
        }
    }

    private static class ExpansionCouldNotBeCompletedInternallyException
    extends Exception {
        private ExpansionCouldNotBeCompletedInternallyException() {
        }
    }
}

