/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.common.hapi.validation.support;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.common.hapi.validation.support.BaseStaticResourceValidationSupport;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.ValueSet;

public class PrePopulatedValidationSupport
extends BaseStaticResourceValidationSupport
implements IValidationSupport {
    private final FhirContext myFhirContext;
    private final Map<String, IBaseResource> myCodeSystems;
    private final Map<String, IBaseResource> myStructureDefinitions;
    private final Map<String, IBaseResource> myValueSets;

    public PrePopulatedValidationSupport(FhirContext theContext) {
        this(theContext, new HashMap<String, IBaseResource>(), new HashMap<String, IBaseResource>(), new HashMap<String, IBaseResource>());
    }

    public PrePopulatedValidationSupport(FhirContext theFhirContext, Map<String, IBaseResource> theStructureDefinitions, Map<String, IBaseResource> theValueSets, Map<String, IBaseResource> theCodeSystems) {
        super(theFhirContext);
        Validate.notNull((Object)theFhirContext, (String)"theFhirContext must not be null", (Object[])new Object[0]);
        Validate.notNull(theStructureDefinitions, (String)"theStructureDefinitions must not be null", (Object[])new Object[0]);
        Validate.notNull(theValueSets, (String)"theValueSets must not be null", (Object[])new Object[0]);
        Validate.notNull(theCodeSystems, (String)"theCodeSystems must not be null", (Object[])new Object[0]);
        this.myFhirContext = theFhirContext;
        this.myStructureDefinitions = theStructureDefinitions;
        this.myValueSets = theValueSets;
        this.myCodeSystems = theCodeSystems;
    }

    public void addCodeSystem(IBaseResource theCodeSystem) {
        String url = this.processResourceAndReturnUrl(theCodeSystem, "CodeSystem");
        this.addToMap(theCodeSystem, this.myCodeSystems, url);
    }

    private String processResourceAndReturnUrl(IBaseResource theCodeSystem, String theResourceName) {
        Validate.notNull((Object)theCodeSystem, (String)("the" + theResourceName + " must not be null"), (Object[])new Object[0]);
        RuntimeResourceDefinition resourceDef = this.myFhirContext.getResourceDefinition(theCodeSystem);
        String actualResourceName = resourceDef.getName();
        Validate.isTrue((boolean)actualResourceName.equals(theResourceName), (String)("the" + theResourceName + " must be a " + theResourceName + " - Got: " + actualResourceName), (Object[])new Object[0]);
        Optional urlValue = resourceDef.getChildByName("url").getAccessor().getFirstValueOrNull((IBase)theCodeSystem);
        String url = urlValue.map(t -> ((IPrimitiveType)t).getValueAsString()).orElse(null);
        Validate.notNull((Object)url, (String)("the" + theResourceName + ".getUrl() must not return null"), (Object[])new Object[0]);
        Validate.notBlank((CharSequence)url, (String)("the" + theResourceName + ".getUrl() must return a value"), (Object[])new Object[0]);
        return url;
    }

    public void addStructureDefinition(IBaseResource theStructureDefinition) {
        String url = this.processResourceAndReturnUrl(theStructureDefinition, "StructureDefinition");
        this.addToMap(theStructureDefinition, this.myStructureDefinitions, url);
    }

    private <T extends IBaseResource> void addToMap(T theStructureDefinition, Map<String, T> map, String theUrl) {
        if (StringUtils.isNotBlank((CharSequence)theUrl)) {
            map.put(theUrl, theStructureDefinition);
            int lastSlashIdx = theUrl.lastIndexOf(47);
            if (lastSlashIdx != -1) {
                map.put(theUrl.substring(lastSlashIdx + 1), theStructureDefinition);
                int previousSlashIdx = theUrl.lastIndexOf(47, lastSlashIdx - 1);
                if (previousSlashIdx != -1) {
                    map.put(theUrl.substring(previousSlashIdx + 1), theStructureDefinition);
                }
            }
        }
    }

    public void addValueSet(ValueSet theValueSet) {
        String url = this.processResourceAndReturnUrl((IBaseResource)theValueSet, "ValueSet");
        this.addToMap((IBaseResource)theValueSet, (Map)this.myValueSets, url);
    }

    public List<IBaseResource> fetchAllConformanceResources() {
        ArrayList<IBaseResource> retVal = new ArrayList<IBaseResource>();
        retVal.addAll(this.myCodeSystems.values());
        retVal.addAll(this.myStructureDefinitions.values());
        retVal.addAll(this.myValueSets.values());
        return retVal;
    }

    public List<IBaseResource> fetchAllStructureDefinitions() {
        return PrePopulatedValidationSupport.toList(this.myStructureDefinitions);
    }

    public IBaseResource fetchCodeSystem(String theSystem) {
        return this.myCodeSystems.get(theSystem);
    }

    public IBaseResource fetchValueSet(String theUri) {
        return this.myValueSets.get(theUri);
    }

    public IBaseResource fetchStructureDefinition(String theUrl) {
        return this.myStructureDefinitions.get(theUrl);
    }

    public boolean isCodeSystemSupported(ValidationSupportContext theValidationSupportContext, String theSystem) {
        return this.myCodeSystems.containsKey(theSystem);
    }

    public boolean isValueSetSupported(ValidationSupportContext theValidationSupportContext, String theValueSetUrl) {
        return this.myValueSets.containsKey(theValueSetUrl);
    }
}

