/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.common.hapi.validation.validator;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.fhir.ucum.UcumService;
import org.hl7.fhir.common.hapi.validation.validator.ProfileKnowledgeWorkerR5;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.TerminologyServiceException;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r5.conformance.ProfileUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.ParserType;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.ValueSetExpander;
import org.hl7.fhir.r5.utils.IResourceValidator;
import org.hl7.fhir.utilities.TimeTracker;
import org.hl7.fhir.utilities.TranslationServices;
import org.hl7.fhir.utilities.i18n.I18nBase;
import org.hl7.fhir.utilities.npm.BasePackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionSpecificWorkerContextWrapper
extends I18nBase
implements IWorkerContext {
    public static final IVersionTypeConverter IDENTITY_VERSION_TYPE_CONVERTER = new VersionTypeConverterR5();
    private static final Logger ourLog = LoggerFactory.getLogger(VersionSpecificWorkerContextWrapper.class);
    private static final FhirContext ourR5Context = FhirContext.forR5();
    private final ValidationSupportContext myValidationSupportContext;
    private final IVersionTypeConverter myModelConverter;
    private final LoadingCache<ResourceKey, IBaseResource> myFetchResourceCache;
    private volatile List<StructureDefinition> myAllStructures;
    private Parameters myExpansionProfile;

    public VersionSpecificWorkerContextWrapper(ValidationSupportContext theValidationSupportContext, IVersionTypeConverter theModelConverter) {
        this.myValidationSupportContext = theValidationSupportContext;
        this.myModelConverter = theModelConverter;
        long timeoutMillis = 10000L;
        if (System.getProperties().containsKey("TEST_SYSTEM_PROP_VALIDATION_RESOURCE_CACHES_MS")) {
            timeoutMillis = Long.parseLong(System.getProperty("TEST_SYSTEM_PROP_VALIDATION_RESOURCE_CACHES_MS"));
        }
        this.myFetchResourceCache = Caffeine.newBuilder().expireAfterWrite(timeoutMillis, TimeUnit.MILLISECONDS).maximumSize(10000L).build(key -> {
            StructureDefinition canonicalSd;
            String fetchResourceName = key.getResourceName();
            if (this.myValidationSupportContext.getRootValidationSupport().getFhirContext().getVersion().getVersion() == FhirVersionEnum.DSTU2 && "CodeSystem".equals(fetchResourceName)) {
                fetchResourceName = "ValueSet";
            }
            Class fetchResourceType = this.myValidationSupportContext.getRootValidationSupport().getFhirContext().getResourceDefinition(fetchResourceName).getImplementingClass();
            IBaseResource fetched = this.myValidationSupportContext.getRootValidationSupport().fetchResource(fetchResourceType, key.getUri());
            if (fetched == null) {
                return null;
            }
            Resource canonical = this.myModelConverter.toCanonical(fetched);
            if (canonical instanceof StructureDefinition && (canonicalSd = (StructureDefinition)canonical).getSnapshot().isEmpty()) {
                ourLog.info("Generating snapshot for StructureDefinition: {}", (Object)canonicalSd.getUrl());
                fetched = this.myValidationSupportContext.getRootValidationSupport().generateSnapshot(theValidationSupportContext, fetched, "", null, "");
                Validate.isTrue((fetched != null ? 1 : 0) != 0, (String)"StructureDefinition %s has no snapshot, and no snapshot generator is configured", (Object[])new Object[]{key.getUri()});
                canonical = this.myModelConverter.toCanonical(fetched);
            }
            return canonical;
        });
        this.setValidationMessageLanguage(this.getLocale());
    }

    public List<CanonicalResource> allConformanceResources() {
        throw new UnsupportedOperationException();
    }

    public String getLinkForUrl(String corePath, String url) {
        throw new UnsupportedOperationException();
    }

    public Map<String, byte[]> getBinaries() {
        return null;
    }

    public int loadFromPackage(NpmPackage pi, IWorkerContext.IContextResourceLoader loader) throws FHIRException {
        throw new UnsupportedOperationException();
    }

    public int loadFromPackage(NpmPackage pi, IWorkerContext.IContextResourceLoader loader, String[] types) throws FHIRException {
        throw new UnsupportedOperationException();
    }

    public int loadFromPackageAndDependencies(NpmPackage pi, IWorkerContext.IContextResourceLoader loader, BasePackageCacheManager pcm) throws FHIRException {
        throw new UnsupportedOperationException();
    }

    public boolean hasPackage(String id, String ver) {
        throw new UnsupportedOperationException();
    }

    public int getClientRetryCount() {
        throw new UnsupportedOperationException();
    }

    public IWorkerContext setClientRetryCount(int value) {
        throw new UnsupportedOperationException();
    }

    public TimeTracker clock() {
        return null;
    }

    public void generateSnapshot(StructureDefinition input) throws FHIRException {
        if (input.hasSnapshot()) {
            return;
        }
        ProfileKnowledgeWorkerR5 profileKnowledgeProvider = new ProfileKnowledgeWorkerR5(ourR5Context);
        ArrayList messages = new ArrayList();
        StructureDefinition base = this.fetchResource(StructureDefinition.class, input.getBaseDefinition());
        if (base == null) {
            throw new PreconditionFailedException("Unknown base definition: " + input.getBaseDefinition());
        }
        new ProfileUtilities((IWorkerContext)this, messages, (ProfileUtilities.ProfileKnowledgeProvider)profileKnowledgeProvider).generateSnapshot(base, input, "", null, "");
    }

    public void generateSnapshot(StructureDefinition theStructureDefinition, boolean theB) {
    }

    public Parameters getExpansionParameters() {
        return this.myExpansionProfile;
    }

    public void setExpansionProfile(Parameters expParameters) {
        this.myExpansionProfile = expParameters;
    }

    public List<StructureDefinition> allStructures() {
        List<StructureDefinition> retVal = this.myAllStructures;
        if (retVal == null) {
            retVal = new ArrayList<StructureDefinition>();
            for (IBaseResource next : this.myValidationSupportContext.getRootValidationSupport().fetchAllStructureDefinitions()) {
                try {
                    Resource converted = this.myModelConverter.toCanonical(next);
                    retVal.add((StructureDefinition)converted);
                }
                catch (FHIRException e) {
                    throw new InternalErrorException((Throwable)e);
                }
            }
            this.myAllStructures = retVal;
        }
        return retVal;
    }

    public List<StructureDefinition> getStructures() {
        return this.allStructures();
    }

    public void cacheResource(Resource res) {
        throw new UnsupportedOperationException();
    }

    public void cacheResourceFromPackage(Resource res, IWorkerContext.PackageVersion packageDetails) throws FHIRException {
    }

    public void cachePackage(IWorkerContext.PackageVersion packageDetails, List<IWorkerContext.PackageVersion> dependencies) {
    }

    @Nonnull
    private IWorkerContext.ValidationResult convertValidationResult(@Nullable IValidationSupport.CodeValidationResult theResult) {
        IWorkerContext.ValidationResult retVal = null;
        if (theResult != null) {
            String code = theResult.getCode();
            String display = theResult.getDisplay();
            String issueSeverity = theResult.getSeverityCode();
            String message = theResult.getMessage();
            if (StringUtils.isNotBlank((CharSequence)code)) {
                retVal = new IWorkerContext.ValidationResult(new CodeSystem.ConceptDefinitionComponent().setCode(code).setDisplay(display));
            } else if (StringUtils.isNotBlank((CharSequence)issueSeverity)) {
                retVal = new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.fromCode((String)issueSeverity), message, ValueSetExpander.TerminologyServiceErrorClass.UNKNOWN);
            }
        }
        if (retVal == null) {
            retVal = new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, "Validation failed");
        }
        return retVal;
    }

    public ValueSetExpander.ValueSetExpansionOutcome expandVS(ValueSet source, boolean cacheOk, boolean Hierarchical) {
        IBaseResource convertedSource;
        try {
            convertedSource = this.myModelConverter.fromCanonical((Resource)source);
        }
        catch (FHIRException e) {
            throw new InternalErrorException((Throwable)e);
        }
        IValidationSupport.ValueSetExpansionOutcome expanded = this.myValidationSupportContext.getRootValidationSupport().expandValueSet(this.myValidationSupportContext, null, convertedSource);
        ValueSet convertedResult = null;
        if (expanded.getValueSet() != null) {
            try {
                convertedResult = (ValueSet)this.myModelConverter.toCanonical(expanded.getValueSet());
            }
            catch (FHIRException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        String error = expanded.getError();
        ValueSetExpander.TerminologyServiceErrorClass result = null;
        return new ValueSetExpander.ValueSetExpansionOutcome(convertedResult, error, result);
    }

    public ValueSetExpander.ValueSetExpansionOutcome expandVS(ElementDefinition.ElementDefinitionBindingComponent binding, boolean cacheOk, boolean Hierarchical) {
        throw new UnsupportedOperationException();
    }

    public ValueSetExpander.ValueSetExpansionOutcome expandVS(ValueSet.ConceptSetComponent inc, boolean heirarchical) throws TerminologyServiceException {
        throw new UnsupportedOperationException();
    }

    public Locale getLocale() {
        return this.myValidationSupportContext.getRootValidationSupport().getFhirContext().getLocalizer().getLocale();
    }

    public void setLocale(Locale locale) {
    }

    public CodeSystem fetchCodeSystem(String system) {
        IBaseResource fetched = this.myValidationSupportContext.getRootValidationSupport().fetchCodeSystem(system);
        if (fetched == null) {
            return null;
        }
        try {
            return (CodeSystem)this.myModelConverter.toCanonical(fetched);
        }
        catch (FHIRException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public <T extends Resource> T fetchResource(Class<T> class_, String uri) {
        if (StringUtils.isBlank((CharSequence)uri)) {
            return null;
        }
        ResourceKey key = new ResourceKey(class_.getSimpleName(), uri);
        Resource retVal = (Resource)this.myFetchResourceCache.get((Object)key);
        return (T)retVal;
    }

    public Resource fetchResourceById(String type, String uri) {
        throw new UnsupportedOperationException();
    }

    public <T extends Resource> T fetchResourceWithException(Class<T> class_, String uri) throws FHIRException {
        T retVal = this.fetchResource(class_, uri);
        if (retVal == null) {
            throw new FHIRException("Can not find resource of type " + class_.getSimpleName() + " with uri " + uri);
        }
        return retVal;
    }

    public <T extends Resource> T fetchResource(Class<T> class_, String uri, CanonicalResource canonicalForSource) {
        throw new UnsupportedOperationException();
    }

    public List<ConceptMap> findMapsForSource(String url) {
        throw new UnsupportedOperationException();
    }

    public String getAbbreviation(String name) {
        throw new UnsupportedOperationException();
    }

    public IParser getParser(ParserType type) {
        throw new UnsupportedOperationException();
    }

    public IParser getParser(String type) {
        throw new UnsupportedOperationException();
    }

    public List<String> getResourceNames() {
        return new ArrayList<String>(this.myValidationSupportContext.getRootValidationSupport().getFhirContext().getResourceTypes());
    }

    public Set<String> getResourceNamesAsSet() {
        return this.myValidationSupportContext.getRootValidationSupport().getFhirContext().getResourceTypes();
    }

    public StructureMap getTransform(String url) {
        throw new UnsupportedOperationException();
    }

    public String getOverrideVersionNs() {
        return null;
    }

    public void setOverrideVersionNs(String value) {
        throw new UnsupportedOperationException();
    }

    public StructureDefinition fetchTypeDefinition(String typeName) {
        return this.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + typeName);
    }

    public StructureDefinition fetchRawProfile(String url) {
        StructureDefinition retVal = this.fetchResource(StructureDefinition.class, url);
        if (retVal != null && retVal.getSnapshot().isEmpty()) {
            this.generateSnapshot(retVal);
        }
        return retVal;
    }

    public List<String> getTypeNames() {
        throw new UnsupportedOperationException();
    }

    public UcumService getUcumService() {
        throw new UnsupportedOperationException();
    }

    public void setUcumService(UcumService ucumService) {
        throw new UnsupportedOperationException();
    }

    public String getVersion() {
        return this.myValidationSupportContext.getRootValidationSupport().getFhirContext().getVersion().getVersion().getFhirVersionString();
    }

    public boolean hasCache() {
        throw new UnsupportedOperationException();
    }

    public <T extends Resource> boolean hasResource(Class<T> class_, String uri) {
        throw new UnsupportedOperationException();
    }

    public boolean isNoTerminologyServer() {
        return false;
    }

    public List<StructureMap> listTransforms() {
        throw new UnsupportedOperationException();
    }

    public IParser newJsonParser() {
        throw new UnsupportedOperationException();
    }

    public IResourceValidator newValidator() {
        throw new UnsupportedOperationException();
    }

    public IParser newXmlParser() {
        throw new UnsupportedOperationException();
    }

    public String oid2Uri(String code) {
        throw new UnsupportedOperationException();
    }

    public IWorkerContext.ILoggingService getLogger() {
        return null;
    }

    public void setLogger(IWorkerContext.ILoggingService logger) {
        throw new UnsupportedOperationException();
    }

    public boolean supportsSystem(String system) {
        return this.myValidationSupportContext.getRootValidationSupport().isCodeSystemSupported(this.myValidationSupportContext, system);
    }

    public TranslationServices translator() {
        throw new UnsupportedOperationException();
    }

    public IWorkerContext.ValidationResult validateCode(ValidationOptions theOptions, String system, String code, String display) {
        ConceptValidationOptions validationOptions = VersionSpecificWorkerContextWrapper.convertConceptValidationOptions(theOptions);
        return this.doValidation(null, validationOptions, system, code, display);
    }

    public IWorkerContext.ValidationResult validateCode(ValidationOptions theOptions, String theSystem, String theCode, String display, ValueSet theValueSet) {
        IBaseResource convertedVs = null;
        try {
            if (theValueSet != null) {
                convertedVs = this.myModelConverter.fromCanonical((Resource)theValueSet);
            }
        }
        catch (FHIRException e) {
            throw new InternalErrorException((Throwable)e);
        }
        ConceptValidationOptions validationOptions = VersionSpecificWorkerContextWrapper.convertConceptValidationOptions(theOptions);
        return this.doValidation(convertedVs, validationOptions, theSystem, theCode, display);
    }

    public IWorkerContext.ValidationResult validateCode(ValidationOptions theOptions, String code, ValueSet theValueSet) {
        IBaseResource convertedVs = null;
        try {
            if (theValueSet != null) {
                convertedVs = this.myModelConverter.fromCanonical((Resource)theValueSet);
            }
        }
        catch (FHIRException e) {
            throw new InternalErrorException((Throwable)e);
        }
        ConceptValidationOptions validationOptions = VersionSpecificWorkerContextWrapper.convertConceptValidationOptions(theOptions).setInferSystem(true);
        return this.doValidation(convertedVs, validationOptions, null, code, null);
    }

    public IWorkerContext.ValidationResult validateCode(ValidationOptions theOptions, Coding theCoding, ValueSet theValueSet) {
        IBaseResource convertedVs = null;
        try {
            if (theValueSet != null) {
                convertedVs = this.myModelConverter.fromCanonical((Resource)theValueSet);
            }
        }
        catch (FHIRException e) {
            throw new InternalErrorException((Throwable)e);
        }
        ConceptValidationOptions validationOptions = VersionSpecificWorkerContextWrapper.convertConceptValidationOptions(theOptions);
        String system = theCoding.getSystem();
        String code = theCoding.getCode();
        String display = theCoding.getDisplay();
        return this.doValidation(convertedVs, validationOptions, system, code, display);
    }

    public void validateCodeBatch(ValidationOptions options, List<? extends IWorkerContext.CodingValidationRequest> codes, ValueSet vs) {
        for (IWorkerContext.CodingValidationRequest codingValidationRequest : codes) {
            IWorkerContext.ValidationResult outcome = this.validateCode(options, codingValidationRequest.getCoding(), vs);
            codingValidationRequest.setResult(outcome);
        }
    }

    @Nonnull
    private IWorkerContext.ValidationResult doValidation(IBaseResource theValueSet, ConceptValidationOptions theValidationOptions, String theSystem, String theCode, String theDisplay) {
        IValidationSupport.CodeValidationResult result = theValueSet != null ? this.myValidationSupportContext.getRootValidationSupport().validateCodeInValueSet(this.myValidationSupportContext, theValidationOptions, theSystem, theCode, theDisplay, theValueSet) : this.myValidationSupportContext.getRootValidationSupport().validateCode(this.myValidationSupportContext, theValidationOptions, theSystem, theCode, theDisplay, null);
        return this.convertValidationResult(result);
    }

    public IWorkerContext.ValidationResult validateCode(ValidationOptions theOptions, CodeableConcept code, ValueSet theVs) {
        for (Coding next : code.getCoding()) {
            IWorkerContext.ValidationResult retVal = this.validateCode(theOptions, next, theVs);
            if (!retVal.isOk()) continue;
            return retVal;
        }
        return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, null);
    }

    public void invalidateCaches() {
        this.myFetchResourceCache.invalidateAll();
    }

    public static ConceptValidationOptions convertConceptValidationOptions(ValidationOptions theOptions) {
        ConceptValidationOptions retVal = new ConceptValidationOptions();
        if (theOptions.isGuessSystem()) {
            retVal = retVal.setInferSystem(true);
        }
        return retVal;
    }

    private static class VersionTypeConverterR5
    implements IVersionTypeConverter {
        private VersionTypeConverterR5() {
        }

        @Override
        public Resource toCanonical(IBaseResource theNonCanonical) {
            return (Resource)theNonCanonical;
        }

        @Override
        public IBaseResource fromCanonical(Resource theCanonical) {
            return theCanonical;
        }
    }

    private static class ResourceKey {
        private final int myHashCode;
        private final String myResourceName;
        private final String myUri;

        private ResourceKey(String theResourceName, String theUri) {
            this.myResourceName = theResourceName;
            this.myUri = theUri;
            this.myHashCode = new HashCodeBuilder(17, 37).append((Object)this.myResourceName).append((Object)this.myUri).toHashCode();
        }

        public boolean equals(Object theO) {
            if (this == theO) {
                return true;
            }
            if (theO == null || this.getClass() != theO.getClass()) {
                return false;
            }
            ResourceKey that = (ResourceKey)theO;
            return new EqualsBuilder().append((Object)this.myResourceName, (Object)that.myResourceName).append((Object)this.myUri, (Object)that.myUri).isEquals();
        }

        public String getResourceName() {
            return this.myResourceName;
        }

        public String getUri() {
            return this.myUri;
        }

        public int hashCode() {
            return this.myHashCode;
        }
    }

    public static interface IVersionTypeConverter {
        public Resource toCanonical(IBaseResource var1);

        public IBaseResource fromCanonical(Resource var1);
    }
}

