/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.common.hapi.validation.support;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.util.ClasspathUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.hl7.fhir.common.hapi.validation.support.PrePopulatedValidationSupport;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.utilities.npm.NpmPackage;

public class NpmPackageValidationSupport
extends PrePopulatedValidationSupport {
    public NpmPackageValidationSupport(@Nonnull FhirContext theFhirContext) {
        super(theFhirContext);
    }

    public void loadPackageFromClasspath(String theClasspath) throws IOException {
        try (InputStream is = ClasspathUtil.loadResourceAsStream((String)theClasspath);){
            NpmPackage pkg = NpmPackage.fromPackage((InputStream)is);
            if (pkg.getFolders().containsKey("package")) {
                NpmPackage.NpmPackageFolder packageFolder = (NpmPackage.NpmPackageFolder)pkg.getFolders().get("package");
                for (String nextFile : packageFolder.listFiles()) {
                    if (!nextFile.toLowerCase(Locale.US).endsWith(".json")) continue;
                    String input = new String((byte[])packageFolder.getContent().get(nextFile), StandardCharsets.UTF_8);
                    IBaseResource resource = this.getFhirContext().newJsonParser().parseResource(input);
                    super.addResource(resource);
                }
            }
        }
    }
}

