/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.common.hapi.validation.validator;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.validation.IInstanceValidatorModule;
import ca.uhn.fhir.validation.IValidationContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.common.hapi.validation.validator.BaseValidatorBridge;
import org.hl7.fhir.common.hapi.validation.validator.HapiToHl7OrgDstu2ValidatingSupportWrapper;
import org.hl7.fhir.common.hapi.validation.validator.ValidatorWrapper;
import org.hl7.fhir.common.hapi.validation.validator.VersionSpecificWorkerContextWrapper;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.PathEngineException;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.TypeDetails;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.utils.FHIRPathEngine;
import org.hl7.fhir.r5.utils.validation.IValidationPolicyAdvisor;
import org.hl7.fhir.r5.utils.validation.IValidatorResourceFetcher;
import org.hl7.fhir.r5.utils.validation.constants.BestPracticeWarningLevel;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class FhirInstanceValidator
extends BaseValidatorBridge
implements IInstanceValidatorModule {
    private boolean myAnyExtensionsAllowed = true;
    private BestPracticeWarningLevel myBestPracticeWarningLevel;
    private IValidationSupport myValidationSupport;
    private boolean noTerminologyChecks = false;
    private boolean noExtensibleWarnings = false;
    private boolean noBindingMsgSuppressed = false;
    private volatile VersionSpecificWorkerContextWrapper myWrappedWorkerContext;
    private boolean errorForUnknownProfiles = true;
    private boolean assumeValidRestReferences;
    private List<String> myExtensionDomains = Collections.emptyList();
    private IValidatorResourceFetcher validatorResourceFetcher;
    private IValidationPolicyAdvisor validatorPolicyAdvisor;

    public FhirInstanceValidator(FhirContext theContext) {
        this(theContext.getValidationSupport());
    }

    public FhirInstanceValidator(IValidationSupport theValidationSupport) {
        this.myValidationSupport = theValidationSupport.getFhirContext().getVersion().getVersion() == FhirVersionEnum.DSTU2 ? new HapiToHl7OrgDstu2ValidatingSupportWrapper(theValidationSupport) : theValidationSupport;
    }

    public FhirInstanceValidator setCustomExtensionDomains(List<String> extensionDomains) {
        this.myExtensionDomains = extensionDomains;
        return this;
    }

    public FhirInstanceValidator setCustomExtensionDomains(String ... extensionDomains) {
        this.myExtensionDomains = Arrays.asList(extensionDomains);
        return this;
    }

    public BestPracticeWarningLevel getBestPracticeWarningLevel() {
        return this.myBestPracticeWarningLevel;
    }

    public void setBestPracticeWarningLevel(BestPracticeWarningLevel theBestPracticeWarningLevel) {
        Validate.notNull((Object)theBestPracticeWarningLevel);
        this.myBestPracticeWarningLevel = theBestPracticeWarningLevel;
    }

    public IValidationSupport getValidationSupport() {
        return this.myValidationSupport;
    }

    public void setValidationSupport(IValidationSupport theValidationSupport) {
        this.myValidationSupport = theValidationSupport;
        this.myWrappedWorkerContext = null;
    }

    public boolean isAnyExtensionsAllowed() {
        return this.myAnyExtensionsAllowed;
    }

    public void setAnyExtensionsAllowed(boolean theAnyExtensionsAllowed) {
        this.myAnyExtensionsAllowed = theAnyExtensionsAllowed;
    }

    public boolean isErrorForUnknownProfiles() {
        return this.errorForUnknownProfiles;
    }

    public void setErrorForUnknownProfiles(boolean errorForUnknownProfiles) {
        this.errorForUnknownProfiles = errorForUnknownProfiles;
    }

    public boolean isNoTerminologyChecks() {
        return this.noTerminologyChecks;
    }

    public void setNoTerminologyChecks(boolean theNoTerminologyChecks) {
        this.noTerminologyChecks = theNoTerminologyChecks;
    }

    public boolean isNoExtensibleWarnings() {
        return this.noExtensibleWarnings;
    }

    public void setNoExtensibleWarnings(boolean theNoExtensibleWarnings) {
        this.noExtensibleWarnings = theNoExtensibleWarnings;
    }

    public boolean isNoBindingMsgSuppressed() {
        return this.noBindingMsgSuppressed;
    }

    public void setNoBindingMsgSuppressed(boolean theNoBindingMsgSuppressed) {
        this.noBindingMsgSuppressed = theNoBindingMsgSuppressed;
    }

    public List<String> getExtensionDomains() {
        return this.myExtensionDomains;
    }

    @Override
    protected List<ValidationMessage> validate(IValidationContext<?> theValidationCtx) {
        VersionSpecificWorkerContextWrapper wrappedWorkerContext = this.provideWorkerContext();
        return new ValidatorWrapper().setAnyExtensionsAllowed(this.isAnyExtensionsAllowed()).setBestPracticeWarningLevel(this.getBestPracticeWarningLevel()).setErrorForUnknownProfiles(this.isErrorForUnknownProfiles()).setExtensionDomains(this.getExtensionDomains()).setValidationPolicyAdvisor(this.validatorPolicyAdvisor).setNoTerminologyChecks(this.isNoTerminologyChecks()).setNoExtensibleWarnings(this.isNoExtensibleWarnings()).setNoBindingMsgSuppressed(this.isNoBindingMsgSuppressed()).setValidatorResourceFetcher(this.getValidatorResourceFetcher()).setAssumeValidRestReferences(this.isAssumeValidRestReferences()).validate(wrappedWorkerContext, theValidationCtx);
    }

    @Nonnull
    protected VersionSpecificWorkerContextWrapper provideWorkerContext() {
        VersionSpecificWorkerContextWrapper wrappedWorkerContext = this.myWrappedWorkerContext;
        if (wrappedWorkerContext == null) {
            wrappedWorkerContext = VersionSpecificWorkerContextWrapper.newVersionSpecificWorkerContextWrapper(this.myValidationSupport);
        }
        this.myWrappedWorkerContext = wrappedWorkerContext;
        return wrappedWorkerContext;
    }

    public IValidationPolicyAdvisor getValidatorPolicyAdvisor() {
        return this.validatorPolicyAdvisor;
    }

    public void setValidatorPolicyAdvisor(IValidationPolicyAdvisor validatorPolicyAdvisor) {
        this.validatorPolicyAdvisor = validatorPolicyAdvisor;
    }

    public IValidatorResourceFetcher getValidatorResourceFetcher() {
        return this.validatorResourceFetcher;
    }

    public void setValidatorResourceFetcher(IValidatorResourceFetcher validatorResourceFetcher) {
        this.validatorResourceFetcher = validatorResourceFetcher;
    }

    public boolean isAssumeValidRestReferences() {
        return this.assumeValidRestReferences;
    }

    public void setAssumeValidRestReferences(boolean assumeValidRestReferences) {
        this.assumeValidRestReferences = assumeValidRestReferences;
    }

    public void invalidateCaches() {
        this.myValidationSupport.invalidateCaches();
        if (this.myWrappedWorkerContext != null) {
            this.myWrappedWorkerContext.invalidateCaches();
        }
    }

    public static class NullEvaluationContext
    implements FHIRPathEngine.IEvaluationContext {
        public List<Base> resolveConstant(Object appContext, String name, boolean beforeContext) throws PathEngineException {
            return Collections.emptyList();
        }

        public TypeDetails resolveConstantType(Object appContext, String name) throws PathEngineException {
            return null;
        }

        public boolean log(String argument, List<Base> focus) {
            return false;
        }

        public FHIRPathEngine.IEvaluationContext.FunctionDetails resolveFunction(String functionName) {
            return null;
        }

        public TypeDetails checkFunction(Object appContext, String functionName, List<TypeDetails> parameters) throws PathEngineException {
            return null;
        }

        public List<Base> executeFunction(Object appContext, List<Base> focus, String functionName, List<List<Base>> parameters) {
            return null;
        }

        public Base resolveReference(Object appContext, String url, Base refContext) throws FHIRException {
            return null;
        }

        public boolean conformsToProfile(Object appContext, Base item, String url) throws FHIRException {
            return false;
        }

        public ValueSet resolveValueSet(Object appContext, String url) {
            return null;
        }
    }
}

