/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.common.hapi.validation.support;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.TranslateConceptResults;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.context.support.ValueSetExpansionOptions;
import ca.uhn.fhir.sl.cache.Cache;
import ca.uhn.fhir.sl.cache.CacheFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.hl7.fhir.common.hapi.validation.support.BaseValidationSupportWrapper;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingValidationSupport
extends BaseValidationSupportWrapper
implements IValidationSupport {
    private static final Logger ourLog = LoggerFactory.getLogger(CachingValidationSupport.class);
    public static final ValueSetExpansionOptions EMPTY_EXPANSION_OPTIONS = new ValueSetExpansionOptions();
    private final Cache<String, Object> myCache;
    private final Cache<String, Object> myValidateCodeCache;
    private final Cache<IValidationSupport.TranslateCodeRequest, Object> myTranslateCodeCache;
    private final Cache<String, Object> myLookupCodeCache;
    private final ThreadPoolExecutor myBackgroundExecutor;
    private final Map<Object, Object> myNonExpiringCache;
    private final Cache<String, Object> myExpandValueSetCache;
    private final boolean myIsEnabledValidationForCodingsLogicalAnd;

    public CachingValidationSupport(IValidationSupport theWrap) {
        this(theWrap, CacheTimeouts.defaultValues(), false);
    }

    public CachingValidationSupport(IValidationSupport theWrap, boolean theIsEnabledValidationForCodingsLogicalAnd) {
        this(theWrap, CacheTimeouts.defaultValues(), theIsEnabledValidationForCodingsLogicalAnd);
    }

    public CachingValidationSupport(IValidationSupport theWrap, CacheTimeouts theCacheTimeouts) {
        this(theWrap, theCacheTimeouts, false);
    }

    public CachingValidationSupport(IValidationSupport theWrap, CacheTimeouts theCacheTimeouts, boolean theIsEnabledValidationForCodingsLogicalAnd) {
        super(theWrap.getFhirContext(), theWrap);
        this.myExpandValueSetCache = CacheFactory.build((long)theCacheTimeouts.getExpandValueSetMillis(), (long)100L);
        this.myValidateCodeCache = CacheFactory.build((long)theCacheTimeouts.getValidateCodeMillis(), (long)5000L);
        this.myLookupCodeCache = CacheFactory.build((long)theCacheTimeouts.getLookupCodeMillis(), (long)5000L);
        this.myTranslateCodeCache = CacheFactory.build((long)theCacheTimeouts.getTranslateCodeMillis(), (long)5000L);
        this.myCache = CacheFactory.build((long)theCacheTimeouts.getMiscMillis(), (long)5000L);
        this.myNonExpiringCache = Collections.synchronizedMap(new HashMap());
        LinkedBlockingQueue<Runnable> executorQueue = new LinkedBlockingQueue<Runnable>(1000);
        BasicThreadFactory threadFactory = new BasicThreadFactory.Builder().namingPattern("CachingValidationSupport-%d").daemon(false).priority(5).build();
        this.myBackgroundExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, executorQueue, (ThreadFactory)threadFactory, new ThreadPoolExecutor.DiscardPolicy());
        this.myIsEnabledValidationForCodingsLogicalAnd = theIsEnabledValidationForCodingsLogicalAnd;
    }

    @Override
    public List<IBaseResource> fetchAllConformanceResources() {
        String key = "fetchAllConformanceResources";
        return this.loadFromCacheWithAsyncRefresh(this.myCache, key, t -> super.fetchAllConformanceResources());
    }

    @Override
    public <T extends IBaseResource> List<T> fetchAllStructureDefinitions() {
        String key = "fetchAllStructureDefinitions";
        return this.loadFromCacheWithAsyncRefresh(this.myCache, key, t -> super.fetchAllStructureDefinitions());
    }

    @Override
    @Nullable
    public <T extends IBaseResource> List<T> fetchAllSearchParameters() {
        String key = "fetchAllSearchParameters";
        return this.loadFromCacheWithAsyncRefresh(this.myCache, key, t -> super.fetchAllSearchParameters());
    }

    @Override
    public <T extends IBaseResource> List<T> fetchAllNonBaseStructureDefinitions() {
        String key = "fetchAllNonBaseStructureDefinitions";
        return this.loadFromCacheWithAsyncRefresh(this.myCache, key, t -> super.fetchAllNonBaseStructureDefinitions());
    }

    @Override
    public IBaseResource fetchCodeSystem(String theSystem) {
        return this.loadFromCache(this.myCache, "fetchCodeSystem " + theSystem, t -> super.fetchCodeSystem(theSystem));
    }

    @Override
    public IBaseResource fetchValueSet(String theUri) {
        return this.loadFromCache(this.myCache, "fetchValueSet " + theUri, t -> super.fetchValueSet(theUri));
    }

    @Override
    public IBaseResource fetchStructureDefinition(String theUrl) {
        return this.loadFromCache(this.myCache, "fetchStructureDefinition " + theUrl, t -> super.fetchStructureDefinition(theUrl));
    }

    @Override
    public byte[] fetchBinary(String theBinaryKey) {
        return this.loadFromCache(this.myCache, "fetchBinary " + theBinaryKey, t -> super.fetchBinary(theBinaryKey));
    }

    @Override
    public <T extends IBaseResource> T fetchResource(@Nullable Class<T> theClass, String theUri) {
        return (T)this.loadFromCache(this.myCache, "fetchResource " + theClass + " " + theUri, t -> super.fetchResource(theClass, theUri));
    }

    @Override
    public boolean isCodeSystemSupported(ValidationSupportContext theValidationSupportContext, String theSystem) {
        String key = "isCodeSystemSupported " + theSystem;
        Boolean retVal = this.loadFromCacheReentrantSafe(this.myCache, key, t -> super.isCodeSystemSupported(theValidationSupportContext, theSystem));
        assert (retVal != null);
        return retVal;
    }

    @Override
    public IValidationSupport.ValueSetExpansionOutcome expandValueSet(ValidationSupportContext theValidationSupportContext, ValueSetExpansionOptions theExpansionOptions, @Nonnull IBaseResource theValueSetToExpand) {
        if (!theValueSetToExpand.getIdElement().hasIdPart()) {
            return super.expandValueSet(theValidationSupportContext, theExpansionOptions, theValueSetToExpand);
        }
        ValueSetExpansionOptions expansionOptions = (ValueSetExpansionOptions)ObjectUtils.defaultIfNull((Object)theExpansionOptions, (Object)EMPTY_EXPANSION_OPTIONS);
        String key = "expandValueSet " + theValueSetToExpand.getIdElement().getValue() + " " + expansionOptions.isIncludeHierarchy() + " " + expansionOptions.getFilter() + " " + expansionOptions.getOffset() + " " + expansionOptions.getCount();
        return this.loadFromCache(this.myExpandValueSetCache, key, t -> super.expandValueSet(theValidationSupportContext, theExpansionOptions, theValueSetToExpand));
    }

    @Override
    public IValidationSupport.CodeValidationResult validateCode(@Nonnull ValidationSupportContext theValidationSupportContext, @Nonnull ConceptValidationOptions theOptions, String theCodeSystem, String theCode, String theDisplay, String theValueSetUrl) {
        String key = "validateCode " + theCodeSystem + " " + theCode + " " + StringUtils.defaultString((String)theDisplay) + " " + (String)StringUtils.defaultIfBlank((CharSequence)theValueSetUrl, (CharSequence)"NO_VS");
        return this.loadFromCache(this.myValidateCodeCache, key, t -> super.validateCode(theValidationSupportContext, theOptions, theCodeSystem, theCode, theDisplay, theValueSetUrl));
    }

    @Override
    public IValidationSupport.LookupCodeResult lookupCode(ValidationSupportContext theValidationSupportContext, String theSystem, String theCode, String theDisplayLanguage) {
        String key = "lookupCode " + theSystem + " " + theCode + " " + (String)StringUtils.defaultIfBlank((CharSequence)theDisplayLanguage, (CharSequence)"NO_LANG");
        return this.loadFromCache(this.myLookupCodeCache, key, t -> super.lookupCode(theValidationSupportContext, theSystem, theCode, theDisplayLanguage));
    }

    @Override
    public IValidationSupport.CodeValidationResult validateCodeInValueSet(ValidationSupportContext theValidationSupportContext, ConceptValidationOptions theValidationOptions, String theCodeSystem, String theCode, String theDisplay, @Nonnull IBaseResource theValueSet) {
        BaseRuntimeChildDefinition urlChild = this.myCtx.getResourceDefinition(theValueSet).getChildByName("url");
        Optional<String> valueSetUrl = urlChild.getAccessor().getValues((IBase)theValueSet).stream().map(t -> ((IPrimitiveType)t).getValueAsString()).filter(t -> StringUtils.isNotBlank((CharSequence)t)).findFirst();
        if (valueSetUrl.isPresent()) {
            String key = "validateCodeInValueSet " + theValidationOptions.toString() + " " + StringUtils.defaultString((String)theCodeSystem) + " " + StringUtils.defaultString((String)theCode) + " " + StringUtils.defaultString((String)theDisplay) + " " + valueSetUrl.get();
            return this.loadFromCache(this.myValidateCodeCache, key, t -> super.validateCodeInValueSet(theValidationSupportContext, theValidationOptions, theCodeSystem, theCode, theDisplay, theValueSet));
        }
        return super.validateCodeInValueSet(theValidationSupportContext, theValidationOptions, theCodeSystem, theCode, theDisplay, theValueSet);
    }

    @Override
    public TranslateConceptResults translateConcept(IValidationSupport.TranslateCodeRequest theRequest) {
        return this.loadFromCache(this.myTranslateCodeCache, theRequest, k -> super.translateConcept(theRequest));
    }

    @Nullable
    private <S, T> T loadFromCache(Cache<S, Object> theCache, S theKey, Function<S, T> theLoader) {
        ourLog.trace("Fetching from cache: {}", theKey);
        Function<Object, Optional> loaderWrapper = key -> Optional.ofNullable(theLoader.apply(theKey));
        Optional result = (Optional)theCache.get(theKey, loaderWrapper);
        assert (result != null);
        return result.orElse(null);
    }

    @Nullable
    private <S, T> T loadFromCacheReentrantSafe(Cache<S, Object> theCache, S theKey, Function<S, T> theLoader) {
        ourLog.trace("Reentrant fetch from cache: {}", theKey);
        Optional result = (Optional)theCache.getIfPresent(theKey);
        if (result != null && result.isPresent()) {
            return result.get();
        }
        T value = theLoader.apply(theKey);
        assert (value != null);
        theCache.put(theKey, Optional.of(value));
        return value;
    }

    private <S, T> T loadFromCacheWithAsyncRefresh(Cache<S, Object> theCache, S theKey, Function<S, T> theLoader) {
        Object retVal = theCache.getIfPresent(theKey);
        if (retVal == null && (retVal = this.myNonExpiringCache.get(theKey)) != null) {
            Runnable loaderTask = () -> {
                Object loadedItem = this.loadFromCache(theCache, theKey, theLoader);
                this.myNonExpiringCache.put(theKey, loadedItem);
            };
            this.myBackgroundExecutor.execute(loaderTask);
            return (T)retVal;
        }
        retVal = this.loadFromCache(theCache, theKey, theLoader);
        this.myNonExpiringCache.put(theKey, retVal);
        return (T)retVal;
    }

    public void invalidateCaches() {
        this.myExpandValueSetCache.invalidateAll();
        this.myLookupCodeCache.invalidateAll();
        this.myCache.invalidateAll();
        this.myValidateCodeCache.invalidateAll();
        this.myNonExpiringCache.clear();
    }

    public boolean isEnabledValidationForCodingsLogicalAnd() {
        return this.myIsEnabledValidationForCodingsLogicalAnd;
    }

    public static class CacheTimeouts {
        private long myTranslateCodeMillis;
        private long myLookupCodeMillis;
        private long myValidateCodeMillis;
        private long myMiscMillis;
        private long myExpandValueSetMillis;

        public long getExpandValueSetMillis() {
            return this.myExpandValueSetMillis;
        }

        public CacheTimeouts setExpandValueSetMillis(long theExpandValueSetMillis) {
            this.myExpandValueSetMillis = theExpandValueSetMillis;
            return this;
        }

        public long getTranslateCodeMillis() {
            return this.myTranslateCodeMillis;
        }

        public CacheTimeouts setTranslateCodeMillis(long theTranslateCodeMillis) {
            this.myTranslateCodeMillis = theTranslateCodeMillis;
            return this;
        }

        public long getLookupCodeMillis() {
            return this.myLookupCodeMillis;
        }

        public CacheTimeouts setLookupCodeMillis(long theLookupCodeMillis) {
            this.myLookupCodeMillis = theLookupCodeMillis;
            return this;
        }

        public long getValidateCodeMillis() {
            return this.myValidateCodeMillis;
        }

        public CacheTimeouts setValidateCodeMillis(long theValidateCodeMillis) {
            this.myValidateCodeMillis = theValidateCodeMillis;
            return this;
        }

        public long getMiscMillis() {
            return this.myMiscMillis;
        }

        public CacheTimeouts setMiscMillis(long theMiscMillis) {
            this.myMiscMillis = theMiscMillis;
            return this;
        }

        public static CacheTimeouts defaultValues() {
            return new CacheTimeouts().setLookupCodeMillis(600000L).setExpandValueSetMillis(60000L).setTranslateCodeMillis(600000L).setValidateCodeMillis(600000L).setMiscMillis(600000L);
        }
    }
}

