/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.common.hapi.validation.support;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.context.support.ValueSetExpansionOptions;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.dstu2.resource.ValueSet;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.util.FhirVersionIndependentConcept;
import ca.uhn.hapi.converters.canonical.VersionCanonicalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.common.hapi.validation.support.CommonCodeSystemsTerminologyService;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_10_50;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_30_50;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_40_50;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_43_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_10_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_30_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_40_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_43_50;
import org.hl7.fhir.dstu2.model.ValueSet;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.ValueSet;
import org.hl7.fhir.r4b.model.CodeSystem;
import org.hl7.fhir.r4b.model.ValueSet;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class InMemoryTerminologyServerValidationSupport
implements IValidationSupport {
    private static final String OUR_PIPE_CHARACTER = "|";
    private final FhirContext myCtx;
    private final VersionCanonicalizer myVersionCanonicalizer;

    public InMemoryTerminologyServerValidationSupport(FhirContext theCtx) {
        Validate.notNull((Object)theCtx, (String)"theCtx must not be null", (Object[])new Object[0]);
        this.myCtx = theCtx;
        this.myVersionCanonicalizer = new VersionCanonicalizer(theCtx);
    }

    public FhirContext getFhirContext() {
        return this.myCtx;
    }

    public IValidationSupport.ValueSetExpansionOutcome expandValueSet(ValidationSupportContext theValidationSupportContext, ValueSetExpansionOptions theExpansionOptions, @Nonnull IBaseResource theValueSetToExpand) {
        return this.expandValueSet(theValidationSupportContext, theValueSetToExpand, null, null);
    }

    private IValidationSupport.ValueSetExpansionOutcome expandValueSet(ValidationSupportContext theValidationSupportContext, IBaseResource theValueSetToExpand, String theWantSystemAndVersion, String theWantCode) {
        org.hl7.fhir.r5.model.ValueSet expansion;
        org.hl7.fhir.r5.model.ValueSet expansionR5;
        try {
            expansionR5 = this.expandValueSetToCanonical(theValidationSupportContext, theValueSetToExpand, theWantSystemAndVersion, theWantCode);
        }
        catch (ExpansionCouldNotBeCompletedInternallyException e) {
            return new IValidationSupport.ValueSetExpansionOutcome(e.getMessage());
        }
        if (expansionR5 == null) {
            return null;
        }
        switch (this.myCtx.getVersion().getVersion()) {
            case DSTU2: {
                org.hl7.fhir.r4.model.ValueSet expansionR4 = (org.hl7.fhir.r4.model.ValueSet)VersionConvertorFactory_40_50.convertResource((Resource)expansionR5, (BaseAdvisor_40_50)new BaseAdvisor_40_50(Boolean.valueOf(false)));
                expansion = this.myVersionCanonicalizer.valueSetFromCanonical(expansionR4);
                break;
            }
            case DSTU2_HL7ORG: {
                expansion = VersionConvertorFactory_10_50.convertResource((Resource)expansionR5, (BaseAdvisor_10_50)new BaseAdvisor_10_50(Boolean.valueOf(false)));
                break;
            }
            case DSTU3: {
                expansion = VersionConvertorFactory_30_50.convertResource((Resource)expansionR5, (BaseAdvisor_30_50)new BaseAdvisor_30_50(Boolean.valueOf(false)));
                break;
            }
            case R4: {
                expansion = VersionConvertorFactory_40_50.convertResource((Resource)expansionR5, (BaseAdvisor_40_50)new BaseAdvisor_40_50(Boolean.valueOf(false)));
                break;
            }
            case R4B: {
                expansion = VersionConvertorFactory_43_50.convertResource((Resource)expansionR5, (BaseAdvisor_43_50)new BaseAdvisor_43_50(Boolean.valueOf(false)));
                break;
            }
            case R5: {
                expansion = expansionR5;
                break;
            }
            default: {
                throw new IllegalArgumentException(Msg.code((int)697) + "Can not handle version: " + this.myCtx.getVersion().getVersion());
            }
        }
        return new IValidationSupport.ValueSetExpansionOutcome((IBaseResource)expansion);
    }

    private org.hl7.fhir.r5.model.ValueSet expandValueSetToCanonical(ValidationSupportContext theValidationSupportContext, IBaseResource theValueSetToExpand, @Nullable String theWantSystemUrlAndVersion, @Nullable String theWantCode) throws ExpansionCouldNotBeCompletedInternallyException {
        org.hl7.fhir.r5.model.ValueSet expansionR5;
        switch (CommonCodeSystemsTerminologyService.getFhirVersionEnum(theValidationSupportContext.getRootValidationSupport().getFhirContext(), theValueSetToExpand)) {
            case DSTU2: {
                expansionR5 = this.expandValueSetDstu2(theValidationSupportContext, (ca.uhn.fhir.model.dstu2.resource.ValueSet)theValueSetToExpand, theWantSystemUrlAndVersion, theWantCode);
                break;
            }
            case DSTU2_HL7ORG: {
                expansionR5 = this.expandValueSetDstu2Hl7Org(theValidationSupportContext, (org.hl7.fhir.dstu2.model.ValueSet)theValueSetToExpand, theWantSystemUrlAndVersion, theWantCode);
                break;
            }
            case DSTU3: {
                expansionR5 = this.expandValueSetDstu3(theValidationSupportContext, (ValueSet)theValueSetToExpand, theWantSystemUrlAndVersion, theWantCode);
                break;
            }
            case R4: {
                expansionR5 = this.expandValueSetR4(theValidationSupportContext, (org.hl7.fhir.r4.model.ValueSet)theValueSetToExpand, theWantSystemUrlAndVersion, theWantCode);
                break;
            }
            case R4B: {
                expansionR5 = this.expandValueSetR4B(theValidationSupportContext, (org.hl7.fhir.r4b.model.ValueSet)theValueSetToExpand, theWantSystemUrlAndVersion, theWantCode);
                break;
            }
            case R5: {
                expansionR5 = this.expandValueSetR5(theValidationSupportContext, (org.hl7.fhir.r5.model.ValueSet)theValueSetToExpand, theWantSystemUrlAndVersion, theWantCode);
                break;
            }
            default: {
                throw new IllegalArgumentException(Msg.code((int)698) + "Can not handle version: " + this.myCtx.getVersion().getVersion());
            }
        }
        return expansionR5;
    }

    public IValidationSupport.CodeValidationResult validateCodeInValueSet(ValidationSupportContext theValidationSupportContext, ConceptValidationOptions theOptions, String theCodeSystemUrlAndVersion, String theCode, String theDisplay, @Nonnull IBaseResource theValueSet) {
        org.hl7.fhir.r5.model.ValueSet expansion;
        String vsUrl = CommonCodeSystemsTerminologyService.getValueSetUrl(this.getFhirContext(), theValueSet);
        try {
            expansion = this.expandValueSetToCanonical(theValidationSupportContext, theValueSet, theCodeSystemUrlAndVersion, theCode);
        }
        catch (ExpansionCouldNotBeCompletedInternallyException e) {
            IValidationSupport.CodeValidationResult codeValidationResult = new IValidationSupport.CodeValidationResult();
            codeValidationResult.setSeverityCode("error");
            String msg = "Failed to expand ValueSet '" + vsUrl + "' (in-memory). Could not validate code " + theCodeSystemUrlAndVersion + "#" + theCode;
            if (e.getMessage() != null) {
                msg = msg + ". Error was: " + e.getMessage();
            }
            codeValidationResult.setMessage(msg);
            return codeValidationResult;
        }
        if (expansion == null) {
            return null;
        }
        return this.validateCodeInExpandedValueSet(theValidationSupportContext, theOptions, theCodeSystemUrlAndVersion, theCode, theDisplay, (IBaseResource)expansion, vsUrl);
    }

    @Nullable
    public IValidationSupport.CodeValidationResult validateCode(@Nonnull ValidationSupportContext theValidationSupportContext, @Nonnull ConceptValidationOptions theOptions, String theCodeSystem, String theCode, String theDisplay, String theValueSetUrl) {
        IValidationSupport.ValueSetExpansionOutcome valueSetExpansionOutcome;
        IBaseResource vs;
        if (StringUtils.isNotBlank((CharSequence)theValueSetUrl)) {
            vs = theValidationSupportContext.getRootValidationSupport().fetchValueSet(theValueSetUrl);
            if (vs == null) {
                return null;
            }
        } else {
            String codeSystemUrl;
            String codeSystemVersion = null;
            int codeSystemVersionIndex = theCodeSystem.indexOf(OUR_PIPE_CHARACTER);
            if (codeSystemVersionIndex > -1) {
                codeSystemUrl = theCodeSystem.substring(0, codeSystemVersionIndex);
                codeSystemVersion = theCodeSystem.substring(codeSystemVersionIndex + 1);
            } else {
                codeSystemUrl = theCodeSystem;
            }
            switch (this.myCtx.getVersion().getVersion()) {
                case DSTU2: 
                case DSTU2_HL7ORG: {
                    vs = new org.hl7.fhir.dstu2.model.ValueSet().setCompose(new ValueSet.ValueSetComposeComponent().addInclude(new ValueSet.ConceptSetComponent().setSystem(theCodeSystem)));
                    break;
                }
                case DSTU3: {
                    if (codeSystemVersion != null) {
                        vs = new ValueSet().setCompose(new ValueSet.ValueSetComposeComponent().addInclude(new ValueSet.ConceptSetComponent().setSystem(codeSystemUrl).setVersion(codeSystemVersion)));
                        break;
                    }
                    vs = new ValueSet().setCompose(new ValueSet.ValueSetComposeComponent().addInclude(new ValueSet.ConceptSetComponent().setSystem(theCodeSystem)));
                    break;
                }
                case R4: {
                    if (codeSystemVersion != null) {
                        vs = new org.hl7.fhir.r4.model.ValueSet().setCompose(new ValueSet.ValueSetComposeComponent().addInclude(new ValueSet.ConceptSetComponent().setSystem(codeSystemUrl).setVersion(codeSystemVersion)));
                        break;
                    }
                    vs = new org.hl7.fhir.r4.model.ValueSet().setCompose(new ValueSet.ValueSetComposeComponent().addInclude(new ValueSet.ConceptSetComponent().setSystem(theCodeSystem)));
                    break;
                }
                case R4B: {
                    if (codeSystemVersion != null) {
                        vs = new org.hl7.fhir.r4b.model.ValueSet().setCompose(new ValueSet.ValueSetComposeComponent().addInclude(new ValueSet.ConceptSetComponent().setSystem(codeSystemUrl).setVersion(codeSystemVersion)));
                        break;
                    }
                    vs = new org.hl7.fhir.r4b.model.ValueSet().setCompose(new ValueSet.ValueSetComposeComponent().addInclude(new ValueSet.ConceptSetComponent().setSystem(theCodeSystem)));
                    break;
                }
                case R5: {
                    if (codeSystemVersion != null) {
                        vs = new org.hl7.fhir.r5.model.ValueSet().setCompose(new ValueSet.ValueSetComposeComponent().addInclude(new ValueSet.ConceptSetComponent().setSystem(codeSystemUrl).setVersion(codeSystemVersion)));
                        break;
                    }
                    vs = new org.hl7.fhir.r5.model.ValueSet().setCompose(new ValueSet.ValueSetComposeComponent().addInclude(new ValueSet.ConceptSetComponent().setSystem(theCodeSystem)));
                    break;
                }
                default: {
                    throw new IllegalArgumentException(Msg.code((int)699) + "Can not handle version: " + this.myCtx.getVersion().getVersion());
                }
            }
        }
        if ((valueSetExpansionOutcome = this.expandValueSet(theValidationSupportContext, vs, theCodeSystem, theCode)) == null) {
            return null;
        }
        if (valueSetExpansionOutcome.getError() != null) {
            return new IValidationSupport.CodeValidationResult().setSeverity(IValidationSupport.IssueSeverity.ERROR).setMessage(valueSetExpansionOutcome.getError());
        }
        IBaseResource expansion = valueSetExpansionOutcome.getValueSet();
        return this.validateCodeInExpandedValueSet(theValidationSupportContext, theOptions, theCodeSystem, theCode, theDisplay, expansion, theValueSetUrl);
    }

    private IValidationSupport.CodeValidationResult validateCodeInExpandedValueSet(ValidationSupportContext theValidationSupportContext, ConceptValidationOptions theOptions, String theCodeSystemUrlAndVersionToValidate, String theCodeToValidate, String theDisplayToValidate, IBaseResource theExpansion, String theValueSetUrl) {
        String message;
        ValidationMessage.IssueSeverity severity;
        assert (theExpansion != null);
        boolean caseSensitive = true;
        IBaseResource codeSystemToValidateResource = null;
        if (!theOptions.isInferSystem() && StringUtils.isNotBlank((CharSequence)theCodeSystemUrlAndVersionToValidate)) {
            codeSystemToValidateResource = theValidationSupportContext.getRootValidationSupport().fetchCodeSystem(theCodeSystemUrlAndVersionToValidate);
        }
        ArrayList<FhirVersionIndependentConcept> codes = new ArrayList<FhirVersionIndependentConcept>();
        switch (CommonCodeSystemsTerminologyService.getFhirVersionEnum(theValidationSupportContext.getRootValidationSupport().getFhirContext(), theExpansion)) {
            case DSTU2: {
                ca.uhn.fhir.model.dstu2.resource.ValueSet expansionVs = (ca.uhn.fhir.model.dstu2.resource.ValueSet)theExpansion;
                List contains = expansionVs.getExpansion().getContains();
                InMemoryTerminologyServerValidationSupport.flattenAndConvertCodesDstu2(contains, codes);
                break;
            }
            case DSTU2_HL7ORG: {
                ca.uhn.fhir.model.dstu2.resource.ValueSet expansionVs = (org.hl7.fhir.dstu2.model.ValueSet)theExpansion;
                List contains = expansionVs.getExpansion().getContains();
                InMemoryTerminologyServerValidationSupport.flattenAndConvertCodesDstu2Hl7Org(contains, codes);
                break;
            }
            case DSTU3: {
                ca.uhn.fhir.model.dstu2.resource.ValueSet expansionVs = (ValueSet)theExpansion;
                List contains = expansionVs.getExpansion().getContains();
                InMemoryTerminologyServerValidationSupport.flattenAndConvertCodesDstu3(contains, codes);
                break;
            }
            case R4: {
                ca.uhn.fhir.model.dstu2.resource.ValueSet expansionVs = (org.hl7.fhir.r4.model.ValueSet)theExpansion;
                List contains = expansionVs.getExpansion().getContains();
                InMemoryTerminologyServerValidationSupport.flattenAndConvertCodesR4(contains, codes);
                break;
            }
            case R4B: {
                ca.uhn.fhir.model.dstu2.resource.ValueSet expansionVs = (org.hl7.fhir.r4b.model.ValueSet)theExpansion;
                List contains = expansionVs.getExpansion().getContains();
                InMemoryTerminologyServerValidationSupport.flattenAndConvertCodesR4B(contains, codes);
                break;
            }
            case R5: {
                ca.uhn.fhir.model.dstu2.resource.ValueSet expansionVs = (org.hl7.fhir.r5.model.ValueSet)theExpansion;
                List contains = expansionVs.getExpansion().getContains();
                InMemoryTerminologyServerValidationSupport.flattenAndConvertCodesR5(contains, codes);
                break;
            }
            default: {
                throw new IllegalArgumentException(Msg.code((int)700) + "Can not handle version: " + this.myCtx.getVersion().getVersion());
            }
        }
        String codeSystemResourceName = null;
        String codeSystemResourceVersion = null;
        String codeSystemResourceContentMode = null;
        if (codeSystemToValidateResource != null) {
            switch (CommonCodeSystemsTerminologyService.getFhirVersionEnum(theValidationSupportContext.getRootValidationSupport().getFhirContext(), codeSystemToValidateResource)) {
                case DSTU2: 
                case DSTU2_HL7ORG: {
                    caseSensitive = true;
                    break;
                }
                case DSTU3: {
                    org.hl7.fhir.dstu3.model.CodeSystem systemDstu3 = (org.hl7.fhir.dstu3.model.CodeSystem)codeSystemToValidateResource;
                    caseSensitive = systemDstu3.getCaseSensitive();
                    codeSystemResourceName = systemDstu3.getName();
                    codeSystemResourceVersion = systemDstu3.getVersion();
                    codeSystemResourceContentMode = systemDstu3.getContentElement().getValueAsString();
                    break;
                }
                case R4: {
                    org.hl7.fhir.r4.model.CodeSystem systemR4 = (org.hl7.fhir.r4.model.CodeSystem)codeSystemToValidateResource;
                    caseSensitive = systemR4.getCaseSensitive();
                    codeSystemResourceName = systemR4.getName();
                    codeSystemResourceVersion = systemR4.getVersion();
                    codeSystemResourceContentMode = systemR4.getContentElement().getValueAsString();
                    break;
                }
                case R4B: {
                    CodeSystem systemR4B = (CodeSystem)codeSystemToValidateResource;
                    caseSensitive = systemR4B.getCaseSensitive();
                    codeSystemResourceName = systemR4B.getName();
                    codeSystemResourceVersion = systemR4B.getVersion();
                    codeSystemResourceContentMode = systemR4B.getContentElement().getValueAsString();
                    break;
                }
                case R5: {
                    org.hl7.fhir.r5.model.CodeSystem systemR5 = (org.hl7.fhir.r5.model.CodeSystem)codeSystemToValidateResource;
                    caseSensitive = systemR5.getCaseSensitive();
                    codeSystemResourceName = systemR5.getName();
                    codeSystemResourceVersion = systemR5.getVersion();
                    codeSystemResourceContentMode = systemR5.getContentElement().getValueAsString();
                    break;
                }
                default: {
                    throw new IllegalArgumentException(Msg.code((int)701) + "Can not handle version: " + this.myCtx.getVersion().getVersion());
                }
            }
        }
        String codeSystemUrlToValidate = null;
        String codeSystemVersionToValidate = null;
        if (theCodeSystemUrlAndVersionToValidate != null) {
            int versionIndex = theCodeSystemUrlAndVersionToValidate.indexOf(OUR_PIPE_CHARACTER);
            if (versionIndex > -1) {
                codeSystemUrlToValidate = theCodeSystemUrlAndVersionToValidate.substring(0, versionIndex);
                codeSystemVersionToValidate = theCodeSystemUrlAndVersionToValidate.substring(versionIndex + 1);
            } else {
                codeSystemUrlToValidate = theCodeSystemUrlAndVersionToValidate;
            }
        }
        for (FhirVersionIndependentConcept nextExpansionCode : codes) {
            boolean codeMatches = caseSensitive ? StringUtils.defaultString((String)theCodeToValidate).equals(nextExpansionCode.getCode()) : StringUtils.defaultString((String)theCodeToValidate).equalsIgnoreCase(nextExpansionCode.getCode());
            if (!codeMatches || !theOptions.isInferSystem() && (!nextExpansionCode.getSystem().equals(codeSystemUrlToValidate) || codeSystemVersionToValidate != null && !codeSystemVersionToValidate.equals(nextExpansionCode.getSystemVersion()))) continue;
            String csVersion = codeSystemResourceVersion;
            if (StringUtils.isNotBlank((CharSequence)nextExpansionCode.getSystemVersion())) {
                csVersion = nextExpansionCode.getSystemVersion();
            }
            if (!theOptions.isValidateDisplay() || StringUtils.isBlank((CharSequence)nextExpansionCode.getDisplay()) || StringUtils.isBlank((CharSequence)theDisplayToValidate) || nextExpansionCode.getDisplay().equals(theDisplayToValidate)) {
                IValidationSupport.CodeValidationResult codeValidationResult = new IValidationSupport.CodeValidationResult().setCode(theCodeToValidate).setDisplay(nextExpansionCode.getDisplay()).setCodeSystemName(codeSystemResourceName).setCodeSystemVersion(csVersion);
                if (StringUtils.isNotBlank((CharSequence)theValueSetUrl)) {
                    codeValidationResult.setMessage("Code was validated against in-memory expansion of ValueSet: " + theValueSetUrl);
                }
                return codeValidationResult;
            }
            String message2 = "Concept Display \"" + theDisplayToValidate + "\" does not match expected \"" + nextExpansionCode.getDisplay() + "\"";
            if (StringUtils.isNotBlank((CharSequence)theValueSetUrl)) {
                message2 = message2 + " for in-memory expansion of ValueSet: " + theValueSetUrl;
            }
            return new IValidationSupport.CodeValidationResult().setSeverity(IValidationSupport.IssueSeverity.ERROR).setDisplay(nextExpansionCode.getDisplay()).setMessage(message2).setCodeSystemName(codeSystemResourceName).setCodeSystemVersion(csVersion);
        }
        if ("fragment".equals(codeSystemResourceContentMode)) {
            severity = ValidationMessage.IssueSeverity.WARNING;
            message = "Unknown code in fragment CodeSystem '" + (String)(StringUtils.isNotBlank((CharSequence)theCodeSystemUrlAndVersionToValidate) ? theCodeSystemUrlAndVersionToValidate + "#" : "") + theCodeToValidate + "'";
        } else {
            severity = ValidationMessage.IssueSeverity.ERROR;
            message = "Unknown code '" + (String)(StringUtils.isNotBlank((CharSequence)theCodeSystemUrlAndVersionToValidate) ? theCodeSystemUrlAndVersionToValidate + "#" : "") + theCodeToValidate + "'";
        }
        if (StringUtils.isNotBlank((CharSequence)theValueSetUrl)) {
            message = message + " for in-memory expansion of ValueSet '" + theValueSetUrl + "'";
        }
        return new IValidationSupport.CodeValidationResult().setSeverityCode(severity.toCode()).setMessage(message);
    }

    public IValidationSupport.LookupCodeResult lookupCode(ValidationSupportContext theValidationSupportContext, String theSystem, String theCode, String theDisplayLanguage) {
        IValidationSupport.CodeValidationResult codeValidationResult = this.validateCode(theValidationSupportContext, new ConceptValidationOptions(), theSystem, theCode, null, null);
        if (codeValidationResult == null) {
            return null;
        }
        return codeValidationResult.asLookupCodeResult(theSystem, theCode);
    }

    @Nullable
    private org.hl7.fhir.r5.model.ValueSet expandValueSetDstu2Hl7Org(ValidationSupportContext theValidationSupportContext, org.hl7.fhir.dstu2.model.ValueSet theInput, @Nullable String theWantSystemUrlAndVersion, @Nullable String theWantCode) throws ExpansionCouldNotBeCompletedInternallyException {
        org.hl7.fhir.r5.model.ValueSet input = (org.hl7.fhir.r5.model.ValueSet)VersionConvertorFactory_10_50.convertResource((org.hl7.fhir.dstu2.model.Resource)theInput, (BaseAdvisor_10_50)new BaseAdvisor_10_50(Boolean.valueOf(false)));
        return this.expandValueSetR5(theValidationSupportContext, input, theWantSystemUrlAndVersion, theWantCode);
    }

    @Nullable
    private org.hl7.fhir.r5.model.ValueSet expandValueSetDstu2(ValidationSupportContext theValidationSupportContext, ca.uhn.fhir.model.dstu2.resource.ValueSet theInput, @Nullable String theWantSystemUrlAndVersion, @Nullable String theWantCode) throws ExpansionCouldNotBeCompletedInternallyException {
        IParser parserRi = FhirContext.forCached((FhirVersionEnum)FhirVersionEnum.DSTU2_HL7ORG).newJsonParser();
        IParser parserHapi = FhirContext.forDstu2Cached().newJsonParser();
        org.hl7.fhir.dstu2.model.ValueSet valueSetRi = (org.hl7.fhir.dstu2.model.ValueSet)parserRi.parseResource(org.hl7.fhir.dstu2.model.ValueSet.class, parserHapi.encodeResourceToString((IBaseResource)theInput));
        org.hl7.fhir.r5.model.ValueSet input = (org.hl7.fhir.r5.model.ValueSet)VersionConvertorFactory_10_50.convertResource((org.hl7.fhir.dstu2.model.Resource)valueSetRi, (BaseAdvisor_10_50)new BaseAdvisor_10_50(Boolean.valueOf(false)));
        return this.expandValueSetR5(theValidationSupportContext, input, theWantSystemUrlAndVersion, theWantCode);
    }

    public boolean isCodeSystemSupported(ValidationSupportContext theValidationSupportContext, String theSystem) {
        if (StringUtils.isBlank((CharSequence)theSystem)) {
            return false;
        }
        IBaseResource cs = theValidationSupportContext.getRootValidationSupport().fetchCodeSystem(theSystem);
        if (!this.myCtx.getVersion().getVersion().isEqualOrNewerThan(FhirVersionEnum.DSTU2_1)) {
            return cs != null;
        }
        if (cs != null) {
            IPrimitiveType content = (IPrimitiveType)this.getFhirContext().newTerser().getSingleValueOrNull((IBase)cs, "content", IPrimitiveType.class);
            return !"not-present".equals(content.getValueAsString());
        }
        return false;
    }

    public boolean isValueSetSupported(ValidationSupportContext theValidationSupportContext, String theValueSetUrl) {
        return StringUtils.isNotBlank((CharSequence)theValueSetUrl) && theValidationSupportContext.getRootValidationSupport().fetchValueSet(theValueSetUrl) != null;
    }

    private void addCodesDstu2Hl7Org(List<ValueSet.ConceptDefinitionComponent> theSourceList, List<CodeSystem.ConceptDefinitionComponent> theTargetList) {
        for (ValueSet.ConceptDefinitionComponent nextSource : theSourceList) {
            CodeSystem.ConceptDefinitionComponent targetConcept = new CodeSystem.ConceptDefinitionComponent().setCode(nextSource.getCode()).setDisplay(nextSource.getDisplay());
            theTargetList.add(targetConcept);
            this.addCodesDstu2Hl7Org(nextSource.getConcept(), targetConcept.getConcept());
        }
    }

    private void addCodesDstu2(List<ValueSet.CodeSystemConcept> theSourceList, List<CodeSystem.ConceptDefinitionComponent> theTargetList) {
        for (ValueSet.CodeSystemConcept nextSource : theSourceList) {
            CodeSystem.ConceptDefinitionComponent targetConcept = new CodeSystem.ConceptDefinitionComponent().setCode(nextSource.getCode()).setDisplay(nextSource.getDisplay());
            theTargetList.add(targetConcept);
            this.addCodesDstu2(nextSource.getConcept(), targetConcept.getConcept());
        }
    }

    @Nullable
    private org.hl7.fhir.r5.model.ValueSet expandValueSetDstu3(ValidationSupportContext theValidationSupportContext, ValueSet theInput, @Nullable String theWantSystemUrlAndVersion, @Nullable String theWantCode) throws ExpansionCouldNotBeCompletedInternallyException {
        org.hl7.fhir.r5.model.ValueSet input = (org.hl7.fhir.r5.model.ValueSet)VersionConvertorFactory_30_50.convertResource((org.hl7.fhir.dstu3.model.Resource)theInput, (BaseAdvisor_30_50)new BaseAdvisor_30_50(Boolean.valueOf(false)));
        return this.expandValueSetR5(theValidationSupportContext, input, theWantSystemUrlAndVersion, theWantCode);
    }

    @Nullable
    private org.hl7.fhir.r5.model.ValueSet expandValueSetR4(ValidationSupportContext theValidationSupportContext, org.hl7.fhir.r4.model.ValueSet theInput, @Nullable String theWantSystemUrlAndVersion, @Nullable String theWantCode) throws ExpansionCouldNotBeCompletedInternallyException {
        org.hl7.fhir.r5.model.ValueSet input = (org.hl7.fhir.r5.model.ValueSet)VersionConvertorFactory_40_50.convertResource((org.hl7.fhir.r4.model.Resource)theInput, (BaseAdvisor_40_50)new BaseAdvisor_40_50(Boolean.valueOf(false)));
        return this.expandValueSetR5(theValidationSupportContext, input, theWantSystemUrlAndVersion, theWantCode);
    }

    @Nullable
    private org.hl7.fhir.r5.model.ValueSet expandValueSetR4B(ValidationSupportContext theValidationSupportContext, org.hl7.fhir.r4b.model.ValueSet theInput, @Nullable String theWantSystemUrlAndVersion, @Nullable String theWantCode) throws ExpansionCouldNotBeCompletedInternallyException {
        org.hl7.fhir.r5.model.ValueSet input = (org.hl7.fhir.r5.model.ValueSet)VersionConvertorFactory_43_50.convertResource((org.hl7.fhir.r4b.model.Resource)theInput, (BaseAdvisor_43_50)new BaseAdvisor_43_50(Boolean.valueOf(false)));
        return this.expandValueSetR5(theValidationSupportContext, input, theWantSystemUrlAndVersion, theWantCode);
    }

    @Nullable
    private org.hl7.fhir.r5.model.ValueSet expandValueSetR5(ValidationSupportContext theValidationSupportContext, org.hl7.fhir.r5.model.ValueSet theInput) throws ExpansionCouldNotBeCompletedInternallyException {
        return this.expandValueSetR5(theValidationSupportContext, theInput, null, null);
    }

    @Nullable
    private org.hl7.fhir.r5.model.ValueSet expandValueSetR5(ValidationSupportContext theValidationSupportContext, org.hl7.fhir.r5.model.ValueSet theInput, @Nullable String theWantSystemUrlAndVersion, @Nullable String theWantCode) throws ExpansionCouldNotBeCompletedInternallyException {
        HashSet<FhirVersionIndependentConcept> concepts = new HashSet<FhirVersionIndependentConcept>();
        this.expandValueSetR5IncludeOrExcludes(theValidationSupportContext, concepts, theInput.getCompose().getInclude(), true, theWantSystemUrlAndVersion, theWantCode);
        this.expandValueSetR5IncludeOrExcludes(theValidationSupportContext, concepts, theInput.getCompose().getExclude(), false, theWantSystemUrlAndVersion, theWantCode);
        org.hl7.fhir.r5.model.ValueSet retVal = new org.hl7.fhir.r5.model.ValueSet();
        for (FhirVersionIndependentConcept next : concepts) {
            ValueSet.ValueSetExpansionContainsComponent contains = retVal.getExpansion().addContains();
            contains.setSystem(next.getSystem());
            contains.setCode(next.getCode());
            contains.setDisplay(next.getDisplay());
            contains.setVersion(next.getSystemVersion());
        }
        return retVal;
    }

    public void expandValueSetIncludeOrExclude(ValidationSupportContext theValidationSupportContext, Consumer<FhirVersionIndependentConcept> theConsumer, ValueSet.ConceptSetComponent theIncludeOrExclude) throws ExpansionCouldNotBeCompletedInternallyException {
        this.expandValueSetR5IncludeOrExclude(theValidationSupportContext, theConsumer, null, null, theIncludeOrExclude);
    }

    private void expandValueSetR5IncludeOrExcludes(ValidationSupportContext theValidationSupportContext, Set<FhirVersionIndependentConcept> theConcepts, List<ValueSet.ConceptSetComponent> theComposeList, boolean theComposeListIsInclude, @Nullable String theWantSystemUrlAndVersion, @Nullable String theWantCode) throws ExpansionCouldNotBeCompletedInternallyException {
        Consumer<FhirVersionIndependentConcept> consumer = c -> {
            if (theComposeListIsInclude) {
                theConcepts.add((FhirVersionIndependentConcept)c);
            } else {
                theConcepts.remove(c);
            }
        };
        this.expandValueSetR5IncludeOrExcludes(theValidationSupportContext, consumer, theComposeList, theWantSystemUrlAndVersion, theWantCode);
    }

    private void expandValueSetR5IncludeOrExcludes(ValidationSupportContext theValidationSupportContext, Consumer<FhirVersionIndependentConcept> theConsumer, List<ValueSet.ConceptSetComponent> theComposeList, @Nullable String theWantSystemUrlAndVersion, @Nullable String theWantCode) throws ExpansionCouldNotBeCompletedInternallyException {
        ExpansionCouldNotBeCompletedInternallyException caughtException = null;
        for (ValueSet.ConceptSetComponent nextInclude : theComposeList) {
            try {
                boolean outcome = this.expandValueSetR5IncludeOrExclude(theValidationSupportContext, theConsumer, theWantSystemUrlAndVersion, theWantCode, nextInclude);
                if (!StringUtils.isNotBlank((CharSequence)theWantCode) || !outcome) continue;
                return;
            }
            catch (ExpansionCouldNotBeCompletedInternallyException e) {
                if (StringUtils.isBlank((CharSequence)theWantCode)) {
                    throw e;
                }
                caughtException = e;
            }
        }
        if (caughtException != null) {
            throw caughtException;
        }
    }

    private boolean expandValueSetR5IncludeOrExclude(ValidationSupportContext theValidationSupportContext, Consumer<FhirVersionIndependentConcept> theConsumer, @Nullable String theWantSystemUrlAndVersion, @Nullable String theWantCode, ValueSet.ConceptSetComponent theInclude) throws ExpansionCouldNotBeCompletedInternallyException {
        String wantSystemUrl = null;
        String wantSystemVersion = null;
        if (theWantSystemUrlAndVersion != null) {
            int versionIndex = theWantSystemUrlAndVersion.indexOf(OUR_PIPE_CHARACTER);
            if (versionIndex > -1) {
                wantSystemUrl = theWantSystemUrlAndVersion.substring(0, versionIndex);
                wantSystemVersion = theWantSystemUrlAndVersion.substring(versionIndex + 1);
            } else {
                wantSystemUrl = theWantSystemUrlAndVersion;
            }
        }
        String includeOrExcludeConceptSystemUrl = theInclude.getSystem();
        String includeOrExcludeConceptSystemVersion = theInclude.getVersion();
        Function<String, org.hl7.fhir.r5.model.CodeSystem> codeSystemLoader = this.newCodeSystemLoader(theValidationSupportContext);
        Function<String, org.hl7.fhir.r5.model.ValueSet> valueSetLoader = this.newValueSetLoader(theValidationSupportContext);
        ArrayList<FhirVersionIndependentConcept> nextCodeList = new ArrayList<FhirVersionIndependentConcept>();
        org.hl7.fhir.r5.model.CodeSystem includeOrExcludeSystemResource = null;
        if (StringUtils.isNotBlank((CharSequence)includeOrExcludeConceptSystemUrl)) {
            includeOrExcludeConceptSystemVersion = this.optionallyPopulateVersionFromUrl(includeOrExcludeConceptSystemUrl, includeOrExcludeConceptSystemVersion);
            includeOrExcludeConceptSystemUrl = StringUtils.substringBefore((String)includeOrExcludeConceptSystemUrl, (String)OUR_PIPE_CHARACTER);
            if (wantSystemUrl != null && !wantSystemUrl.equals(includeOrExcludeConceptSystemUrl)) {
                return false;
            }
            if (wantSystemVersion != null && !wantSystemVersion.equals(includeOrExcludeConceptSystemVersion)) {
                return false;
            }
            Object loadedCodeSystemUrl = includeOrExcludeConceptSystemVersion != null ? includeOrExcludeConceptSystemUrl + OUR_PIPE_CHARACTER + includeOrExcludeConceptSystemVersion : includeOrExcludeConceptSystemUrl;
            includeOrExcludeSystemResource = codeSystemLoader.apply((String)loadedCodeSystemUrl);
            Set<String> wantCodes = theInclude.getConcept().isEmpty() ? null : theInclude.getConcept().stream().map(t -> t.getCode()).collect(Collectors.toSet());
            boolean ableToHandleCode = false;
            String failureMessage = null;
            FailureType failureType = FailureType.OTHER;
            if (includeOrExcludeSystemResource == null || includeOrExcludeSystemResource.getContent() == Enumerations.CodeSystemContentMode.NOTPRESENT) {
                if (theWantCode != null) {
                    List<CodeSystem.ConceptDefinitionComponent> codesList;
                    CodeSystem.ConceptDefinitionComponent conceptDefinition;
                    if (theValidationSupportContext.getRootValidationSupport().isCodeSystemSupported(theValidationSupportContext, includeOrExcludeConceptSystemUrl)) {
                        IValidationSupport.LookupCodeResult lookup = theValidationSupportContext.getRootValidationSupport().lookupCode(theValidationSupportContext, includeOrExcludeConceptSystemUrl, theWantCode, null);
                        if (lookup != null) {
                            ableToHandleCode = true;
                            if (lookup.isFound()) {
                                conceptDefinition = new CodeSystem.ConceptDefinitionComponent().addConcept().setCode(theWantCode).setDisplay(lookup.getCodeDisplay());
                                codesList = Collections.singletonList(conceptDefinition);
                                this.addCodes(includeOrExcludeConceptSystemUrl, includeOrExcludeConceptSystemVersion, codesList, nextCodeList, wantCodes);
                            }
                        }
                    } else if (Objects.equals(theInclude.getSystem(), theWantSystemUrlAndVersion)) {
                        Optional<ValueSet.ConceptReferenceComponent> matchingEnumeratedConcept = theInclude.getConcept().stream().filter(t -> Objects.equals(t.getCode(), theWantCode)).findFirst();
                        if (!theInclude.getConcept().isEmpty()) {
                            ableToHandleCode = true;
                        } else {
                            failureMessage = this.getFailureMessageForMissingOrUnusableCodeSystem(includeOrExcludeSystemResource, (String)loadedCodeSystemUrl);
                        }
                        if (matchingEnumeratedConcept.isPresent()) {
                            conceptDefinition = new CodeSystem.ConceptDefinitionComponent().addConcept().setCode(theWantCode).setDisplay(matchingEnumeratedConcept.get().getDisplay());
                            codesList = Collections.singletonList(conceptDefinition);
                            this.addCodes(includeOrExcludeConceptSystemUrl, includeOrExcludeConceptSystemVersion, codesList, nextCodeList, wantCodes);
                        }
                    }
                } else {
                    if (StringUtils.isNotBlank((CharSequence)theInclude.getSystem()) && !theInclude.getConcept().isEmpty() && theInclude.getFilter().isEmpty() && theInclude.getValueSet().isEmpty()) {
                        theInclude.getConcept().stream().map(t -> new FhirVersionIndependentConcept(theInclude.getSystem(), t.getCode(), t.getDisplay(), theInclude.getVersion())).forEach(t -> nextCodeList.add((FhirVersionIndependentConcept)t));
                        ableToHandleCode = true;
                    }
                    if (!ableToHandleCode) {
                        failureMessage = this.getFailureMessageForMissingOrUnusableCodeSystem(includeOrExcludeSystemResource, (String)loadedCodeSystemUrl);
                    }
                }
            } else {
                ableToHandleCode = true;
            }
            if (!ableToHandleCode) {
                if (includeOrExcludeSystemResource == null && failureMessage == null) {
                    failureMessage = this.getFailureMessageForMissingOrUnusableCodeSystem(includeOrExcludeSystemResource, (String)loadedCodeSystemUrl);
                }
                if (includeOrExcludeSystemResource == null) {
                    failureType = FailureType.UNKNOWN_CODE_SYSTEM;
                }
                throw new ExpansionCouldNotBeCompletedInternallyException(Msg.code((int)702) + failureMessage, failureType);
            }
            if (includeOrExcludeSystemResource != null && includeOrExcludeSystemResource.getContent() != Enumerations.CodeSystemContentMode.NOTPRESENT) {
                this.addCodes(includeOrExcludeConceptSystemUrl, includeOrExcludeConceptSystemVersion, includeOrExcludeSystemResource.getConcept(), nextCodeList, wantCodes);
            }
        }
        for (CanonicalType nextValueSetInclude : theInclude.getValueSet()) {
            org.hl7.fhir.r5.model.ValueSet vs = valueSetLoader.apply(nextValueSetInclude.getValueAsString());
            if (vs == null) continue;
            org.hl7.fhir.r5.model.ValueSet subExpansion = this.expandValueSetR5(theValidationSupportContext, vs, theWantSystemUrlAndVersion, theWantCode);
            if (subExpansion == null) {
                throw new ExpansionCouldNotBeCompletedInternallyException(Msg.code((int)703) + "Failed to expand ValueSet: " + nextValueSetInclude.getValueAsString(), FailureType.OTHER);
            }
            for (ValueSet.ValueSetExpansionContainsComponent next : subExpansion.getExpansion().getContains()) {
                nextCodeList.add(new FhirVersionIndependentConcept(next.getSystem(), next.getCode(), next.getDisplay(), next.getVersion()));
            }
        }
        boolean retVal = false;
        for (FhirVersionIndependentConcept next : nextCodeList) {
            boolean matches;
            if (includeOrExcludeSystemResource != null && theWantCode != null && !(matches = includeOrExcludeSystemResource.getCaseSensitive() ? theWantCode.equals(next.getCode()) : theWantCode.equalsIgnoreCase(next.getCode()))) continue;
            theConsumer.accept(next);
            retVal = true;
        }
        return retVal;
    }

    private Function<String, org.hl7.fhir.r5.model.ValueSet> newValueSetLoader(ValidationSupportContext theValidationSupportContext) {
        switch (this.myCtx.getVersion().getVersion()) {
            case DSTU2: 
            case DSTU2_HL7ORG: {
                return t -> {
                    IBaseResource vs = theValidationSupportContext.getRootValidationSupport().fetchValueSet(t);
                    if (vs instanceof ca.uhn.fhir.model.dstu2.resource.ValueSet) {
                        IParser parserRi = FhirContext.forCached((FhirVersionEnum)FhirVersionEnum.DSTU2_HL7ORG).newJsonParser();
                        IParser parserHapi = FhirContext.forDstu2Cached().newJsonParser();
                        ca.uhn.fhir.model.dstu2.resource.ValueSet valueSet = (ca.uhn.fhir.model.dstu2.resource.ValueSet)vs;
                        org.hl7.fhir.dstu2.model.ValueSet valueSetRi = (org.hl7.fhir.dstu2.model.ValueSet)parserRi.parseResource(org.hl7.fhir.dstu2.model.ValueSet.class, parserHapi.encodeResourceToString((IBaseResource)valueSet));
                        return (org.hl7.fhir.r5.model.ValueSet)VersionConvertorFactory_10_50.convertResource((org.hl7.fhir.dstu2.model.Resource)valueSetRi, (BaseAdvisor_10_50)new BaseAdvisor_10_50(Boolean.valueOf(false)));
                    }
                    org.hl7.fhir.dstu2.model.ValueSet valueSet = (org.hl7.fhir.dstu2.model.ValueSet)theValidationSupportContext.getRootValidationSupport().fetchValueSet(t);
                    return (org.hl7.fhir.r5.model.ValueSet)VersionConvertorFactory_10_50.convertResource((org.hl7.fhir.dstu2.model.Resource)valueSet, (BaseAdvisor_10_50)new BaseAdvisor_10_50(Boolean.valueOf(false)));
                };
            }
            case DSTU3: {
                return t -> {
                    ValueSet valueSet = (ValueSet)theValidationSupportContext.getRootValidationSupport().fetchValueSet(t);
                    return (org.hl7.fhir.r5.model.ValueSet)VersionConvertorFactory_30_50.convertResource((org.hl7.fhir.dstu3.model.Resource)valueSet, (BaseAdvisor_30_50)new BaseAdvisor_30_50(Boolean.valueOf(false)));
                };
            }
            case R4: {
                return t -> {
                    org.hl7.fhir.r4.model.ValueSet valueSet = (org.hl7.fhir.r4.model.ValueSet)theValidationSupportContext.getRootValidationSupport().fetchValueSet(t);
                    return (org.hl7.fhir.r5.model.ValueSet)VersionConvertorFactory_40_50.convertResource((org.hl7.fhir.r4.model.Resource)valueSet, (BaseAdvisor_40_50)new BaseAdvisor_40_50(Boolean.valueOf(false)));
                };
            }
            case R4B: {
                return t -> {
                    org.hl7.fhir.r4b.model.ValueSet valueSet = (org.hl7.fhir.r4b.model.ValueSet)theValidationSupportContext.getRootValidationSupport().fetchValueSet(t);
                    return (org.hl7.fhir.r5.model.ValueSet)VersionConvertorFactory_43_50.convertResource((org.hl7.fhir.r4b.model.Resource)valueSet, (BaseAdvisor_43_50)new BaseAdvisor_43_50(Boolean.valueOf(false)));
                };
            }
        }
        return t -> (org.hl7.fhir.r5.model.ValueSet)theValidationSupportContext.getRootValidationSupport().fetchValueSet(t);
    }

    private Function<String, org.hl7.fhir.r5.model.CodeSystem> newCodeSystemLoader(ValidationSupportContext theValidationSupportContext) {
        switch (this.myCtx.getVersion().getVersion()) {
            case DSTU2: 
            case DSTU2_HL7ORG: {
                return t -> {
                    IBaseResource codeSystem = theValidationSupportContext.getRootValidationSupport().fetchCodeSystem(t);
                    org.hl7.fhir.r5.model.CodeSystem retVal = null;
                    if (codeSystem != null) {
                        retVal = new org.hl7.fhir.r5.model.CodeSystem();
                        if (codeSystem instanceof ca.uhn.fhir.model.dstu2.resource.ValueSet) {
                            ca.uhn.fhir.model.dstu2.resource.ValueSet codeSystemCasted = (ca.uhn.fhir.model.dstu2.resource.ValueSet)codeSystem;
                            retVal.setUrl(codeSystemCasted.getUrl());
                            this.addCodesDstu2(codeSystemCasted.getCodeSystem().getConcept(), retVal.getConcept());
                        } else {
                            org.hl7.fhir.dstu2.model.ValueSet codeSystemCasted = (org.hl7.fhir.dstu2.model.ValueSet)codeSystem;
                            retVal.setUrl(codeSystemCasted.getUrl());
                            this.addCodesDstu2Hl7Org(codeSystemCasted.getCodeSystem().getConcept(), retVal.getConcept());
                        }
                    }
                    return retVal;
                };
            }
            case DSTU3: {
                return t -> {
                    org.hl7.fhir.dstu3.model.CodeSystem codeSystem = (org.hl7.fhir.dstu3.model.CodeSystem)theValidationSupportContext.getRootValidationSupport().fetchCodeSystem(t);
                    return (org.hl7.fhir.r5.model.CodeSystem)VersionConvertorFactory_30_50.convertResource((org.hl7.fhir.dstu3.model.Resource)codeSystem, (BaseAdvisor_30_50)new BaseAdvisor_30_50(Boolean.valueOf(false)));
                };
            }
            case R4: {
                return t -> {
                    org.hl7.fhir.r4.model.CodeSystem codeSystem = (org.hl7.fhir.r4.model.CodeSystem)theValidationSupportContext.getRootValidationSupport().fetchCodeSystem(t);
                    return (org.hl7.fhir.r5.model.CodeSystem)VersionConvertorFactory_40_50.convertResource((org.hl7.fhir.r4.model.Resource)codeSystem, (BaseAdvisor_40_50)new BaseAdvisor_40_50(Boolean.valueOf(false)));
                };
            }
            case R4B: {
                return t -> {
                    CodeSystem codeSystem = (CodeSystem)theValidationSupportContext.getRootValidationSupport().fetchCodeSystem(t);
                    return (org.hl7.fhir.r5.model.CodeSystem)VersionConvertorFactory_43_50.convertResource((org.hl7.fhir.r4b.model.Resource)codeSystem, (BaseAdvisor_43_50)new BaseAdvisor_43_50(Boolean.valueOf(false)));
                };
            }
        }
        return t -> (org.hl7.fhir.r5.model.CodeSystem)theValidationSupportContext.getRootValidationSupport().fetchCodeSystem(t);
    }

    private String getFailureMessageForMissingOrUnusableCodeSystem(org.hl7.fhir.r5.model.CodeSystem includeOrExcludeSystemResource, String loadedCodeSystemUrl) {
        String failureMessage;
        if (includeOrExcludeSystemResource == null) {
            failureMessage = "Unable to expand ValueSet because CodeSystem could not be found: " + loadedCodeSystemUrl;
        } else {
            assert (includeOrExcludeSystemResource.getContent() == Enumerations.CodeSystemContentMode.NOTPRESENT);
            failureMessage = "Unable to expand ValueSet because CodeSystem has CodeSystem.content=not-present but contents were not found: " + loadedCodeSystemUrl;
        }
        return failureMessage;
    }

    private void addCodes(String theCodeSystemUrl, String theCodeSystemVersion, List<CodeSystem.ConceptDefinitionComponent> theSource, List<FhirVersionIndependentConcept> theTarget, Set<String> theCodeFilter) {
        for (CodeSystem.ConceptDefinitionComponent next : theSource) {
            if (StringUtils.isNotBlank((CharSequence)next.getCode()) && (theCodeFilter == null || theCodeFilter.contains(next.getCode()))) {
                theTarget.add(new FhirVersionIndependentConcept(theCodeSystemUrl, next.getCode(), next.getDisplay(), theCodeSystemVersion));
            }
            this.addCodes(theCodeSystemUrl, theCodeSystemVersion, next.getConcept(), theTarget, theCodeFilter);
        }
    }

    private String optionallyPopulateVersionFromUrl(String theSystemUrl, String theVersion) {
        if (StringUtils.contains((CharSequence)theSystemUrl, (CharSequence)OUR_PIPE_CHARACTER) && StringUtils.isBlank((CharSequence)theVersion)) {
            theVersion = StringUtils.substringAfter((String)theSystemUrl, (String)OUR_PIPE_CHARACTER);
        }
        return theVersion;
    }

    private static void flattenAndConvertCodesDstu2(List<ValueSet.ExpansionContains> theInput, List<FhirVersionIndependentConcept> theFhirVersionIndependentConcepts) {
        for (ValueSet.ExpansionContains next : theInput) {
            theFhirVersionIndependentConcepts.add(new FhirVersionIndependentConcept(next.getSystem(), next.getCode(), next.getDisplay()));
            InMemoryTerminologyServerValidationSupport.flattenAndConvertCodesDstu2(next.getContains(), theFhirVersionIndependentConcepts);
        }
    }

    private static void flattenAndConvertCodesDstu2Hl7Org(List<ValueSet.ValueSetExpansionContainsComponent> theInput, List<FhirVersionIndependentConcept> theFhirVersionIndependentConcepts) {
        for (ValueSet.ValueSetExpansionContainsComponent next : theInput) {
            theFhirVersionIndependentConcepts.add(new FhirVersionIndependentConcept(next.getSystem(), next.getCode(), next.getDisplay()));
            InMemoryTerminologyServerValidationSupport.flattenAndConvertCodesDstu2Hl7Org(next.getContains(), theFhirVersionIndependentConcepts);
        }
    }

    private static void flattenAndConvertCodesDstu3(List<ValueSet.ValueSetExpansionContainsComponent> theInput, List<FhirVersionIndependentConcept> theFhirVersionIndependentConcepts) {
        for (ValueSet.ValueSetExpansionContainsComponent next : theInput) {
            theFhirVersionIndependentConcepts.add(new FhirVersionIndependentConcept(next.getSystem(), next.getCode(), next.getDisplay(), next.getVersion()));
            InMemoryTerminologyServerValidationSupport.flattenAndConvertCodesDstu3(next.getContains(), theFhirVersionIndependentConcepts);
        }
    }

    private static void flattenAndConvertCodesR4(List<ValueSet.ValueSetExpansionContainsComponent> theInput, List<FhirVersionIndependentConcept> theFhirVersionIndependentConcepts) {
        for (ValueSet.ValueSetExpansionContainsComponent next : theInput) {
            theFhirVersionIndependentConcepts.add(new FhirVersionIndependentConcept(next.getSystem(), next.getCode(), next.getDisplay(), next.getVersion()));
            InMemoryTerminologyServerValidationSupport.flattenAndConvertCodesR4(next.getContains(), theFhirVersionIndependentConcepts);
        }
    }

    private static void flattenAndConvertCodesR4B(List<ValueSet.ValueSetExpansionContainsComponent> theInput, List<FhirVersionIndependentConcept> theFhirVersionIndependentConcepts) {
        for (ValueSet.ValueSetExpansionContainsComponent next : theInput) {
            theFhirVersionIndependentConcepts.add(new FhirVersionIndependentConcept(next.getSystem(), next.getCode(), next.getDisplay(), next.getVersion()));
            InMemoryTerminologyServerValidationSupport.flattenAndConvertCodesR4B(next.getContains(), theFhirVersionIndependentConcepts);
        }
    }

    private static void flattenAndConvertCodesR5(List<ValueSet.ValueSetExpansionContainsComponent> theInput, List<FhirVersionIndependentConcept> theFhirVersionIndependentConcepts) {
        for (ValueSet.ValueSetExpansionContainsComponent next : theInput) {
            theFhirVersionIndependentConcepts.add(new FhirVersionIndependentConcept(next.getSystem(), next.getCode(), next.getDisplay(), next.getVersion()));
            InMemoryTerminologyServerValidationSupport.flattenAndConvertCodesR5(next.getContains(), theFhirVersionIndependentConcepts);
        }
    }

    public static class ExpansionCouldNotBeCompletedInternallyException
    extends Exception {
        private static final long serialVersionUID = -2226561628771483085L;
        private final FailureType myFailureType;

        public ExpansionCouldNotBeCompletedInternallyException(String theMessage, FailureType theFailureType) {
            super(theMessage);
            this.myFailureType = theFailureType;
        }

        public FailureType getFailureType() {
            return this.myFailureType;
        }
    }

    public static enum FailureType {
        UNKNOWN_CODE_SYSTEM,
        OTHER;

    }
}

