/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.common.hapi.validation.validator;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.sl.cache.CacheFactory;
import ca.uhn.fhir.sl.cache.LoadingCache;
import ca.uhn.fhir.system.HapiSystemProperties;
import ca.uhn.hapi.converters.canonical.VersionCanonicalizer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.fhir.ucum.UcumService;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.TerminologyServiceException;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.context.IWorkerContextManager;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.PackageInformation;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.profilemodel.PEBuilder;
import org.hl7.fhir.r5.terminologies.expansion.ValueSetExpansionOutcome;
import org.hl7.fhir.r5.terminologies.utilities.TerminologyServiceErrorClass;
import org.hl7.fhir.r5.utils.validation.IResourceValidator;
import org.hl7.fhir.r5.utils.validation.ValidationContextCarrier;
import org.hl7.fhir.utilities.TimeTracker;
import org.hl7.fhir.utilities.TranslationServices;
import org.hl7.fhir.utilities.i18n.I18nBase;
import org.hl7.fhir.utilities.npm.BasePackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionSpecificWorkerContextWrapper
extends I18nBase
implements IWorkerContext {
    private static final Logger ourLog = LoggerFactory.getLogger(VersionSpecificWorkerContextWrapper.class);
    private final ValidationSupportContext myValidationSupportContext;
    private final VersionCanonicalizer myVersionCanonicalizer;
    private final LoadingCache<ResourceKey, IBaseResource> myFetchResourceCache;
    private volatile List<StructureDefinition> myAllStructures;
    private Parameters myExpansionProfile;

    public VersionSpecificWorkerContextWrapper(ValidationSupportContext theValidationSupportContext, VersionCanonicalizer theVersionCanonicalizer) {
        this.myValidationSupportContext = theValidationSupportContext;
        this.myVersionCanonicalizer = theVersionCanonicalizer;
        long timeoutMillis = HapiSystemProperties.getTestValidationResourceCachesMs();
        this.myFetchResourceCache = CacheFactory.build((long)timeoutMillis, (long)10000L, key -> {
            StructureDefinition canonicalSd;
            String fetchResourceName = key.getResourceName();
            if (this.myValidationSupportContext.getRootValidationSupport().getFhirContext().getVersion().getVersion() == FhirVersionEnum.DSTU2 && "CodeSystem".equals(fetchResourceName)) {
                fetchResourceName = "ValueSet";
            }
            Class fetchResourceType = fetchResourceName.equals("Resource") ? null : this.myValidationSupportContext.getRootValidationSupport().getFhirContext().getResourceDefinition(fetchResourceName).getImplementingClass();
            IBaseResource fetched = this.myValidationSupportContext.getRootValidationSupport().fetchResource(fetchResourceType, key.getUri());
            Resource canonical = this.myVersionCanonicalizer.resourceToValidatorCanonical(fetched);
            if (canonical instanceof StructureDefinition && (canonicalSd = (StructureDefinition)canonical).getSnapshot().isEmpty()) {
                ourLog.info("Generating snapshot for StructureDefinition: {}", (Object)canonicalSd.getUrl());
                fetched = this.myValidationSupportContext.getRootValidationSupport().generateSnapshot(theValidationSupportContext, fetched, "", null, "");
                Validate.isTrue((fetched != null ? 1 : 0) != 0, (String)"StructureDefinition %s has no snapshot, and no snapshot generator is configured", (Object[])new Object[]{key.getUri()});
                canonical = this.myVersionCanonicalizer.resourceToValidatorCanonical(fetched);
            }
            return canonical;
        });
        this.setValidationMessageLanguage(this.getLocale());
    }

    public Set<String> getBinaryKeysAsSet() {
        throw new UnsupportedOperationException(Msg.code((int)2118));
    }

    public boolean hasBinaryKey(String s) {
        return this.myValidationSupportContext.getRootValidationSupport().fetchBinary(s) != null;
    }

    public byte[] getBinaryForKey(String s) {
        return this.myValidationSupportContext.getRootValidationSupport().fetchBinary(s);
    }

    public int loadFromPackage(NpmPackage pi, IWorkerContext.IContextResourceLoader loader) throws FHIRException {
        throw new UnsupportedOperationException(Msg.code((int)652));
    }

    public int loadFromPackage(NpmPackage pi, IWorkerContext.IContextResourceLoader loader, List<String> types) throws FileNotFoundException, IOException, FHIRException {
        throw new UnsupportedOperationException(Msg.code((int)653));
    }

    public int loadFromPackageAndDependencies(NpmPackage pi, IWorkerContext.IContextResourceLoader loader, BasePackageCacheManager pcm) throws FHIRException {
        throw new UnsupportedOperationException(Msg.code((int)654));
    }

    public boolean hasPackage(String id, String ver) {
        throw new UnsupportedOperationException(Msg.code((int)655));
    }

    public boolean hasPackage(PackageInformation packageInformation) {
        return false;
    }

    public PackageInformation getPackage(String id, String ver) {
        return null;
    }

    public int getClientRetryCount() {
        throw new UnsupportedOperationException(Msg.code((int)656));
    }

    public IWorkerContext setClientRetryCount(int value) {
        throw new UnsupportedOperationException(Msg.code((int)657));
    }

    public TimeTracker clock() {
        return null;
    }

    public IWorkerContextManager.IPackageLoadingTracker getPackageTracker() {
        throw new UnsupportedOperationException(Msg.code((int)2235));
    }

    public IWorkerContext setPackageTracker(IWorkerContextManager.IPackageLoadingTracker packageTracker) {
        throw new UnsupportedOperationException(Msg.code((int)2266));
    }

    public String getSpecUrl() {
        return "";
    }

    public PEBuilder getProfiledElementBuilder(PEBuilder.PEElementPropertiesPolicy thePEElementPropertiesPolicy, boolean theB) {
        throw new UnsupportedOperationException(Msg.code((int)2264));
    }

    public PackageInformation getPackageForUrl(String s) {
        throw new UnsupportedOperationException(Msg.code((int)2236));
    }

    public Parameters getExpansionParameters() {
        return this.myExpansionProfile;
    }

    public void setExpansionProfile(Parameters expParameters) {
        this.myExpansionProfile = expParameters;
    }

    private List<StructureDefinition> allStructures() {
        List<StructureDefinition> retVal = this.myAllStructures;
        if (retVal == null) {
            retVal = new ArrayList<StructureDefinition>();
            for (IBaseResource next : this.myValidationSupportContext.getRootValidationSupport().fetchAllStructureDefinitions()) {
                try {
                    StructureDefinition converted = this.myVersionCanonicalizer.structureDefinitionToCanonical(next);
                    retVal.add(converted);
                }
                catch (FHIRException e) {
                    throw new InternalErrorException(Msg.code((int)659) + e);
                }
            }
            this.myAllStructures = retVal;
        }
        return retVal;
    }

    public void cacheResource(Resource res) {
    }

    public void cacheResourceFromPackage(Resource res, PackageInformation packageDetails) throws FHIRException {
    }

    public void cachePackage(PackageInformation packageInformation) {
    }

    @Nonnull
    private IWorkerContext.ValidationResult convertValidationResult(String theSystem, @Nullable IValidationSupport.CodeValidationResult theResult) {
        IWorkerContext.ValidationResult retVal = null;
        if (theResult != null) {
            String code = theResult.getCode();
            String display = theResult.getDisplay();
            String issueSeverityCode = theResult.getSeverityCode();
            String message = theResult.getMessage();
            ValidationMessage.IssueSeverity issueSeverity = null;
            if (issueSeverityCode != null) {
                issueSeverity = ValidationMessage.IssueSeverity.fromCode((String)issueSeverityCode);
            } else if (StringUtils.isNotBlank((CharSequence)message)) {
                issueSeverity = ValidationMessage.IssueSeverity.INFORMATION;
            }
            CodeSystem.ConceptDefinitionComponent conceptDefinitionComponent = null;
            if (code != null) {
                conceptDefinitionComponent = new CodeSystem.ConceptDefinitionComponent().setCode(code).setDisplay(display);
            }
            retVal = new IWorkerContext.ValidationResult(issueSeverity, message, theSystem, theResult.getCodeSystemVersion(), conceptDefinitionComponent, display, null);
        }
        if (retVal == null) {
            retVal = new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, "Validation failed", null);
        }
        return retVal;
    }

    public ValueSetExpansionOutcome expandVS(ValueSet source, boolean cacheOk, boolean Hierarchical) {
        IBaseResource convertedSource;
        try {
            convertedSource = this.myVersionCanonicalizer.valueSetFromValidatorCanonical(source);
        }
        catch (FHIRException e) {
            throw new InternalErrorException(Msg.code((int)661) + e);
        }
        IValidationSupport.ValueSetExpansionOutcome expanded = this.myValidationSupportContext.getRootValidationSupport().expandValueSet(this.myValidationSupportContext, null, convertedSource);
        ValueSet convertedResult = null;
        if (expanded.getValueSet() != null) {
            try {
                convertedResult = this.myVersionCanonicalizer.valueSetToValidatorCanonical(expanded.getValueSet());
            }
            catch (FHIRException e) {
                throw new InternalErrorException(Msg.code((int)662) + e);
            }
        }
        String error = expanded.getError();
        TerminologyServiceErrorClass result = null;
        return new ValueSetExpansionOutcome(convertedResult, error, result);
    }

    public ValueSetExpansionOutcome expandVS(Resource src, ElementDefinition.ElementDefinitionBindingComponent binding, boolean cacheOk, boolean Hierarchical) {
        throw new UnsupportedOperationException(Msg.code((int)663));
    }

    public ValueSetExpansionOutcome expandVS(ValueSet.ConceptSetComponent inc, boolean hierarchical, boolean noInactive) throws TerminologyServiceException {
        throw new UnsupportedOperationException(Msg.code((int)664));
    }

    public Locale getLocale() {
        return this.myValidationSupportContext.getRootValidationSupport().getFhirContext().getLocalizer().getLocale();
    }

    public void setLocale(Locale locale) {
    }

    public CodeSystem fetchCodeSystem(String system) {
        IBaseResource fetched = this.myValidationSupportContext.getRootValidationSupport().fetchCodeSystem(system);
        if (fetched == null) {
            return null;
        }
        try {
            return this.myVersionCanonicalizer.codeSystemToValidatorCanonical(fetched);
        }
        catch (FHIRException e) {
            throw new InternalErrorException(Msg.code((int)665) + e);
        }
    }

    public CodeSystem fetchCodeSystem(String system, String verison) {
        IBaseResource fetched = this.myValidationSupportContext.getRootValidationSupport().fetchCodeSystem(system);
        if (fetched == null) {
            return null;
        }
        try {
            return this.myVersionCanonicalizer.codeSystemToValidatorCanonical(fetched);
        }
        catch (FHIRException e) {
            throw new InternalErrorException(Msg.code((int)1992) + e);
        }
    }

    public CodeSystem fetchSupplementedCodeSystem(String system) {
        return null;
    }

    public CodeSystem fetchSupplementedCodeSystem(String system, String version) {
        return null;
    }

    public <T extends Resource> T fetchResourceRaw(Class<T> class_, String uri) {
        return this.fetchResource(class_, uri);
    }

    public <T extends Resource> T fetchResource(Class<T> class_, String uri) {
        if (StringUtils.isBlank((CharSequence)uri)) {
            return null;
        }
        ResourceKey key = new ResourceKey(class_.getSimpleName(), uri);
        Resource retVal = (Resource)this.myFetchResourceCache.get((Object)key);
        return (T)retVal;
    }

    public Resource fetchResourceById(String type, String uri) {
        throw new UnsupportedOperationException(Msg.code((int)666));
    }

    public <T extends Resource> T fetchResourceWithException(Class<T> class_, String uri) throws FHIRException {
        T retVal = this.fetchResource(class_, uri);
        if (retVal == null) {
            throw new FHIRException(Msg.code((int)667) + "Can not find resource of type " + class_.getSimpleName() + " with uri " + uri);
        }
        return retVal;
    }

    public <T extends Resource> T fetchResource(Class<T> class_, String uri, String version) {
        return this.fetchResource(class_, uri + "|" + version);
    }

    public <T extends Resource> T fetchResource(Class<T> class_, String uri, Resource canonicalForSource) {
        return this.fetchResource(class_, uri);
    }

    public <T extends Resource> T fetchResourceWithException(Class<T> class_, String uri, Resource sourceOfReference) throws FHIRException {
        throw new UnsupportedOperationException(Msg.code((int)2214));
    }

    public List<String> getResourceNames() {
        return new ArrayList<String>(this.myValidationSupportContext.getRootValidationSupport().getFhirContext().getResourceTypes());
    }

    public Set<String> getResourceNamesAsSet() {
        return this.myValidationSupportContext.getRootValidationSupport().getFhirContext().getResourceTypes();
    }

    public StructureDefinition fetchTypeDefinition(String typeName) {
        return this.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + typeName);
    }

    public List<StructureDefinition> fetchTypeDefinitions(String typeName) {
        ArrayList<StructureDefinition> allStructures = new ArrayList<StructureDefinition>(this.allStructures());
        allStructures.removeIf(sd -> !sd.hasType() || !sd.getType().equals(typeName));
        return allStructures;
    }

    public UcumService getUcumService() {
        throw new UnsupportedOperationException(Msg.code((int)676));
    }

    public void setUcumService(UcumService ucumService) {
        throw new UnsupportedOperationException(Msg.code((int)677));
    }

    public String getVersion() {
        return this.myValidationSupportContext.getRootValidationSupport().getFhirContext().getVersion().getVersion().getFhirVersionString();
    }

    public <T extends Resource> boolean hasResource(Class<T> class_, String uri) {
        throw new UnsupportedOperationException(Msg.code((int)680));
    }

    public boolean isNoTerminologyServer() {
        return false;
    }

    public Set<String> getCodeSystemsUsed() {
        throw new UnsupportedOperationException(Msg.code((int)681));
    }

    public IResourceValidator newValidator() {
        throw new UnsupportedOperationException(Msg.code((int)684));
    }

    public Map<String, NamingSystem> getNSUrlMap() {
        throw new UnsupportedOperationException(Msg.code((int)2265));
    }

    public IWorkerContext.ILoggingService getLogger() {
        return null;
    }

    public void setLogger(IWorkerContext.ILoggingService logger) {
        throw new UnsupportedOperationException(Msg.code((int)687));
    }

    public boolean supportsSystem(String system) {
        return this.myValidationSupportContext.getRootValidationSupport().isCodeSystemSupported(this.myValidationSupportContext, system);
    }

    public TranslationServices translator() {
        throw new UnsupportedOperationException(Msg.code((int)688));
    }

    public ValueSetExpansionOutcome expandVS(ValueSet source, boolean cacheOk, boolean heiarchical, boolean incompleteOk) {
        return null;
    }

    public IWorkerContext.ValidationResult validateCode(ValidationOptions theOptions, String system, String version, String code, String display) {
        ConceptValidationOptions validationOptions = VersionSpecificWorkerContextWrapper.convertConceptValidationOptions(theOptions);
        return this.doValidation(null, validationOptions, system, code, display);
    }

    public IWorkerContext.ValidationResult validateCode(ValidationOptions theOptions, String theSystem, String version, String theCode, String display, ValueSet theValueSet) {
        IBaseResource convertedVs = null;
        try {
            if (theValueSet != null) {
                convertedVs = this.myVersionCanonicalizer.valueSetFromValidatorCanonical(theValueSet);
            }
        }
        catch (FHIRException e) {
            throw new InternalErrorException(Msg.code((int)689) + e);
        }
        ConceptValidationOptions validationOptions = VersionSpecificWorkerContextWrapper.convertConceptValidationOptions(theOptions);
        return this.doValidation(convertedVs, validationOptions, theSystem, theCode, display);
    }

    public IWorkerContext.ValidationResult validateCode(ValidationOptions theOptions, String code, ValueSet theValueSet) {
        IBaseResource convertedVs = null;
        try {
            if (theValueSet != null) {
                convertedVs = this.myVersionCanonicalizer.valueSetFromValidatorCanonical(theValueSet);
            }
        }
        catch (FHIRException e) {
            throw new InternalErrorException(Msg.code((int)690) + e);
        }
        ConceptValidationOptions validationOptions = VersionSpecificWorkerContextWrapper.convertConceptValidationOptions(theOptions).setInferSystem(true);
        return this.doValidation(convertedVs, validationOptions, null, code, null);
    }

    public IWorkerContext.ValidationResult validateCode(ValidationOptions theOptions, Coding theCoding, ValueSet theValueSet) {
        IBaseResource convertedVs = null;
        try {
            if (theValueSet != null) {
                convertedVs = this.myVersionCanonicalizer.valueSetFromValidatorCanonical(theValueSet);
            }
        }
        catch (FHIRException e) {
            throw new InternalErrorException(Msg.code((int)691) + e);
        }
        ConceptValidationOptions validationOptions = VersionSpecificWorkerContextWrapper.convertConceptValidationOptions(theOptions);
        String system = theCoding.getSystem();
        String code = theCoding.getCode();
        String display = theCoding.getDisplay();
        return this.doValidation(convertedVs, validationOptions, system, code, display);
    }

    public IWorkerContext.ValidationResult validateCode(ValidationOptions options, Coding code, ValueSet vs, ValidationContextCarrier ctxt) {
        return this.validateCode(options, code, vs);
    }

    public void validateCodeBatch(ValidationOptions options, List<? extends IWorkerContext.CodingValidationRequest> codes, ValueSet vs) {
        for (IWorkerContext.CodingValidationRequest codingValidationRequest : codes) {
            IWorkerContext.ValidationResult outcome = this.validateCode(options, codingValidationRequest.getCoding(), vs);
            codingValidationRequest.setResult(outcome);
        }
    }

    @Nonnull
    private IWorkerContext.ValidationResult doValidation(IBaseResource theValueSet, ConceptValidationOptions theValidationOptions, String theSystem, String theCode, String theDisplay) {
        IValidationSupport.CodeValidationResult result = theValueSet != null ? this.myValidationSupportContext.getRootValidationSupport().validateCodeInValueSet(this.myValidationSupportContext, theValidationOptions, theSystem, theCode, theDisplay, theValueSet) : this.myValidationSupportContext.getRootValidationSupport().validateCode(this.myValidationSupportContext, theValidationOptions, theSystem, theCode, theDisplay, null);
        return this.convertValidationResult(theSystem, result);
    }

    public IWorkerContext.ValidationResult validateCode(ValidationOptions theOptions, CodeableConcept code, ValueSet theVs) {
        ArrayList<IWorkerContext.ValidationResult> validationResultsOk = new ArrayList<IWorkerContext.ValidationResult>();
        for (Coding next : code.getCoding()) {
            IWorkerContext.ValidationResult retVal = this.validateCode(theOptions, next, theVs);
            if (!retVal.isOk()) continue;
            if (this.myValidationSupportContext.isEnabledValidationForCodingsLogicalAnd()) {
                validationResultsOk.add(retVal);
                continue;
            }
            return retVal;
        }
        if (code.getCoding().size() > 0 && validationResultsOk.size() == code.getCoding().size()) {
            return (IWorkerContext.ValidationResult)validationResultsOk.get(0);
        }
        return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, null, null);
    }

    public void invalidateCaches() {
        this.myFetchResourceCache.invalidateAll();
    }

    public <T extends Resource> List<T> fetchResourcesByType(Class<T> theClass) {
        if (theClass.equals(StructureDefinition.class)) {
            return this.allStructures();
        }
        throw new UnsupportedOperationException(Msg.code((int)650) + "Unable to fetch resources of type: " + theClass);
    }

    public boolean isForPublication() {
        return false;
    }

    public void setForPublication(boolean b) {
        throw new UnsupportedOperationException(Msg.code((int)2351));
    }

    public static ConceptValidationOptions convertConceptValidationOptions(ValidationOptions theOptions) {
        ConceptValidationOptions retVal = new ConceptValidationOptions();
        if (theOptions.isGuessSystem()) {
            retVal = retVal.setInferSystem(true);
        }
        return retVal;
    }

    @Nonnull
    public static VersionSpecificWorkerContextWrapper newVersionSpecificWorkerContextWrapper(IValidationSupport theValidationSupport) {
        VersionCanonicalizer versionCanonicalizer = new VersionCanonicalizer(theValidationSupport.getFhirContext());
        return new VersionSpecificWorkerContextWrapper(new ValidationSupportContext(theValidationSupport), versionCanonicalizer);
    }

    private static class ResourceKey {
        private final int myHashCode;
        private final String myResourceName;
        private final String myUri;

        private ResourceKey(String theResourceName, String theUri) {
            this.myResourceName = theResourceName;
            this.myUri = theUri;
            this.myHashCode = new HashCodeBuilder(17, 37).append((Object)this.myResourceName).append((Object)this.myUri).toHashCode();
        }

        public boolean equals(Object theO) {
            if (this == theO) {
                return true;
            }
            if (theO == null || this.getClass() != theO.getClass()) {
                return false;
            }
            ResourceKey that = (ResourceKey)theO;
            return new EqualsBuilder().append((Object)this.myResourceName, (Object)that.myResourceName).append((Object)this.myUri, (Object)that.myUri).isEquals();
        }

        public String getResourceName() {
            return this.myResourceName;
        }

        public String getUri() {
            return this.myUri;
        }

        public int hashCode() {
            return this.myHashCode;
        }
    }
}

