/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.common.hapi.validation.support;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.parser.IParserErrorHandler;
import ca.uhn.fhir.parser.LenientErrorHandler;
import ca.uhn.fhir.util.ClasspathUtil;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import org.hl7.fhir.common.hapi.validation.support.PrePopulatedValidationSupport;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.npm.NpmPackage;

public class NpmPackageValidationSupport
extends PrePopulatedValidationSupport {
    public NpmPackageValidationSupport(@Nonnull FhirContext theFhirContext) {
        super(theFhirContext);
    }

    public void loadPackageFromClasspath(String theClasspath) throws IOException {
        try (InputStream is = ClasspathUtil.loadResourceAsStream((String)theClasspath);){
            NpmPackage pkg = NpmPackage.fromPackage((InputStream)is);
            if (pkg.getFolders().containsKey("package")) {
                this.loadResourcesFromPackage(pkg);
                this.loadBinariesFromPackage(pkg);
            }
        }
    }

    private void loadResourcesFromPackage(NpmPackage thePackage) {
        NpmPackage.NpmPackageFolder packageFolder = (NpmPackage.NpmPackageFolder)thePackage.getFolders().get("package");
        for (String nextFile : packageFolder.listFiles()) {
            if (!nextFile.toLowerCase(Locale.US).endsWith(".json")) continue;
            String input = new String((byte[])packageFolder.getContent().get(nextFile), StandardCharsets.UTF_8);
            IParser parser = this.getFhirContext().newJsonParser();
            parser.setParserErrorHandler((IParserErrorHandler)new LenientErrorHandler(false));
            IBaseResource resource = parser.parseResource(input);
            super.addResource(resource);
        }
    }

    private void loadBinariesFromPackage(NpmPackage thePackage) throws IOException {
        List binaries = thePackage.list("other");
        for (String binaryName : binaries) {
            this.addBinary(TextFile.streamToBytes((InputStream)thePackage.load("other", binaryName)), binaryName);
        }
    }
}

