/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.common.hapi.validation.support;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.LookupCodeRequest;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.common.hapi.validation.support.BaseValidationSupport;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnknownCodeSystemWarningValidationSupport
extends BaseValidationSupport {
    private static final Logger ourLog = LoggerFactory.getLogger(UnknownCodeSystemWarningValidationSupport.class);
    public static final IValidationSupport.IssueSeverity DEFAULT_SEVERITY = IValidationSupport.IssueSeverity.ERROR;
    private IValidationSupport.IssueSeverity myNonExistentCodeSystemSeverity = DEFAULT_SEVERITY;

    public UnknownCodeSystemWarningValidationSupport(FhirContext theFhirContext) {
        super(theFhirContext);
    }

    public String getName() {
        return this.getFhirContext().getVersion().getVersion() + " Unknown Code System Warning Validation Support";
    }

    public boolean isValueSetSupported(ValidationSupportContext theValidationSupportContext, String theValueSetUrl) {
        return true;
    }

    public boolean isCodeSystemSupported(ValidationSupportContext theValidationSupportContext, String theSystem) {
        return this.canValidateCodeSystem(theValidationSupportContext, theSystem);
    }

    @Nullable
    public IValidationSupport.LookupCodeResult lookupCode(ValidationSupportContext theValidationSupportContext, @Nonnull LookupCodeRequest theLookupCodeRequest) {
        if (this.canValidateCodeSystem(theValidationSupportContext, theLookupCodeRequest.getSystem())) {
            return new IValidationSupport.LookupCodeResult().setFound(true);
        }
        return null;
    }

    public IValidationSupport.CodeValidationResult validateCode(@Nonnull ValidationSupportContext theValidationSupportContext, @Nonnull ConceptValidationOptions theOptions, String theCodeSystem, String theCode, String theDisplay, String theValueSetUrl) {
        if (!this.canValidateCodeSystem(theValidationSupportContext, theCodeSystem)) {
            return null;
        }
        IValidationSupport.CodeValidationResult result = new IValidationSupport.CodeValidationResult();
        result.setSeverity(this.myNonExistentCodeSystemSeverity);
        String theMessage = "CodeSystem is unknown and can't be validated: " + theCodeSystem + " for '" + theCodeSystem + "#" + theCode + "'";
        result.setMessage(theMessage);
        if (this.myNonExistentCodeSystemSeverity == IValidationSupport.IssueSeverity.INFORMATION) {
            result.setCode(theCode);
            result.setSeverity(null);
            result.setMessage(null);
        } else {
            result.addCodeValidationIssue(new IValidationSupport.CodeValidationIssue(theMessage, this.myNonExistentCodeSystemSeverity, IValidationSupport.CodeValidationIssueCode.NOT_FOUND, IValidationSupport.CodeValidationIssueCoding.NOT_FOUND));
        }
        return result;
    }

    @Nullable
    public IValidationSupport.CodeValidationResult validateCodeInValueSet(ValidationSupportContext theValidationSupportContext, ConceptValidationOptions theOptions, String theCodeSystem, String theCode, String theDisplay, @Nonnull IBaseResource theValueSet) {
        if (!this.canValidateCodeSystem(theValidationSupportContext, theCodeSystem)) {
            return null;
        }
        return new IValidationSupport.CodeValidationResult().setCode(theCode).setSeverity(IValidationSupport.IssueSeverity.INFORMATION).setMessage("Code " + theCodeSystem + "#" + theCode + " was not checked because the CodeSystem is not available");
    }

    private boolean allowNonExistentCodeSystems() {
        switch (this.myNonExistentCodeSystemSeverity) {
            case ERROR: 
            case FATAL: {
                return false;
            }
            case WARNING: 
            case INFORMATION: {
                return true;
            }
        }
        ourLog.info("Unknown issue severity " + this.myNonExistentCodeSystemSeverity.name() + ". Treating as INFO/WARNING");
        return true;
    }

    private boolean canValidateCodeSystem(ValidationSupportContext theValidationSupportContext, String theCodeSystem) {
        if (!this.allowNonExistentCodeSystems()) {
            return false;
        }
        if (theCodeSystem == null) {
            return false;
        }
        IBaseResource codeSystem = theValidationSupportContext.getRootValidationSupport().fetchCodeSystem(theCodeSystem);
        return codeSystem == null;
    }

    @Deprecated
    public void setAllowNonExistentCodeSystem(boolean theAllowNonExistentCodeSystem) {
        if (theAllowNonExistentCodeSystem) {
            this.setNonExistentCodeSystemSeverity(IValidationSupport.IssueSeverity.WARNING);
        } else {
            this.setNonExistentCodeSystemSeverity(IValidationSupport.IssueSeverity.ERROR);
        }
    }

    public void setNonExistentCodeSystemSeverity(@Nonnull IValidationSupport.IssueSeverity theSeverity) {
        Validate.notNull((Object)theSeverity, (String)"theSeverity must not be null", (Object[])new Object[0]);
        this.myNonExistentCodeSystemSeverity = theSeverity;
    }
}

